/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils;

import java.io.PrintStream;
import org.tinfour.utils.KahanSummation;

public class BasicTabulator {
    final KahanSummation sumV = new KahanSummation();
    final KahanSummation sumV2 = new KahanSummation();
    final KahanSummation sumAbsV = new KahanSummation();
    double maxV = Double.NEGATIVE_INFINITY;
    double minV = Double.POSITIVE_INFINITY;
    double maxAbsV = Double.NEGATIVE_INFINITY;
    double minAbsV = Double.POSITIVE_INFINITY;
    int nD;
    int nNaN;

    public void tabulate(double value) {
        if (Double.isFinite(value)) {
            double d2 = value * value;
            double dAbs = Math.abs(value);
            ++this.nD;
            this.sumV.add(value);
            this.sumV2.add(d2);
            this.sumAbsV.add(dAbs);
            if (value < this.minV) {
                this.minV = value;
            }
            if (value > this.maxV) {
                this.maxV = value;
            }
            if (dAbs < this.minAbsV) {
                this.minAbsV = dAbs;
            }
            if (dAbs > this.maxAbsV) {
                this.maxAbsV = dAbs;
            }
        } else {
            ++this.nNaN;
        }
    }

    public double getMeanAbsValue() {
        if (this.nD == 0) {
            return 0.0;
        }
        return this.sumAbsV.getMean();
    }

    public double getMean() {
        if (this.nD == 0) {
            return 0.0;
        }
        return this.sumV.getMean();
    }

    public double getStdDevAbsValue() {
        if (this.nD < 2) {
            return 0.0;
        }
        double sD2 = this.sumV2.getSum();
        double sD = this.sumAbsV.getSum();
        return Math.sqrt((sD2 - sD / (double)this.nD * sD) / (double)(this.nD - 1));
    }

    public double getStdDev() {
        if (this.nD < 2) {
            return 0.0;
        }
        double sD2 = this.sumV2.getSum();
        double sD = this.sumV.getSum();
        return Math.sqrt((sD2 - sD / (double)this.nD * sD) / (double)(this.nD - 1));
    }

    public double getMinValue() {
        return this.minV;
    }

    public double getMaxValue() {
        return this.maxV;
    }

    public double getMinAbsValue() {
        return this.minAbsV;
    }

    public double getMaxAbsValue() {
        return this.maxAbsV;
    }

    public int getNumberSamples() {
        return this.nD;
    }

    public int getNumberNonFiniteSamples() {
        return this.nNaN;
    }

    public static void printCaption(PrintStream ps) {
        ps.println("                                 mean          sigma      min       max       mean (abs)    sigma (abs)    min       max");
    }

    public void summarize(PrintStream ps, String label) {
        String s = label == null || label.isEmpty() ? "" : (label.length() > 25 ? label.substring(0, 25) : label);
        double mean = this.getMean();
        double sigma = this.getStdDev();
        double absMean = this.getMeanAbsValue();
        double absSigma = this.getStdDevAbsValue();
        double absMin = this.getMinAbsValue();
        double absMax = this.getMaxAbsValue();
        ps.format("%-25.25s %13.6f %13.6f %9.3f %9.3f %13.6f %13.6f %9.3f %9.3f%n", s, mean, sigma, this.getMinValue(), this.getMaxValue(), absMean, absSigma, absMin, absMax);
    }

    public void summarizeAbsValues(PrintStream ps, String label) {
        String s = label == null || label.isEmpty() ? "" : (label.length() > 25 ? label.substring(0, 25) : label);
        double mean = this.getMeanAbsValue();
        double sigma = this.getStdDevAbsValue();
        ps.format("%-25.25s %13.6f %13.6f %9.3f %9.3f%n", s, mean, sigma, this.getMinAbsValue(), this.getMaxAbsValue());
    }
}

