/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils;

import java.io.PrintStream;

public class VisvalingamLineSimplification {
    private long nProcessed;
    private long nRemoved;
    private long nOperations;

    public int simplify(int nPoints, double[] xy, double areaThreshold) {
        int ix;
        int i;
        int nMin;
        if (nPoints < 2) {
            return nPoints;
        }
        int n = nPoints;
        int k = 2;
        for (int i2 = 2; i2 < n * 2; i2 += 2) {
            if (xy[i2] == xy[k - 2] && xy[i2 + 1] == xy[k - 1]) continue;
            if (k < i2) {
                xy[k] = xy[i2];
                xy[k + 1] = xy[i2 + 1];
            }
            k += 2;
        }
        n = k / 2;
        boolean closedLoop = xy[0] == xy[n * 2 - 2] && xy[1] == xy[n * 2 - 1];
        int n2 = nMin = closedLoop ? 4 : 2;
        if (n == nMin) {
            return nPoints;
        }
        ++this.nOperations;
        this.nProcessed += (long)nPoints;
        if (areaThreshold == 0.0) {
            this.nRemoved += (long)(nPoints - n);
            return nPoints;
        }
        double[] a = new double[n];
        a[0] = Double.POSITIVE_INFINITY;
        a[nPoints - 1] = Double.POSITIVE_INFINITY;
        int iMin = 0;
        double aMin = Double.POSITIVE_INFINITY;
        for (i = 1; i < n - 1; ++i) {
            ix = i * 2 - 2;
            double xOffset = xy[ix++];
            double yOffset = xy[ix++];
            double x0 = xy[ix++] - xOffset;
            double y0 = xy[ix++] - yOffset;
            double x1 = xy[ix++] - xOffset;
            double y1 = xy[ix++] - yOffset;
            a[i] = Math.abs(x0 * y1 - x1 * y0) / 2.0;
            if (!(a[i] < aMin)) continue;
            aMin = a[i];
            iMin = i;
        }
        while (aMin <= areaThreshold) {
            int i3;
            for (i = iMin; i < n - 1; ++i) {
                ix = i * 2;
                xy[ix] = xy[ix + 2];
                xy[ix + 1] = xy[ix + 3];
                a[i] = a[i + 1];
            }
            if (--n == nMin) break;
            int i0 = iMin == 1 ? 1 : iMin - 1;
            int i1 = iMin >= n - 2 ? n - 2 : iMin + 1;
            for (i3 = i0; i3 <= i1; ++i3) {
                int ix2 = i3 * 2 - 2;
                double xOffset = xy[ix2++];
                double yOffset = xy[ix2++];
                double x0 = xy[ix2++] - xOffset;
                double y0 = xy[ix2++] - yOffset;
                double x1 = xy[ix2++] - xOffset;
                double y1 = xy[ix2++] - yOffset;
                a[i3] = Math.abs(x0 * y1 - x1 * y0) / 2.0;
            }
            aMin = a[1];
            iMin = 1;
            for (i3 = 2; i3 < n - 1; ++i3) {
                if (!(a[i3] < aMin)) continue;
                aMin = a[i3];
                iMin = i3;
            }
        }
        k = 2;
        for (i = 2; i < n * 2; i += 2) {
            if (xy[i] == xy[k - 2] && xy[i + 1] == xy[k - 1]) continue;
            if (k < i) {
                xy[k] = xy[i];
                xy[k + 1] = xy[i + 1];
            }
            k += 2;
        }
        n = k / 2;
        this.nRemoved += (long)(nPoints - n);
        return n;
    }

    public void report(PrintStream ps) {
        ps.format("Visvalingam nFeatures=%d, nPointsInput=%d, nRemoved=%d%n", this.nOperations, this.nProcessed, this.nRemoved);
    }
}

