/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils.rendering;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;

public class RenderingTransformAid {
    private final double unitPerPixel;
    private final AffineTransform c2p;
    private final AffineTransform p2c;
    private final Rectangle2D domainRectangle;

    public RenderingTransformAid(int width, int height, int pad, double x0, double y0, double x1, double y1) {
        if (pad < 0) {
            throw new IllegalArgumentException("Negative pad value not allowed");
        }
        if (width - 2 * pad < 1 || height - 2 * pad < 1) {
            throw new IllegalArgumentException("Width and height (minus padding) too small");
        }
        if (Double.isNaN(x0) || Double.isNaN(x1) || x1 == x0) {
            throw new IllegalArgumentException("Improper domain for x coordinates [" + x0 + ", " + x1 + "]");
        }
        if (Double.isNaN(y0) || Double.isNaN(y1) || y1 == y0) {
            throw new IllegalArgumentException("Improper domain for x coordinates [" + y0 + ", " + y1 + "]");
        }
        double rImage = (double)(width - pad) / (double)(height - pad);
        double rData = (x1 - x0) / (y1 - y0);
        double rAspect = rImage / rData;
        this.unitPerPixel = rAspect >= 1.0 ? (y1 - y0) / (double)(height - pad) : (x1 - x0) / (double)(width - pad);
        double scale = 1.0 / this.unitPerPixel;
        double xCenter = (x0 + x1) / 2.0;
        double yCenter = (y0 + y1) / 2.0;
        double xOffset = (double)((width - pad) / 2) - scale * xCenter + (double)(pad / 2);
        double yOffset = (double)((height - pad) / 2) + scale * yCenter + (double)(pad / 2);
        this.c2p = new AffineTransform(scale, 0.0, 0.0, -scale, xOffset, yOffset);
        try {
            this.p2c = this.c2p.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            throw new IllegalArgumentException("Input elements result in a degenerate transform: " + ex.getMessage(), ex);
        }
        double[] c = new double[8];
        c[0] = x0;
        c[1] = y0;
        c[2] = x1;
        c[3] = y1;
        this.c2p.transform(c, 0, c, 4, 2);
        this.domainRectangle = new Rectangle2D.Double(c[4], c[7], c[6] - c[4], c[5] - c[7]);
    }

    public AffineTransform getCartesianToPixelTransform() {
        return this.c2p;
    }

    public AffineTransform getPixelToCartesianTransform() {
        return this.p2c;
    }

    public Rectangle2D getDomainRectangle() {
        return this.domainRectangle;
    }

    public double getUnitsPerPixel() {
        return this.unitPerPixel;
    }

    public double getPixelsPerUnit() {
        return 1.0 / this.unitPerPixel;
    }
}

