/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.tinspin.wrappers;

import ch.ethz.globis.tinspin.TestStats;
import java.util.List;
import java.util.Random;

public abstract class Candidate {
    public abstract void release();

    public abstract void load(double[] var1, int var2);

    public abstract Object preparePointQuery(double[][] var1);

    @Deprecated
    public int pointQuery(Object qA) {
        return this.pointQuery(qA, new int[0]);
    }

    public int pointQuery(Object qA, int[] ids) {
        return this.pointQuery(qA);
    }

    public double knnQuery(int k, double[] center) {
        if (k < 1 || center == null) {
            throw new IllegalArgumentException();
        }
        return -1.0;
    }

    public abstract int unload();

    public abstract int query(double[] var1, double[] var2);

    @Deprecated
    public int update(double[][] updateTable) {
        return this.update(updateTable, new int[0]);
    }

    public int update(double[][] updateTable, int[] updateIDs) {
        return this.update(updateTable);
    }

    public List<?> queryToList(double[] min, double[] max) {
        if (min == null || max == null) {
            throw new IllegalArgumentException();
        }
        throw new UnsupportedOperationException();
    }

    protected void run(Candidate x, int N, int DIM) {
        int NPQ = 1000;
        Random R = new Random(0L);
        double[] data = new double[N * DIM];
        for (int i = 0; i < N * DIM; ++i) {
            data[i] = R.nextDouble();
        }
        long t1 = System.currentTimeMillis();
        x.load(data, DIM);
        long t2 = System.currentTimeMillis();
        System.out.println("load time [ms]: " + (t2 - t1) + " ms");
        double[][] qA = new double[][]{{0.0, 0.0, 0.0}, {0.02, 0.02, 0.02}};
        Object qAP = x.preparePointQuery(qA);
        t1 = System.currentTimeMillis();
        int np = 0;
        for (int i = 0; i < NPQ; ++i) {
            np += x.pointQuery(qAP);
        }
        t2 = System.currentTimeMillis();
        System.out.println("point query: " + np);
        System.out.println("point query time [ms]: " + (t2 - t1) + "  = " + (t2 - t1) / (long)NPQ + " ms/q");
        double[][] qD = new double[NPQ][];
        for (int i = 0; i < NPQ; ++i) {
            double[] q = new double[DIM << 1];
            for (int j = 0; j < DIM; ++j) {
                q[j * 2] = data[i * DIM + j];
                q[j * 2 + 1] = data[i * DIM + j] + 0.001;
            }
            qD[i] = q;
        }
        int nq = 0;
        t1 = System.currentTimeMillis();
        for (int i = 0; i < NPQ; ++i) {
            if (i % 10 != 0) continue;
            System.out.print('.');
        }
        t2 = System.currentTimeMillis();
        System.out.println();
        System.out.println("range query: " + nq);
        System.out.println("range query time [ms]: " + (t2 - t1) + "  = " + (t2 - t1) / (long)NPQ + " ms/q");
    }

    protected void runSmokeTest(Candidate x, int dims) {
        double[] data = new double[]{0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.04, 0.04, 0.04};
        int N = data.length / dims;
        int NPQ = 1000 < N ? 1000 : N;
        int NQ = 1;
        long t1 = System.currentTimeMillis();
        x.load(data, dims);
        long t2 = System.currentTimeMillis();
        System.out.println("load time [ms]: " + (t2 - t1) + " ms");
        double[][] qA = new double[][]{{0.0, 0.0, 0.0}, {0.02, 0.02, 0.02}};
        Object qAP = x.preparePointQuery(qA);
        t1 = System.currentTimeMillis();
        int np = 0;
        for (int i = 0; i < NPQ; ++i) {
            np += x.pointQuery(qAP);
        }
        t2 = System.currentTimeMillis();
        System.out.println("point query hits: " + np);
        System.out.println("point query time [ms]: " + (t2 - t1) + "  = " + (t2 - t1) / (long)NPQ + " ms/q");
        double[][] qDLow = new double[NPQ][];
        double[][] qDUpp = new double[NPQ][];
        for (int i = 0; i < NPQ; ++i) {
            double[] qLow = new double[dims];
            double[] qUpp = new double[dims];
            for (int j = 0; j < dims; ++j) {
                qLow[j] = data[i * dims + j];
                qUpp[j] = data[i * dims + j] + 0.001;
            }
            qDLow[i] = qLow;
            qDUpp[i] = qUpp;
        }
        int nq = 0;
        t1 = System.currentTimeMillis();
        for (int i = 0; i < NQ; ++i) {
            nq += x.query(qDLow[i], qDUpp[i]);
            if (i % 10 != 0) continue;
            System.out.print('.');
        }
        t2 = System.currentTimeMillis();
        System.out.println();
        System.out.println("range query hits: " + nq);
        System.out.println("range query time [ms]: " + (t2 - t1) + "  = " + (t2 - t1) / (long)NPQ + " ms/q");
        int nu = x.unload();
        System.out.println("unload: " + nu);
    }

    public void getStats(TestStats S) {
        assert (S != null);
    }

    public boolean supportsWindowQuery() {
        return true;
    }

    public boolean supportsPointQuery() {
        return true;
    }

    public boolean supportsKNN() {
        return false;
    }

    public boolean supportsUpdate() {
        return true;
    }

    public boolean supportsUnload() {
        return true;
    }

    static double dist(double[] a, double[] b) {
        double dist = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double d = a[i] - b[i];
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    static double distRCenter(double[] center, double[] rLower, double[] rUpper) {
        double dist = 0.0;
        for (int i = 0; i < center.length; ++i) {
            double d = center[i] - (rUpper[i] + rLower[i]) / 2.0;
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    static double distREdge(double[] center, double[] rLower, double[] rUpper) {
        double dist = 0.0;
        for (int i = 0; i < center.length; ++i) {
            double d = 0.0;
            if (center[i] > rUpper[i]) {
                d = center[i] - rUpper[i];
            } else if (center[i] < rLower[i]) {
                d = rLower[i] - center[i];
            }
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    public Object getNative() {
        return "(Not obligatory) Please return the native implementation of the index here.";
    }

    public String getNativeStats() {
        return "(Not obligatory) Please return the native stats of the index here.";
    }

    public String toString() {
        return "Please provide configuration information for  every test candidate class in the toString() method.";
    }
}

