/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.tinspin;

import ch.ethz.globis.tinspin.IndexHandle;
import ch.ethz.globis.tinspin.TestHandle;
import ch.ethz.globis.tinspin.data.AbstractTest;
import ch.ethz.globis.tinspin.wrappers.Candidate;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class TestStats
implements Serializable,
Cloneable {
    public static final double DEFAULT_DATA_LEN = 1.0;
    public static final double DEFAULT_RECT_LEN = 1.0E-5;
    public static final int DEFAULT_DUPLICATES = 1;
    public static int DEFAULT_CFG_REPEAT = 3;
    public static int DEFAULT_W_QUERY_SIZE = 1000;
    public static int DEFAULT_N_WINDOW_QUERY = 1000;
    public static int DEFAULT_N_POINT_QUERY = 100000;
    public static int DEFAULT_N_KNN_QUERY = 10000;
    public static int DEFAULT_N_UPDATES = 100000;
    public static int DEFAULT_N_UPDATE_CYCLES = 10;
    private static final long serialVersionUID = 1L;
    int cfgNRepeat = DEFAULT_CFG_REPEAT;
    public int cfgNBits = 64;
    public int cfgNDims;
    public int cfgNEntries;
    public int cfgKnnQueryBaseRepeat = DEFAULT_N_KNN_QUERY;
    public int cfgPointQueryRepeat = DEFAULT_N_POINT_QUERY;
    public int cfgUpdateRepeat = DEFAULT_N_UPDATE_CYCLES;
    public int cfgUpdateSize = DEFAULT_N_UPDATES;
    public int cfgWindowQueryRepeat = DEFAULT_N_WINDOW_QUERY;
    public int cfgWindowQuerySize = DEFAULT_W_QUERY_SIZE;
    public double cfgDataLen = 1.0;
    public double cfgRectLen = 1.0E-5;
    public int cfgDuplicates = 1;
    public final IndexHandle INDEX;
    public final TestHandle TEST;
    public String SEEDmsg;
    public long seed;
    public final double param1;
    public double param2;
    public String paramStr;
    public String paramStr2;
    public boolean paramEnforceGC = true;
    public final boolean isRangeData;
    public boolean isMultimap = false;
    public double minimumMsPerTest = 2000.0;
    Class<? extends AbstractTest> testClass;
    Class<? extends Candidate> indexClass;
    public long statTGen;
    public long statTLoad;
    public long statTUnload;
    public long statTq1;
    public long statTq1E;
    public long statTq2;
    public long statTq2E;
    public long statTqp1;
    public long statTqp1E;
    public long statTqp2;
    public long statTqp2E;
    public long statTqk1_1;
    public long statTqk1_1E;
    public long statTqk1_2;
    public long statTqk1_2E;
    public long statTqk10_1;
    public long statTqk10_1E;
    public long statTqk10_2;
    public long statTqk10_2E;
    public long statTu1;
    public long statTu1E;
    public long statTu2;
    public long statTu2E;
    public long statPSLoad;
    public long statPSUnload;
    public long statPSq1;
    public long statPSq1E;
    public long statPSq2;
    public long statPSq2E;
    public long statPSqp1;
    public long statPSqp1E;
    public long statPSqp2;
    public long statPSqp2E;
    public long statPSqk1_1;
    public long statPSqk1_1E;
    public long statPSqk1_2;
    public long statPSqk1_2E;
    public long statPSqk10_1;
    public long statPSqk10_1E;
    public long statPSqk10_2;
    public long statPSqk10_2E;
    public long statPSu1;
    public long statPSu1E;
    public long statPSu2;
    public long statPSu2E;
    public int statNnodes;
    public long statNpostlen;
    public int statNNodeAHC;
    public long statNDistCalc;
    public long statNDistCalc1NN;
    public long statNDistCalcKNN;
    public int statNNodeNT;
    public int statNNodeInternalNT;
    public int statNq1;
    public int statNq2;
    public int statNqp1;
    public int statNqp2;
    public double statDqk1_1;
    public double statDqk1_2;
    public double statDqk10_1;
    public double statDqk10_2;
    public int statNu1;
    public int statNu2;
    public long statSCalc;
    public long statSjvmF;
    public long statSjvmE;
    public long statGcDiffL;
    public long statGcTimeL;
    public long statGcDiffWq;
    public long statGcTimeWq;
    public long statGcDiffPq;
    public long statGcTimePq;
    public long statGcDiffUp;
    public long statGcTimeUp;
    public long statGcDiffK1;
    public long statGcTimeK1;
    public long statGcDiffK10;
    public long statGcTimeK10;
    public long statGcDiffUl;
    public long statGcTimeUl;
    public String assortedInfo = "";
    Throwable exception = null;

    public TestStats(TestHandle test, IndexHandle index, int N, int DIM, double param1) {
        this(test, index, N, DIM, test.isRangeData(), param1, 0.0);
    }

    public TestStats(TestHandle test, IndexHandle index, int N, int DIM, boolean isRangeData, double param1, double param2) {
        this.cfgNEntries = N;
        this.cfgNDims = DIM;
        this.INDEX = index;
        this.TEST = test;
        this.SEEDmsg = "" + this.seed;
        this.isRangeData = isRangeData;
        this.param1 = param1;
        this.param2 = param2;
    }

    public TestStats setDuplicates(int duplicates) {
        this.cfgDuplicates = duplicates;
        return this;
    }

    public void setFailed(Throwable t) {
        this.SEEDmsg = this.SEEDmsg + "-F";
        this.exception = t;
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.SEEDmsg = Long.toString(seed);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public TestStats cloneStats() {
        try {
            return (TestStats)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] testHeaderOld() {
        String D = "\t";
        String[][] h2 = new String[][]{{"Index", "data", "dim", "bits", "N", "calcMem", "memory", "memory/n", "gen", "load", "load/n", "q1/n", "q2/n", "pq1/n", "pq2/n", "up1/n", "up2/n", "1-NN1", "1-NN2", "10-NN1", "10-NN2", "unload", "unload/n", "nodes", "postLen", "AHC", "NT", "NTinternal", "q1-n", "q2-n", "q1p-n", "q2p-n", "up1-n", "up2-n", "d1-1NN", "d2-1NN", "d1-kNN", "d2-kNN", "load-s", "load-t", "w-query-s", "w-query-t", "p-query-s", "p-query-t", "update-s", "update-t", "1-NN-s", "1-NN-t", "10-NN-s", "10-NN-t", "unload-s", "unload-t", "msg"}};
        String[] ret = new String[h2.length];
        for (int i = 0; i < h2.length; ++i) {
            StringBuilder sb = new StringBuilder();
            for (String col : h2[i]) {
                sb.append(col);
                sb.append(D);
            }
            ret[i] = sb.toString();
        }
        return ret;
    }

    public static String[] testHeaderNew() {
        String D = "\t";
        String[][] h2 = new String[][]{{"Index", "data", "dim", "bits", "N", "memory", "memory/n", "gen", "load/s", "wq1/s", "wq2/s", "pq1/s", "pq2/s", "1-NN1/s", "1-NN2/s", "10-NN1/s", "10-NN2/s", "up1/s", "up2/s", "unload/s", "dummy1", "dummy2", "dummy3", "dummy4", "nodes", "postLen", "AHC", "NT", "NTinternal", "wq1-n", "wq2-n", "pq1-n", "pq2-n", "1-NN1-d", "1-NN2-2", "10-NN1-d", "10-NN2-d", "up1-n", "up2-n", "distCalc-n", "distCalc1NN-n", "distCalcKNN-n", "dummy-n", "load-s", "load-t", "w-query-s", "w-query-t", "p-query-s", "p-query-t", "update-s", "update-t", "1-NN-s", "1-NN-t", "10-NN-s", "10-NN-t", "unload-s", "unload-t", "wq-size", "wq-repeat", "msg"}};
        String[] ret = new String[h2.length];
        for (int i = 0; i < h2.length; ++i) {
            StringBuilder sb = new StringBuilder();
            for (String col : h2[i]) {
                sb.append(col);
                sb.append(D);
            }
            ret[i] = sb.toString();
        }
        return ret;
    }

    public String testDescription1() {
        String ret = "";
        ret = ret + this.INDEX.name();
        ret = ret + "-" + (this.isRangeData ? "R" : "P");
        ret = ret + "-" + (this.isMultimap ? "MM" : "M");
        return ret;
    }

    public String testDescription2() {
        return this.TEST.name() + "(" + this.cfgDuplicates + "," + this.param1 + "," + this.param2 + "," + this.paramStr + "," + this.paramStr2 + ")";
    }

    public String toString() {
        return this.toStringNew();
    }

    public String toStringOld() {
        String D = "\t";
        String ret = "";
        ret = ret + this.testDescription1() + "-" + this.SEEDmsg + D;
        ret = ret + this.testDescription2() + D;
        ret = ret + this.cfgNDims + D + this.cfgNBits + D + this.cfgNEntries + D;
        ret = ret + (this.statSCalc >> 20) + D + this.statSjvmF + D + this.statSjvmE + D;
        ret = ret + this.statTGen + D;
        ret = ret + this.statTLoad + D + this.statTLoad * 1000000L / (long)this.cfgNEntries + D;
        ret = ret + this.statTq1E + D + this.statTq2E + D + this.statTqp1E + D + this.statTqp2E + D;
        ret = ret + this.statTu1E + D + this.statTu2E + D;
        ret = ret + this.statTqk1_1E + D + this.statTqk1_2E + D;
        ret = ret + this.statTqk10_1E + D + this.statTqk10_2E + D;
        ret = ret + this.statTUnload + D + this.statTUnload * 1000000L / (long)this.cfgNEntries + D;
        ret = ret + this.statNnodes + D + this.statNpostlen + D + this.statNNodeAHC + D + this.statNNodeNT + D + this.statNNodeInternalNT + D;
        ret = ret + this.statNq1 + D + this.statNq2 + D + this.statNqp1 + D + this.statNqp2 + D;
        ret = ret + this.statNu1 + D + this.statNu2 + D;
        ret = ret + this.statDqk1_1 + D + this.statDqk1_2 + D + this.statDqk10_1 + D + this.statDqk10_2 + D;
        ret = ret + this.statGcDiffL / 1000000L + D + this.statGcTimeL + D;
        ret = ret + this.statGcDiffWq / 1000000L + D + this.statGcTimeWq + D;
        ret = ret + this.statGcDiffPq / 1000000L + D + this.statGcTimePq + D;
        ret = ret + this.statGcDiffUp / 1000000L + D + this.statGcTimeUp + D;
        ret = ret + this.statGcDiffK1 / 1000000L + D + this.statGcTimeK1 + D;
        ret = ret + this.statGcDiffK10 / 1000000L + D + this.statGcTimeK10 + D;
        ret = ret + this.statGcDiffUl / 1000000L + D + this.statGcTimeUl + D;
        ret = ret + this.assortedInfo;
        if (this.exception != null) {
            ret = ret + D + this.exception.getMessage();
        }
        return ret;
    }

    public String toStringNew() {
        String D = "\t";
        String ret = "";
        ret = ret + this.testDescription1() + "-" + this.SEEDmsg + D;
        ret = ret + this.testDescription2() + D;
        ret = ret + this.cfgNDims + D + this.cfgNBits + D + this.cfgNEntries + D;
        ret = ret + this.statSjvmF + D + this.statSjvmE + D;
        ret = ret + this.statTGen + D;
        ret = ret + this.statPSLoad + D;
        ret = ret + this.statPSq1 + D + this.statPSq2 + D;
        ret = ret + this.statPSqp1 + D + this.statPSqp2 + D;
        ret = ret + this.statPSqk1_1 + D + this.statPSqk1_2 + D;
        ret = ret + this.statPSqk10_1 + D + this.statPSqk10_2 + D;
        ret = ret + this.statPSu1E + D + this.statPSu2E + D;
        ret = ret + this.statPSUnload + D;
        ret = ret + 0 + D + 0 + D;
        ret = ret + 0 + D + 0 + D;
        ret = ret + this.statNnodes + D + this.statNpostlen + D + this.statNNodeAHC + D + this.statNNodeNT + D + this.statNNodeInternalNT + D;
        ret = ret + this.statNq1 + D + this.statNq2 + D + this.statNqp1 + D + this.statNqp2 + D;
        ret = ret + this.statDqk1_1 + D + this.statDqk1_2 + D + this.statDqk10_1 + D + this.statDqk10_2 + D;
        ret = ret + this.statNu1 + D + this.statNu2 + D;
        ret = ret + this.statNDistCalc + D + this.statNDistCalc1NN + D;
        ret = ret + this.statNDistCalcKNN + D;
        ret = ret + 0 + D;
        ret = ret + this.statGcDiffL / 1000000L + D + this.statGcTimeL + D;
        ret = ret + this.statGcDiffWq / 1000000L + D + this.statGcTimeWq + D;
        ret = ret + this.statGcDiffPq / 1000000L + D + this.statGcTimePq + D;
        ret = ret + this.statGcDiffUp / 1000000L + D + this.statGcTimeUp + D;
        ret = ret + this.statGcDiffK1 / 1000000L + D + this.statGcTimeK1 + D;
        ret = ret + this.statGcDiffK10 / 1000000L + D + this.statGcTimeK10 + D;
        ret = ret + this.statGcDiffUl / 1000000L + D + this.statGcTimeUl + D;
        ret = ret + this.cfgWindowQuerySize + D + this.cfgWindowQueryRepeat + D;
        ret = ret + this.assortedInfo;
        if (this.exception != null) {
            ret = ret + D + this.exception.getMessage();
        }
        return ret;
    }

    public void setN(int N) {
        this.cfgNEntries = N;
    }

    public int getN() {
        return this.cfgNEntries;
    }

    public static TestStats aggregate(List<TestStats> stats) {
        TestStats t1 = stats.get(0);
        TestStats avg = t1.cloneStats();
        int cnt = 1;
        for (int i = 1; i < stats.size(); ++i) {
            TestStats t = stats.get(i);
            if (t.exception != null) continue;
            avg.statTGen += t.statTGen;
            avg.statTLoad += t.statTLoad;
            avg.statTUnload += t.statTUnload;
            avg.statTq1 += t.statTq1;
            avg.statTq1E += t.statTq1E;
            avg.statTq2 += t.statTq2;
            avg.statTq2E += t.statTq2E;
            avg.statTqp1 += t.statTqp1;
            avg.statTqp1E += t.statTqp1E;
            avg.statTqp2 += t.statTqp2;
            avg.statTqp2E += t.statTqp2E;
            avg.statTqk1_1 += t.statTqk1_1;
            avg.statTqk1_1E += t.statTqk1_1E;
            avg.statTqk1_2 += t.statTqk1_2;
            avg.statTqk1_2E += t.statTqk1_2E;
            avg.statTqk10_1 += t.statTqk10_1;
            avg.statTqk10_1E += t.statTqk10_1E;
            avg.statTqk10_2 += t.statTqk10_2;
            avg.statTqk10_2E += t.statTqk10_2E;
            avg.statTu1 += t.statTu1;
            avg.statTu1E += t.statTu1E;
            avg.statTu2 += t.statTu2;
            avg.statTu2E += t.statTu2E;
            avg.statPSLoad += t.statPSLoad;
            avg.statPSUnload += t.statPSUnload;
            avg.statPSq1 += t.statPSq1;
            avg.statPSq1E += t.statPSq1E;
            avg.statPSq2 += t.statPSq2;
            avg.statPSq2E += t.statPSq2E;
            avg.statPSqp1 += t.statPSqp1;
            avg.statPSqp1E += t.statPSqp1E;
            avg.statPSqp2 += t.statPSqp2;
            avg.statPSqp2E += t.statPSqp2E;
            avg.statPSqk1_1 += t.statPSqk1_1;
            avg.statPSqk1_1E += t.statPSqk1_1E;
            avg.statPSqk1_2 += t.statPSqk1_2;
            avg.statPSqk1_2E += t.statPSqk1_2E;
            avg.statPSqk10_1 += t.statPSqk10_1;
            avg.statPSqk10_1E += t.statPSqk10_1E;
            avg.statPSqk10_2 += t.statPSqk10_2;
            avg.statPSqk10_2E += t.statPSqk10_2E;
            avg.statPSu1 += t.statPSu1;
            avg.statPSu1E += t.statPSu1E;
            avg.statPSu2 += t.statPSu2;
            avg.statPSu2E += t.statPSu2E;
            avg.statNnodes += t.statNnodes;
            avg.statNpostlen += t.statNpostlen;
            avg.statNNodeAHC += t.statNNodeAHC;
            avg.statNNodeNT += t.statNNodeNT;
            avg.statNNodeInternalNT += t.statNNodeInternalNT;
            avg.statNDistCalc += t.statNDistCalc;
            avg.statNDistCalc1NN += t.statNDistCalc1NN;
            avg.statNDistCalcKNN += t.statNDistCalcKNN;
            avg.statNq1 += t.statNq1;
            avg.statNq2 += t.statNq2;
            avg.statNqp1 += t.statNqp1;
            avg.statNqp2 += t.statNqp2;
            avg.statDqk1_1 += t.statDqk1_1;
            avg.statDqk1_2 += t.statDqk1_2;
            avg.statDqk10_1 += t.statDqk10_1;
            avg.statDqk10_2 += t.statDqk10_2;
            avg.statNu1 += t.statNu1;
            avg.statNu2 += t.statNu2;
            avg.statSCalc += t.statSCalc;
            avg.statSjvmF += t.statSjvmF;
            avg.statSjvmE += t.statSjvmE;
            avg.statGcDiffL += t.statGcDiffL;
            avg.statGcTimeL += t.statGcTimeL;
            avg.statGcDiffWq += t.statGcDiffWq;
            avg.statGcTimeWq += t.statGcTimeWq;
            avg.statGcDiffPq += t.statGcDiffPq;
            avg.statGcTimePq += t.statGcTimePq;
            avg.statGcDiffUp += t.statGcDiffUp;
            avg.statGcTimeUp += t.statGcTimeUp;
            avg.statGcDiffUl += t.statGcDiffUl;
            avg.statGcTimeUl += t.statGcTimeUl;
            avg.assortedInfo = t.assortedInfo;
            ++cnt;
        }
        avg.statTGen = (long)((double)avg.statTGen / (double)cnt);
        avg.statTLoad = (long)((double)avg.statTLoad / (double)cnt);
        avg.statTUnload = (long)((double)avg.statTUnload / (double)cnt);
        avg.statTq1 = (long)((double)avg.statTq1 / (double)cnt);
        avg.statTq1E = (long)((double)avg.statTq1E / (double)cnt);
        avg.statTq2 = (long)((double)avg.statTq2 / (double)cnt);
        avg.statTq2E = (long)((double)avg.statTq2E / (double)cnt);
        avg.statTqp1 = (long)((double)avg.statTqp1 / (double)cnt);
        avg.statTqp1E = (long)((double)avg.statTqp1E / (double)cnt);
        avg.statTqp2 = (long)((double)avg.statTqp2 / (double)cnt);
        avg.statTqp2E = (long)((double)avg.statTqp2E / (double)cnt);
        avg.statTqk1_1 = (long)((double)avg.statTqk1_1 / (double)cnt);
        avg.statTqk1_1E = (long)((double)avg.statTqk1_1E / (double)cnt);
        avg.statTqk1_2 = (long)((double)avg.statTqk1_2 / (double)cnt);
        avg.statTqk1_2E = (long)((double)avg.statTqk1_2E / (double)cnt);
        avg.statTqk10_1 = (long)((double)avg.statTqk10_1 / (double)cnt);
        avg.statTqk10_1E = (long)((double)avg.statTqk10_1E / (double)cnt);
        avg.statTqk10_2 = (long)((double)avg.statTqk10_2 / (double)cnt);
        avg.statTqk10_2E = (long)((double)avg.statTqk10_2E / (double)cnt);
        avg.statTu1 = (long)((double)avg.statTu1 / (double)cnt);
        avg.statTu1E = (long)((double)avg.statTu1E / (double)cnt);
        avg.statTu2 = (long)((double)avg.statTu2 / (double)cnt);
        avg.statTu2E = (long)((double)avg.statTu2E / (double)cnt);
        avg.statPSLoad = (long)((double)avg.statPSLoad / (double)cnt);
        avg.statPSUnload = (long)((double)avg.statPSUnload / (double)cnt);
        avg.statPSq1 = (long)((double)avg.statPSq1 / (double)cnt);
        avg.statPSq1E = (long)((double)avg.statPSq1E / (double)cnt);
        avg.statPSq2 = (long)((double)avg.statPSq2 / (double)cnt);
        avg.statPSq2E = (long)((double)avg.statPSq2E / (double)cnt);
        avg.statPSqp1 = (long)((double)avg.statPSqp1 / (double)cnt);
        avg.statPSqp1E = (long)((double)avg.statPSqp1E / (double)cnt);
        avg.statPSqp2 = (long)((double)avg.statPSqp2 / (double)cnt);
        avg.statPSqp2E = (long)((double)avg.statPSqp2E / (double)cnt);
        avg.statPSqk1_1 = (long)((double)avg.statPSqk1_1 / (double)cnt);
        avg.statPSqk1_1E = (long)((double)avg.statPSqk1_1E / (double)cnt);
        avg.statPSqk1_2 = (long)((double)avg.statPSqk1_2 / (double)cnt);
        avg.statPSqk1_2E = (long)((double)avg.statPSqk1_2E / (double)cnt);
        avg.statPSqk10_1 = (long)((double)avg.statPSqk10_1 / (double)cnt);
        avg.statPSqk10_1E = (long)((double)avg.statPSqk10_1E / (double)cnt);
        avg.statPSqk10_2 = (long)((double)avg.statPSqk10_2 / (double)cnt);
        avg.statPSqk10_2E = (long)((double)avg.statPSqk10_2E / (double)cnt);
        avg.statPSu1 = (long)((double)avg.statPSu1 / (double)cnt);
        avg.statPSu1E = (long)((double)avg.statPSu1E / (double)cnt);
        avg.statPSu2 = (long)((double)avg.statPSu2 / (double)cnt);
        avg.statPSu2E = (long)((double)avg.statPSu2E / (double)cnt);
        avg.statNnodes = (int)((double)avg.statNnodes / (double)cnt);
        avg.statNpostlen = (long)((double)avg.statNpostlen / (double)cnt);
        avg.statNNodeAHC = (int)((double)avg.statNNodeAHC / (double)cnt);
        avg.statNNodeNT = (int)((double)avg.statNNodeNT / (double)cnt);
        avg.statNNodeInternalNT = (int)((double)avg.statNNodeInternalNT / (double)cnt);
        avg.statNDistCalc = (long)((double)avg.statNDistCalc / (double)cnt);
        avg.statNDistCalc1NN = (long)((double)avg.statNDistCalc1NN / (double)cnt);
        avg.statNDistCalcKNN = (long)((double)avg.statNDistCalcKNN / (double)cnt);
        avg.statNq1 = (int)((double)avg.statNq1 / (double)cnt);
        avg.statNq2 = (int)((double)avg.statNq2 / (double)cnt);
        avg.statNqp1 = (int)((double)avg.statNqp1 / (double)cnt);
        avg.statNqp2 = (int)((double)avg.statNqp2 / (double)cnt);
        avg.statDqk1_1 /= (double)cnt;
        avg.statDqk1_2 /= (double)cnt;
        avg.statDqk10_1 /= (double)cnt;
        avg.statDqk10_2 /= (double)cnt;
        avg.statNu1 = (int)((double)avg.statNu1 / (double)cnt);
        avg.statNu2 = (int)((double)avg.statNu2 / (double)cnt);
        avg.statSCalc = (long)((double)avg.statSCalc / (double)cnt);
        avg.statSjvmF = (long)((double)avg.statSjvmF / (double)cnt);
        avg.statSjvmE = (long)((double)avg.statSjvmE / (double)cnt);
        avg.statGcDiffL = (long)((double)avg.statGcDiffL / (double)cnt);
        avg.statGcTimeL = (long)((double)avg.statGcTimeL / (double)cnt);
        avg.statGcDiffWq = (long)((double)avg.statGcDiffWq / (double)cnt);
        avg.statGcTimeWq = (long)((double)avg.statGcTimeWq / (double)cnt);
        avg.statGcDiffPq = (long)((double)avg.statGcDiffPq / (double)cnt);
        avg.statGcTimePq = (long)((double)avg.statGcTimePq / (double)cnt);
        avg.statGcDiffUp = (long)((double)avg.statGcDiffUp / (double)cnt);
        avg.statGcTimeUp = (long)((double)avg.statGcTimeUp / (double)cnt);
        avg.statGcDiffUl = (long)((double)avg.statGcDiffUl / (double)cnt);
        avg.statGcTimeUl = (long)((double)avg.statGcTimeUl / (double)cnt);
        avg.SEEDmsg = "AVG-" + cnt + "/" + stats.size();
        return avg;
    }

    public Candidate createTree() {
        if (this.indexClass == null) {
            String className = this.isRangeData ? this.INDEX.getCandidateClassNameRectangle() : this.INDEX.getCandidateClassNamePoint();
            if (className == null || className.trim().equals("")) {
                throw new IllegalStateException("Please provide a class name for TestStats: " + (this.INDEX != null ? this.INDEX.name() : "no index"));
            }
            this.setCandidateClass(className);
        }
        try {
            Class<? extends Candidate> cls = this.indexClass;
            Constructor<? extends Candidate> c = cls.getConstructor(TestStats.class);
            return c.newInstance(this);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCandidateClass(String className) {
        if (className == null || className.trim().equals("")) {
            throw new IllegalStateException("Please provide a class name for TestStats: " + (this.INDEX != null ? this.INDEX.name() : "no index"));
        }
        try {
            this.indexClass = Class.forName(className);
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

