/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.tinspin.data;

import ch.ethz.globis.tinspin.TestHandle;
import ch.ethz.globis.tinspin.TestStats;
import java.util.Arrays;
import java.util.Random;

public abstract class AbstractTest {
    protected final Random R;
    protected int DIM;
    protected final double param1;
    protected final double param2;
    protected String paramStr;
    protected String paramStr2;
    protected final TestStats S;
    protected double[] globalMin;
    protected double[] globalMax;

    protected AbstractTest(Random R, TestStats S) {
        this.R = R;
        this.S = S;
        this.DIM = S.cfgNDims;
        this.param1 = S.param1;
        this.param2 = S.param2;
        this.paramStr = S.paramStr;
        this.paramStr2 = S.paramStr2;
        this.globalMin = new double[this.DIM];
        this.globalMax = new double[this.DIM];
        Arrays.fill(this.globalMin, 0.0);
        Arrays.fill(this.globalMax, S.cfgDataLen);
    }

    public int getN() {
        return this.S.cfgNEntries;
    }

    public final TestHandle getTestType() {
        return this.S.TEST;
    }

    public double maxUpdateDistance() {
        double d = 0.0;
        for (int i = 0; i < this.globalMin.length; ++i) {
            if (!(d < this.globalMax[i] - this.globalMin[i])) continue;
            d = this.globalMax[i] - this.globalMin[i];
        }
        return d * 1.0E-4;
    }

    public abstract double[] generate();

    @Deprecated
    public abstract double[][] generateUpdates(int var1, double[] var2, double[][] var3);

    public double[][] generateUpdates(int n, double[] data, double[][] ups, int[] ids) {
        return this.generateUpdates(n, data, ups);
    }

    public void log(String str) {
        System.out.println(str);
    }

    public void logWarning(String str) {
        System.err.println(str);
    }

    public TestStats getTestStats() {
        return this.S;
    }

    public void generateWindowQueries(double[][] lower, double[][] upper) {
        int nEntries = this.S.cfgNEntries;
        if (nEntries < this.S.cfgWindowQuerySize * 10) {
            nEntries = this.S.cfgWindowQuerySize * 10;
        }
        double maxQueryLen = Double.MAX_VALUE;
        double[] maxLen = new double[this.DIM];
        double totalV = 1.0;
        for (int i = 0; i < this.DIM; ++i) {
            double len;
            maxLen[i] = len = this.globalMax[i] - this.globalMin[i];
            totalV *= len;
            maxQueryLen = len < maxQueryLen ? len : maxQueryLen;
        }
        int dims = this.DIM;
        double[] maxLenProduct = new double[dims];
        maxLenProduct[dims - 1] = maxLen[dims - 1];
        for (int i = dims - 2; i >= 0; --i) {
            maxLenProduct[i] = maxLenProduct[i + 1] * maxLen[i];
        }
        while (this.S.cfgWindowQuerySize * 100 > nEntries) {
            this.S.cfgWindowQuerySize /= 10;
        }
        double avgQueryVolume = (double)this.S.cfgWindowQuerySize / (double)nEntries * totalV;
        boolean ignoreChecks = avgQueryVolume * 1000.0 > totalV;
        for (int i = 0; i < lower.length; ++i) {
            this.generateQuery3(lower[i], upper[i], maxLen, maxLenProduct, avgQueryVolume, ignoreChecks);
        }
    }

    public void generateQuery(double[] min, double[] max, double maxLen, double avgQVol) {
        if (this.DIM > 40) {
            this.generateQuery2(min, max, maxLen, avgQVol);
            return;
        }
        int dims = this.DIM;
        double[] len = new double[min.length];
        int nTries = 0;
        do {
            double vol = 1.0;
            for (int d = 0; d < dims - 1; ++d) {
                double avgLen = Math.pow(avgQVol / vol, 1.0 / (double)dims);
                len[d] = 0.5 * avgLen + this.R.nextDouble() * avgLen;
                len[d] = len[d] > maxLen * 0.99 ? maxLen * 0.99 : len[d];
                vol *= len[d];
            }
            len[dims - 1] = avgQVol / vol;
            if (nTries++ <= 100) continue;
            System.out.println(Arrays.toString(len) + " vol=" + vol * len[dims - 1] + " aVol=" + avgQVol);
            throw new IllegalStateException("dims=" + dims + "  N=" + this.S.cfgNEntries);
        } while (len[dims - 1] >= maxLen);
        this.shuffle(len);
        for (int d = 0; d < dims; ++d) {
            min[d] = this.globalMin[d] + this.R.nextDouble() * (maxLen - len[d]);
            max[d] = min[d] + len[d];
            if (!(min[d] + len[d] >= this.globalMax[d])) continue;
            throw new RuntimeException();
        }
    }

    public void generateQuery2(double[] min, double[] max, double maxLen, double avgQVol) {
        int d;
        int dims = min.length;
        double[] len = new double[min.length];
        int nTries = 0;
        double vol = 1.0;
        do {
            for (d = 0; d < dims - 1; ++d) {
                double avgLen = Math.pow(avgQVol / vol, 1.0 / (double)(dims - d));
                double minLen = avgQVol / (vol * Math.pow(maxLen, dims - 1 - d));
                double variationUp = maxLen - avgLen;
                double variationDown = avgLen - minLen;
                double variation = Math.min(variationUp, variationDown) * 0.999;
                len[d] = avgLen + (this.R.nextDouble() * 2.0 - 1.0) * variation;
                if (len[d] > 1000.0 || Double.isNaN(len[d]) || len[d] <= 0.0) {
                    System.out.println(Arrays.toString(len) + " vol=" + vol * len[dims - 1] + " aVol=" + avgQVol);
                }
                vol *= len[d];
            }
            len[dims - 1] = avgQVol / vol;
            if (nTries++ <= 3) continue;
            System.out.println(Arrays.toString(len) + " vol=" + vol * len[dims - 1] + " aVol=" + avgQVol);
            throw new IllegalStateException("dims=" + dims + "  N=" + this.S.cfgNEntries);
        } while (len[dims - 1] >= maxLen);
        this.shuffle(len);
        for (d = 0; d < dims; ++d) {
            min[d] = this.globalMin[d] + this.R.nextDouble() * (maxLen - len[d]);
            max[d] = min[d] + len[d];
            if (!(min[d] + len[d] >= this.globalMax[d])) continue;
            throw new RuntimeException("m/l/m=" + min[d] + "/" + len[d] + "/" + max[d] + "; gm/gm=" + this.globalMin[d] + "/" + this.globalMax[d]);
        }
    }

    public void generateQuery3(double[] min, double[] max, double[] maxLen, double[] maxLenProduct, double avgQVol, boolean ignoreChecks) {
        int d;
        int dims = min.length;
        double[] len = new double[min.length];
        int nTries = 0;
        double vol = 1.0;
        do {
            for (d = 0; d < dims - 1; ++d) {
                double avgLen = Math.pow(avgQVol / vol, 1.0 / (double)(dims - d));
                double minLen = avgQVol / (vol * maxLenProduct[d + 1]);
                double variationUp = maxLen[d] - avgLen;
                double variationDown = avgLen - minLen;
                double variation = Math.min(variationUp, variationDown) * 0.999 * 0.5;
                len[d] = avgLen + (this.R.nextDouble() * 2.0 - 1.0) * variation;
                if (len[d] > 1000.0 || Double.isNaN(len[d]) || len[d] <= 0.0) {
                    System.out.println(Arrays.toString(len) + " vol=" + vol * len[dims - 1] + " aVol=" + avgQVol);
                }
                vol *= len[d];
                min[d] = this.globalMin[d] + this.R.nextDouble() * (maxLen[d] - len[d]);
                max[d] = min[d] + len[d];
                if (ignoreChecks || !(min[d] + len[d] * 0.9 >= this.globalMax[d])) continue;
                throw new RuntimeException("m/l/m=" + min[d] + "/" + len[d] + "/" + max[d] + "; gm/gm=" + this.globalMin[d] + "/" + this.globalMax[d]);
            }
            len[dims - 1] = avgQVol / vol;
            if (nTries++ <= 3) continue;
            System.out.println(Arrays.toString(len) + " vol=" + vol * len[dims - 1] + " aVol=" + avgQVol);
            throw new IllegalStateException("dims=" + dims + "  N=" + this.S.cfgNEntries);
        } while (len[dims - 1] >= maxLen[dims - 1]);
        for (d = 0; d < dims; ++d) {
            min[d] = this.globalMin[d] + this.R.nextDouble() * (maxLen[d] - len[d]);
            max[d] = min[d] + len[d];
            if (ignoreChecks || !(min[d] + len[d] * 0.9 >= this.globalMax[d])) continue;
            throw new RuntimeException("m/l/m=" + min[d] + "/" + len[d] + "/" + max[d] + "; gm/gm=" + this.globalMin[d] + "/" + this.globalMax[d]);
        }
    }

    private void shuffle(double[] da) {
        for (int i = da.length - 1; i > 0; --i) {
            int index = this.R.nextInt(i + 1);
            double a = da[index];
            da[index] = da[i];
            da[i] = a;
        }
    }

    public double min(int d) {
        return this.globalMin[d];
    }

    public double max(int d) {
        return this.globalMax[d];
    }

    public double len(int d) {
        return this.globalMax[d] - this.globalMin[d];
    }
}

