/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.phtree;

import ch.ethz.globis.phtree.PhTreeSolidF;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.RectangleEntry;
import org.tinspin.index.RectangleEntryDist;
import org.tinspin.index.RectangleIndex;
import org.tinspin.index.phtree.DistEntryR;
import org.tinspin.index.phtree.EntryR;

public class PHTreeR<T>
implements RectangleIndex<T> {
    private final PhTreeSolidF<T> tree;

    private PHTreeR(int dims) {
        this.tree = PhTreeSolidF.create((int)dims);
    }

    public static <T> PHTreeR<T> createPHTree(int dims) {
        return new PHTreeR<T>(dims);
    }

    @Override
    public int getDims() {
        return this.tree.getDims();
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public void clear() {
        this.tree.clear();
    }

    @Override
    public Object getStats() {
        return this.tree.getInternalTree().getStats();
    }

    @Override
    public int getNodeCount() {
        return this.tree.getInternalTree().getStats().getNodeCount();
    }

    @Override
    public int getDepth() {
        return this.tree.getInternalTree().getStats().getBitDepth();
    }

    @Override
    public String toStringTree() {
        return this.tree.getInternalTree().toStringTree();
    }

    @Override
    public void insert(double[] lower, double[] upper, T value) {
        this.tree.put(lower, upper, value);
    }

    @Override
    public T remove(double[] lower, double[] upper) {
        return (T)this.tree.remove(lower, upper);
    }

    @Override
    public T update(double[] lo1, double[] up1, double[] lo2, double[] up2) {
        return (T)this.tree.update(lo1, up1, lo2, up2);
    }

    @Override
    public T queryExact(double[] lower, double[] upper) {
        return (T)this.tree.get(lower, upper);
    }

    @Override
    public QueryIterator<RectangleEntry<T>> iterator() {
        return new IteratorPH(this.tree.iterator());
    }

    @Override
    public QueryIterator<RectangleEntry<T>> queryIntersect(double[] min, double[] max) {
        return new QueryIteratorPH(this.tree.queryIntersect(min, max));
    }

    @Override
    public QueryIteratorKNN<RectangleEntryDist<T>> queryKNN(double[] center, int k) {
        return new QueryIteratorKnnPH(this.tree.nearestNeighbour(k, null, center));
    }

    private static class QueryIteratorKnnPH<T>
    implements QueryIteratorKNN<RectangleEntryDist<T>> {
        private final PhTreeSolidF.PhKnnQuerySF<T> iter;

        private QueryIteratorKnnPH(PhTreeSolidF.PhKnnQuerySF<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public RectangleEntryDist<T> next() {
            PhTreeSolidF.PhEntryDistSF e = this.iter.nextEntryReuse();
            return new DistEntryR<Object>((double[])e.lower().clone(), (double[])e.upper().clone(), e.value(), e.dist());
        }

        @Override
        public void reset(double[] center, int k) {
            this.iter.reset(k, null, center);
        }
    }

    private static class QueryIteratorPH<T>
    implements QueryIterator<RectangleEntry<T>> {
        private final PhTreeSolidF.PhQuerySF<T> iter;

        private QueryIteratorPH(PhTreeSolidF.PhQuerySF<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public RectangleEntry<T> next() {
            PhTreeSolidF.PhEntrySF e = this.iter.nextEntryReuse();
            return new EntryR<Object>((double[])e.lower().clone(), (double[])e.upper().clone(), e.value());
        }

        @Override
        public void reset(double[] min, double[] max) {
            this.iter.reset(min, max);
        }
    }

    private static class IteratorPH<T>
    implements QueryIterator<RectangleEntry<T>> {
        private final PhTreeSolidF.PhIteratorSF<T> iter;

        private IteratorPH(PhTreeSolidF.PhIteratorSF<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public RectangleEntry<T> next() {
            PhTreeSolidF.PhEntrySF e = this.iter.nextEntryReuse();
            return new EntryR<Object>((double[])e.lower().clone(), (double[])e.upper().clone(), e.value());
        }

        @Override
        public void reset(double[] min, double[] max) {
            throw new UnsupportedOperationException();
        }
    }
}

