/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.quadtree;

import java.util.Arrays;
import org.tinspin.index.PointEntry;
import org.tinspin.index.quadtree.QUtil;

public class QEntry<T>
implements PointEntry<T> {
    private double[] point;
    private final T value;

    public QEntry(double[] key, T value) {
        this.point = key;
        this.value = value;
    }

    @Override
    public double[] point() {
        return this.point;
    }

    @Override
    public T value() {
        return this.value;
    }

    public boolean enclosedBy(double[] min, double[] max) {
        return QUtil.isPointEnclosed(this.point, min, max);
    }

    public boolean enclosedBy(double[] center, double radius) {
        return QUtil.isPointEnclosed(this.point, center, radius);
    }

    public boolean isExact(QEntry<T> e) {
        return QUtil.isPointEqual(this.point, e.point());
    }

    public String toString() {
        return "p=" + Arrays.toString(this.point) + "  v=" + this.value + " " + System.identityHashCode(this);
    }

    public void setKey(double[] newPoint) {
        this.point = newPoint;
    }
}

