/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.quadtree;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.tinspin.index.PointEntry;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.quadtree.QEntry;
import org.tinspin.index.quadtree.QNode;
import org.tinspin.index.quadtree.QuadTreeKD;

public class QIterator1<T>
implements QueryIterator<PointEntry<T>> {
    private final QuadTreeKD<T> tree;
    private IteratorStack stack = new IteratorStack();
    private QEntry<T> next = null;
    private double[] min;
    private double[] max;

    QIterator1(QuadTreeKD<T> tree, double[] min, double[] max) {
        this.tree = tree;
        this.reset(min, max);
    }

    private void findNext() {
        while (!this.stack.isEmpty()) {
            StackEntry se = this.stack.peek();
            while (se.pos < (long)se.len) {
                int pos = (int)se.pos++;
                if (se.isLeaf()) {
                    QEntry e = se.vals.get(pos);
                    if (!e.enclosedBy(this.min, this.max)) continue;
                    this.next = e;
                    return;
                }
                if (!se.checkHcPos(pos) || se.subs[pos] == null) continue;
                se = this.stack.prepareAndPush(se.subs[pos], this.min, this.max);
            }
            this.stack.pop();
        }
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public QEntry<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        QEntry<T> ret = this.next;
        this.findNext();
        return ret;
    }

    @Override
    public void reset(double[] min, double[] max) {
        this.stack.clear();
        this.min = min;
        this.max = max;
        this.next = null;
        if (this.tree.getRoot() != null) {
            this.stack.prepareAndPush(this.tree.getRoot(), min, max);
            this.findNext();
        }
    }

    private static class StackEntry<T> {
        long pos;
        long m0;
        long m1;
        QNode<T>[] subs;
        ArrayList<QEntry<T>> vals;
        public int len;

        private StackEntry() {
        }

        void set(QNode<T> node, double[] min, double[] max) {
            this.vals = node.getEntries();
            this.subs = node.getChildNodes();
            if (this.vals != null) {
                this.len = this.vals.size();
                this.pos = 0L;
            } else {
                this.len = this.subs.length;
                double[] center = node.getCenter();
                this.m0 = 0L;
                this.m1 = 0L;
                for (int d = 0; d < center.length; ++d) {
                    this.m0 <<= 1;
                    this.m1 <<= 1;
                    if (!(max[d] >= center[d])) continue;
                    this.m1 |= 1L;
                    if (!(min[d] >= center[d])) continue;
                    this.m0 |= 1L;
                }
                this.pos = this.m0;
            }
        }

        public boolean isLeaf() {
            return this.vals != null;
        }

        boolean checkHcPos(long pos) {
            return ((pos | this.m0) & this.m1) == pos;
        }
    }

    private class IteratorStack {
        private final ArrayList<StackEntry<T>> stack = new ArrayList();
        private int size = 0;

        IteratorStack() {
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        StackEntry<T> prepareAndPush(QNode<T> node, double[] min, double[] max) {
            if (this.size == this.stack.size()) {
                this.stack.add(new StackEntry());
            }
            StackEntry ni = this.stack.get(this.size++);
            ni.set(node, min, max);
            return ni;
        }

        StackEntry<T> peek() {
            return this.stack.get(this.size - 1);
        }

        StackEntry<T> pop() {
            return this.stack.get(--this.size);
        }

        public void clear() {
            this.size = 0;
        }
    }
}

