/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.quadtree;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.RectangleEntry;
import org.tinspin.index.quadtree.QREntry;
import org.tinspin.index.quadtree.QRNode;
import org.tinspin.index.quadtree.QUtil;
import org.tinspin.index.quadtree.QuadTreeRKD;

public class QRIterator<T>
implements QueryIterator<RectangleEntry<T>> {
    private final QuadTreeRKD<T> tree;
    private IteratorStack stack = new IteratorStack();
    private QREntry<T> next = null;
    private double[] min;
    private double[] max;

    QRIterator(QuadTreeRKD<T> tree, double[] min, double[] max) {
        this.tree = tree;
        this.reset(min, max);
    }

    private void findNext() {
        while (!this.stack.isEmpty()) {
            StackEntry se = this.stack.peek();
            while (se.posSub < (long)se.lenSub) {
                QRNode node;
                int pos = (int)se.posSub;
                se.inc();
                if (se.posSub <= (long)pos) {
                    se.posSub = Long.MAX_VALUE;
                }
                if ((node = se.subs[pos]) == null) continue;
                se = this.stack.prepareAndPush(node, this.min, this.max);
            }
            while (se.posE < se.lenE) {
                QREntry e;
                if (!QUtil.overlap(this.min, this.max, (e = se.vals.get(se.posE++)).lower(), e.upper())) continue;
                this.next = e;
                return;
            }
            this.stack.pop();
        }
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public QREntry<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        QREntry<T> ret = this.next;
        this.findNext();
        return ret;
    }

    @Override
    public void reset(double[] min, double[] max) {
        this.stack.clear();
        this.min = min;
        this.max = max;
        this.next = null;
        if (this.tree.getRoot() != null) {
            this.stack.prepareAndPush(this.tree.getRoot(), min, max);
            this.findNext();
        }
    }

    private static class StackEntry<T> {
        int posE;
        long posSub;
        long m0;
        long m1;
        QRNode<T>[] subs;
        ArrayList<QREntry<T>> vals;
        int lenE;
        int lenSub;

        private StackEntry() {
        }

        void set(QRNode<T> node, double[] min, double[] max) {
            this.vals = node.getEntries();
            this.subs = node.getChildNodes();
            this.lenE = this.vals != null ? this.vals.size() : 0;
            this.posE = 0;
            if (this.subs != null) {
                this.lenSub = this.subs.length;
                this.m0 = 0L;
                this.m1 = 0L;
                double[] center = node.getCenter();
                for (int d = 0; d < center.length; ++d) {
                    this.m0 <<= 1;
                    this.m1 <<= 1;
                    if (!(max[d] >= center[d])) continue;
                    this.m1 |= 1L;
                    if (!(min[d] >= center[d])) continue;
                    this.m0 |= 1L;
                }
                this.posSub = this.m0;
            } else {
                this.lenSub = 0;
                this.posSub = 0L;
            }
        }

        void inc() {
            long r = this.posSub | this.m1 ^ 0xFFFFFFFFFFFFFFFFL;
            this.posSub = ++r & this.m1 | this.m0;
        }
    }

    private class IteratorStack {
        private final ArrayList<StackEntry<T>> stack = new ArrayList();
        private int size = 0;

        IteratorStack() {
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        StackEntry<T> prepareAndPush(QRNode<T> node, double[] min, double[] max) {
            if (this.size == this.stack.size()) {
                this.stack.add(new StackEntry());
            }
            StackEntry ni = this.stack.get(this.size++);
            ni.set(node, min, max);
            return ni;
        }

        StackEntry<T> peek() {
            return this.stack.get(this.size - 1);
        }

        StackEntry<T> pop() {
            return this.stack.get(--this.size);
        }

        public void clear() {
            this.size = 0;
        }
    }
}

