/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.quadtree;

import java.util.ArrayList;
import java.util.Arrays;
import org.tinspin.index.quadtree.QREntry;
import org.tinspin.index.quadtree.QUtil;
import org.tinspin.index.quadtree.QuadTreeKD;

public class QRNode<T> {
    private static final int OVERLAP_WITH_CENTER = -1;
    private double[] center;
    private double radius;
    private ArrayList<QREntry<T>> values;
    private QRNode<T>[] subs;

    QRNode(double[] center, double radius) {
        this.center = center;
        this.radius = radius;
        this.values = new ArrayList();
    }

    QRNode(double[] center, double radius, QRNode<T> subNode, int subNodePos) {
        this.center = center;
        this.radius = radius;
        this.values = null;
        this.subs = new QRNode[1 << center.length];
        this.subs[subNodePos] = subNode;
    }

    QRNode<T> tryPut(QREntry<T> e, int maxNodeSize, boolean enforceLeaf) {
        int pos = this.calcSubPositionR(e.lower(), e.upper());
        if (this.subs != null && pos != -1) {
            return this.getOrCreateSubR(pos);
        }
        if (this.values == null) {
            this.values = new ArrayList();
        }
        if (this.values.size() < maxNodeSize || enforceLeaf || e.isExact(this.values.get(0)) || this.subs != null) {
            this.values.add(e);
            return null;
        }
        ArrayList<QREntry<T>> vals = this.values;
        vals.add(e);
        this.values = null;
        this.subs = new QRNode[1 << this.center.length];
        for (int i = 0; i < vals.size(); ++i) {
            QREntry<T> e2 = vals.get(i);
            int pos2 = this.calcSubPositionR(e2.lower(), e2.upper());
            if (pos2 == -1) {
                if (this.values == null) {
                    this.values = new ArrayList();
                }
                this.values.add(e2);
                continue;
            }
            for (QRNode<T> sub = this.getOrCreateSubR(pos2); sub != null; sub = sub.tryPut(e2, maxNodeSize, false)) {
            }
        }
        return null;
    }

    private QRNode<T> getOrCreateSubR(int pos) {
        QRNode<T> n = this.subs[pos];
        if (n == null) {
            this.subs[pos] = n = this.createSubForEntry(pos);
        }
        return n;
    }

    private QRNode<T> createSubForEntry(int subNodePos) {
        double[] centerSub = new double[this.center.length];
        int mask = 1 << this.center.length;
        double radiusSub = this.radius / 2.0;
        for (int d = 0; d < this.center.length; ++d) {
            centerSub[d] = (subNodePos & (mask >>= 1)) > 0 ? this.center[d] + radiusSub : this.center[d] - radiusSub;
        }
        return new QRNode<T>(centerSub, radiusSub);
    }

    private int calcSubPositionR(double[] pMin, double[] pMax) {
        int subNodePos = 0;
        for (int d = 0; d < this.center.length; ++d) {
            subNodePos <<= 1;
            if (pMin[d] >= this.center[d]) {
                subNodePos |= 1;
                continue;
            }
            if (!(pMax[d] >= this.center[d])) continue;
            return -1;
        }
        return subNodePos;
    }

    QREntry<T> remove(QRNode<T> parent, double[] keyL, double[] keyU, int maxNodeSize) {
        int pos;
        if (this.subs != null && (pos = this.calcSubPositionR(keyL, keyU)) != -1) {
            QRNode<T> sub = this.subs[pos];
            if (sub != null) {
                return sub.remove(this, keyL, keyU, maxNodeSize);
            }
            return null;
        }
        if (this.values == null) {
            return null;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            QREntry<T> e = this.values.get(i);
            if (!QUtil.isRectEqual(e, keyL, keyU)) continue;
            this.values.remove(i);
            if (parent != null) {
                super.checkAndMergeLeafNodes(maxNodeSize);
            }
            return e;
        }
        return null;
    }

    QREntry<T> update(QRNode<T> parent, double[] keyOldL, double[] keyOldU, double[] keyNewL, double[] keyNewU, int maxNodeSize, boolean[] requiresReinsert, int currentDepth, int maxDepth) {
        int pos;
        if (this.subs != null && (pos = this.calcSubPositionR(keyOldL, keyOldU)) != -1) {
            QRNode<T> sub = this.subs[pos];
            if (sub == null) {
                return null;
            }
            QREntry<T> ret = sub.update(this, keyOldL, keyOldU, keyNewL, keyNewU, maxNodeSize, requiresReinsert, currentDepth + 1, maxDepth);
            if (ret != null && requiresReinsert[0] && QUtil.isRectEnclosed(ret.lower(), ret.upper(), this.center, this.radius)) {
                requiresReinsert[0] = false;
                QRNode<T> r = this;
                while (r instanceof QRNode) {
                    r = r.tryPut(ret, maxNodeSize, currentDepth++ > maxDepth);
                }
            }
            return ret;
        }
        if (this.values == null) {
            return null;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            QREntry<T> e = this.values.get(i);
            if (!QUtil.isRectEqual(e, keyOldL, keyOldU)) continue;
            this.values.remove(i);
            e.setKey(keyNewL, keyNewU);
            if (QUtil.isRectEnclosed(keyNewL, keyNewU, this.center, this.radius)) {
                requiresReinsert[0] = false;
                int pos2 = this.calcSubPositionR(keyNewL, keyNewU);
                if (pos2 == -1) {
                    this.values.add(e);
                } else {
                    QRNode<T> r;
                    if (this.subs == null || this.subs[pos2] == null) {
                        r = this;
                    } else {
                        r = this.subs[pos2];
                        ++currentDepth;
                    }
                    while (r instanceof QRNode) {
                        r = r.tryPut(e, maxNodeSize, currentDepth++ > maxDepth);
                    }
                }
            } else {
                requiresReinsert[0] = true;
                if (parent != null) {
                    super.checkAndMergeLeafNodes(maxNodeSize);
                }
            }
            return e;
        }
        requiresReinsert[0] = false;
        return null;
    }

    private void checkAndMergeLeafNodes(int maxNodeSize) {
        int i;
        int nTotal = 0;
        if (this.values != null) {
            nTotal += this.values.size();
        }
        for (i = 0; i < this.subs.length; ++i) {
            if (this.subs[i] == null) continue;
            if (this.subs[i].subs != null) {
                return;
            }
            if (this.subs[i].values != null) {
                nTotal += this.subs[i].values.size();
            }
            if (nTotal <= maxNodeSize) continue;
            return;
        }
        if (this.values == null) {
            this.values = new ArrayList();
        }
        for (i = 0; i < this.subs.length; ++i) {
            if (this.subs[i] == null) continue;
            this.values.addAll(this.subs[i].values);
        }
        this.subs = null;
    }

    double[] getCenter() {
        return this.center;
    }

    double getRadius() {
        return this.radius;
    }

    QREntry<T> getExact(double[] keyL, double[] keyU) {
        int pos;
        if (this.subs != null && (pos = this.calcSubPositionR(keyL, keyU)) != -1) {
            QRNode<T> sub = this.subs[pos];
            if (sub != null) {
                return sub.getExact(keyL, keyU);
            }
            return null;
        }
        if (this.values == null) {
            return null;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            QREntry<T> e = this.values.get(i);
            if (!QUtil.isRectEqual(e, keyL, keyU)) continue;
            return e;
        }
        return null;
    }

    ArrayList<QREntry<T>> getEntries() {
        return this.values;
    }

    public String toString() {
        return "center/radius=" + Arrays.toString(this.center) + "/" + this.radius + " " + System.identityHashCode(this);
    }

    void checkNode(QuadTreeKD.QStats s, QRNode<T> parent, int depth) {
        int i;
        if (depth > s.maxDepth) {
            s.maxDepth = depth;
        }
        ++s.nNodes;
        if (parent == null || !QUtil.isRectEnclosed(this.center, this.radius, parent.center, parent.radius * 1.000000001)) {
            // empty if block
        }
        if (this.values != null) {
            for (i = 0; i < this.values.size(); ++i) {
                QREntry<T> e = this.values.get(i);
                if (QUtil.isRectEnclosed(e.lower(), e.upper(), this.center, this.radius * 1.000000001)) continue;
                throw new IllegalStateException();
            }
        }
        if (this.subs != null) {
            for (i = 0; i < this.subs.length; ++i) {
                QRNode<T> n = this.subs[i];
                if (n == null) continue;
                n.checkNode(s, this, depth + 1);
            }
        }
    }

    QRNode<T>[] getChildNodes() {
        return this.subs;
    }
}

