/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.ArrayList;
import java.util.Arrays;
import org.tinspin.index.rtree.Entry;
import org.tinspin.index.rtree.RTreeNodeDir;

abstract class RTreeNode<T>
extends Entry<T> {
    private RTreeNodeDir<T> parent;

    public RTreeNode(int dim) {
        super(new double[dim], new double[dim], null);
    }

    public abstract void addEntry(Entry<T> var1);

    public abstract ArrayList<Entry<T>> getEntries();

    public double calcOverlapEnlarged(Entry<T> enlargement, RTreeNode<T> otherNode) {
        double area = 1.0;
        for (int i = 0; i < this.min.length; ++i) {
            double d = RTreeNode.min(RTreeNode.max(this.max[i], enlargement.max[i]), otherNode.max[i]) - RTreeNode.max(RTreeNode.min(this.min[i], enlargement.min[i]), otherNode.min[i]);
            if (d <= 0.0) {
                return 0.0;
            }
            area *= d;
        }
        return area;
    }

    public double calcAreaEnlarged(Entry<T> e) {
        double area = 1.0;
        for (int i = 0; i < this.min.length; ++i) {
            double d = RTreeNode.max(this.max[i], e.max[i]) - RTreeNode.min(this.min[i], e.min[i]);
            area *= d;
        }
        return area;
    }

    protected void setMBB(Entry<T> e) {
        for (int i = 0; i < this.min.length; ++i) {
            this.min[i] = e.min[i];
            this.max[i] = e.max[i];
        }
    }

    protected void extendMBB(Entry<T> e) {
        for (int i = 0; i < this.min.length; ++i) {
            if (this.min[i] > e.min[i]) {
                this.min[i] = e.min[i];
            }
            if (!(this.max[i] < e.max[i])) continue;
            this.max[i] = e.max[i];
        }
    }

    public void recalcMBB() {
        this.resetMBB();
        ArrayList<Entry<T>> entries = this.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            Entry<T> e = entries.get(i);
            for (int d = 0; d < this.min.length; ++d) {
                if (this.min[d] > e.min[d]) {
                    this.min[d] = e.min[d];
                }
                if (!(this.max[d] < e.max[d])) continue;
                this.max[d] = e.max[d];
            }
        }
    }

    protected void resetMBB() {
        Arrays.fill(this.min, Double.POSITIVE_INFINITY);
        Arrays.fill(this.max, Double.NEGATIVE_INFINITY);
    }

    public abstract void clear();

    public void setParent(RTreeNodeDir<T> parent) {
        this.parent = parent;
    }

    public RTreeNodeDir<T> getParent() {
        return this.parent;
    }

    public void extendParentMBB() {
        for (RTreeNodeDir<T> parent = this.parent; parent != null; parent = parent.getParent()) {
            parent.extendMBB(this);
        }
    }

    public void recalcParentMBB() {
        for (RTreeNodeDir<T> parent = this.parent; parent != null; parent = parent.getParent()) {
            parent.recalcMBB();
        }
    }

    public abstract boolean hasSpace();

    public abstract boolean isUnderfull();

    public void removeEntry(int i) {
        this.getEntries().remove(i);
        this.recalcMBB();
        this.recalcParentMBB();
    }
}

