/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qthypercube;

import java.util.ArrayList;
import java.util.Arrays;
import org.tinspin.index.qthypercube.QEntry;
import org.tinspin.index.qthypercube.QUtil;
import org.tinspin.index.qthypercube.QuadTreeKD;

public class QNode<T> {
    private double[] center;
    private double radius;
    private ArrayList<QEntry<T>> values;
    private QNode<T>[] subs;

    QNode(double[] center, double radius) {
        this.center = center;
        this.radius = radius;
        this.values = new ArrayList(2);
    }

    QNode(double[] center, double radius, QNode<T> subNode, int subNodePos) {
        this.center = center;
        this.radius = radius;
        this.values = null;
        this.subs = new QNode[1 << center.length];
        this.subs[subNodePos] = subNode;
    }

    QNode<T> tryPut(QEntry<T> e, int maxNodeSize, boolean enforceLeaf) {
        if (this.values == null) {
            return this.getOrCreateSub(e);
        }
        if (this.values.size() < maxNodeSize || enforceLeaf || e.isExact(this.values.get(0))) {
            this.values.add(e);
            return null;
        }
        ArrayList<QEntry<T>> vals = this.values;
        this.values = null;
        this.subs = new QNode[1 << this.center.length];
        for (int i = 0; i < vals.size(); ++i) {
            QEntry<T> e2 = vals.get(i);
            for (QNode<T> sub = this.getOrCreateSub(e2); sub != null; sub = sub.tryPut(e2, maxNodeSize, false)) {
            }
        }
        return this.getOrCreateSub(e);
    }

    private QNode<T> getOrCreateSub(QEntry<T> e) {
        int pos = this.calcSubPosition(e.point());
        QNode<T> n = this.subs[pos];
        if (n == null) {
            this.subs[pos] = n = this.createSubForEntry(pos);
        }
        return n;
    }

    private QNode<T> createSubForEntry(int subNodePos) {
        double[] centerSub = new double[this.center.length];
        int mask = 1 << this.center.length;
        double radiusSub = this.radius / 2.0;
        for (int d = 0; d < this.center.length; ++d) {
            centerSub[d] = (subNodePos & (mask >>= 1)) > 0 ? this.center[d] + radiusSub : this.center[d] - radiusSub;
        }
        return new QNode<T>(centerSub, radiusSub);
    }

    private int calcSubPosition(double[] p) {
        int subNodePos = 0;
        for (int d = 0; d < this.center.length; ++d) {
            subNodePos <<= 1;
            if (!(p[d] >= this.center[d])) continue;
            subNodePos |= 1;
        }
        return subNodePos;
    }

    QEntry<T> remove(QNode<T> parent, double[] key, int maxNodeSize) {
        if (this.values == null) {
            int pos = this.calcSubPosition(key);
            QNode<T> sub = this.subs[pos];
            if (sub != null) {
                return sub.remove(this, key, maxNodeSize);
            }
            return null;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            QEntry<T> e = this.values.get(i);
            if (!QUtil.isPointEqual(e.point(), key)) continue;
            this.values.remove(i);
            if (parent != null) {
                super.checkAndMergeLeafNodes(maxNodeSize);
            }
            return e;
        }
        return null;
    }

    QEntry<T> update(QNode<T> parent, double[] keyOld, double[] keyNew, int maxNodeSize, boolean[] requiresReinsert, int currentDepth, int maxDepth) {
        if (this.values == null) {
            int pos = this.calcSubPosition(keyOld);
            QNode<T> sub = this.subs[pos];
            if (sub == null) {
                return null;
            }
            QEntry<T> ret = sub.update(this, keyOld, keyNew, maxNodeSize, requiresReinsert, currentDepth + 1, maxDepth);
            if (ret != null && requiresReinsert[0] && QUtil.isPointEnclosed(ret.point(), this.center, this.radius / 1.000000001)) {
                requiresReinsert[0] = false;
                QNode<T> r = this;
                while (r instanceof QNode) {
                    r = r.tryPut(ret, maxNodeSize, currentDepth++ > maxDepth);
                }
            }
            return ret;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            QEntry<T> e = this.values.get(i);
            if (!QUtil.isPointEqual(e.point(), keyOld)) continue;
            this.values.remove(i);
            e.setKey(keyNew);
            if (QUtil.isPointEnclosed(keyNew, this.center, this.radius / 1.000000001)) {
                this.values.add(e);
                requiresReinsert[0] = false;
            } else {
                requiresReinsert[0] = true;
                if (parent != null) {
                    super.checkAndMergeLeafNodes(maxNodeSize);
                }
            }
            return e;
        }
        requiresReinsert[0] = false;
        return null;
    }

    private void checkAndMergeLeafNodes(int maxNodeSize) {
        int i;
        int nTotal = 0;
        for (i = 0; i < this.subs.length; ++i) {
            if (this.subs[i] == null) continue;
            if (this.subs[i].values == null) {
                return;
            }
            if ((nTotal += this.subs[i].values.size()) <= maxNodeSize) continue;
            return;
        }
        this.values = new ArrayList(nTotal);
        for (i = 0; i < this.subs.length; ++i) {
            if (this.subs[i] == null) continue;
            this.values.addAll(this.subs[i].values);
        }
        this.subs = null;
    }

    double[] getCenter() {
        return this.center;
    }

    double getRadius() {
        return this.radius;
    }

    QEntry<T> getExact(double[] key) {
        if (this.values == null) {
            int pos = this.calcSubPosition(key);
            QNode<T> sub = this.subs[pos];
            if (sub != null) {
                return sub.getExact(key);
            }
            return null;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            QEntry<T> e = this.values.get(i);
            if (!QUtil.isPointEqual(e.point(), key)) continue;
            return e;
        }
        return null;
    }

    ArrayList<QEntry<T>> getEntries() {
        return this.values;
    }

    public String toString() {
        return "center/radius=" + Arrays.toString(this.center) + "/" + this.radius + " " + System.identityHashCode(this);
    }

    void checkNode(QuadTreeKD.QStats s, QNode<T> parent, int depth) {
        if (depth > s.maxDepth) {
            s.maxDepth = depth;
        }
        ++s.nNodes;
        if (parent != null && !QUtil.isRectEnclosed(this.center, this.radius, parent.center, parent.radius * 1.000000001)) {
            for (int d = 0; d < this.center.length; ++d) {
                System.out.println("Outer: " + parent.radius + " " + Arrays.toString(parent.center));
                System.out.println("Child: " + this.radius + " " + Arrays.toString(this.center));
                System.out.println(parent.center[d] + parent.radius + " vs " + (this.center[d] + this.radius));
                System.out.println("r=" + (parent.center[d] + parent.radius) / (this.center[d] + this.radius));
                System.out.println(parent.center[d] - parent.radius + " vs " + (this.center[d] - this.radius));
                System.out.println("r=" + (parent.center[d] - parent.radius) / (this.center[d] - this.radius));
            }
            throw new IllegalStateException();
        }
        if (this.values != null) {
            ++s.nNodesLeaf;
            s.nEntries += this.values.size();
            int n = this.values.size();
            s.histoValues[n] = s.histoValues[n] + 1;
            for (int i = 0; i < this.values.size(); ++i) {
                QEntry<T> e = this.values.get(i);
                if (QUtil.isPointEnclosed(e.point(), this.center, this.radius * 1.000000001)) continue;
                System.out.println("Node: " + this.radius + " " + Arrays.toString(this.center));
                System.out.println("Child: " + Arrays.toString(e.point()));
                for (int d = 0; d < this.center.length; ++d) {
                    System.out.println("min/max for " + d);
                    System.out.println("min: " + (this.center[d] - this.radius) + " vs " + e.point()[d]);
                    System.out.println("r=" + (this.center[d] - this.radius) / e.point()[d]);
                    System.out.println("max: " + (this.center[d] + this.radius) + " vs " + e.point()[d]);
                    System.out.println("r=" + (this.center[d] + this.radius) / e.point()[d]);
                }
                throw new IllegalStateException();
            }
            if (this.subs != null) {
                throw new IllegalStateException();
            }
        } else {
            ++s.nNodesInner;
            if ((long)this.subs.length != 1L << s.dims) {
                throw new IllegalStateException();
            }
            int nSubs = 0;
            for (int i = 0; i < this.subs.length; ++i) {
                QNode<T> n = this.subs[i];
                if (n == null) continue;
                ++nSubs;
                n.checkNode(s, this, depth + 1);
            }
            int n = nSubs;
            s.histoSubs[n] = s.histoSubs[n] + 1;
        }
    }

    boolean isLeaf() {
        return this.values != null;
    }

    QNode<T>[] getChildNodes() {
        return this.subs;
    }
}

