/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qtplain;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.tinspin.index.PointEntry;
import org.tinspin.index.PointEntryDist;
import org.tinspin.index.PointIndex;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.qtplain.QEntry;
import org.tinspin.index.qtplain.QEntryDist;
import org.tinspin.index.qtplain.QNode;
import org.tinspin.index.qtplain.QUtil;

public class QuadTreeKD0<T>
implements PointIndex<T> {
    private static final int MAX_DEPTH = 50;
    private static final String NL = System.lineSeparator();
    public static final boolean DEBUG = false;
    private static final int DEFAULT_MAX_NODE_SIZE = 10;
    private final int dims;
    private final int maxNodeSize;
    private QNode<T> root = null;
    private int size = 0;

    private QuadTreeKD0(int dims, int maxNodeSize) {
        this.dims = dims;
        this.maxNodeSize = maxNodeSize;
    }

    public static <T> QuadTreeKD0<T> create(int dims) {
        return new QuadTreeKD0<T>(dims, 10);
    }

    public static <T> QuadTreeKD0<T> create(int dims, int maxNodeSize) {
        return new QuadTreeKD0<T>(dims, maxNodeSize);
    }

    public static <T> QuadTreeKD0<T> create(int dims, int maxNodeSize, double[] center, double radius) {
        QuadTreeKD0<T> t = new QuadTreeKD0<T>(dims, maxNodeSize);
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius must be > 0 but was " + radius);
        }
        t.root = new QNode(Arrays.copyOf(center, center.length), radius);
        return t;
    }

    @Override
    public void insert(double[] key, T value) {
        ++this.size;
        QEntry<T> e = new QEntry<T>(key, value);
        if (this.root == null) {
            this.initializeRoot(key);
        }
        this.ensureCoverage(e);
        QNode<T> r = this.root;
        int depth = 0;
        while (r instanceof QNode) {
            r = r.tryPut(e, this.maxNodeSize, depth++ > 50);
        }
    }

    private void initializeRoot(double[] key) {
        double lo = Double.MAX_VALUE;
        double hi = -1.7976931348623157E308;
        for (int d = 0; d < this.dims; ++d) {
            lo = lo > key[d] ? key[d] : lo;
            hi = hi < key[d] ? key[d] : hi;
        }
        if (lo == 0.0 && hi == 0.0) {
            hi = 1.0;
        }
        double maxDistOrigin = Math.abs(hi) > Math.abs(lo) ? hi : lo;
        maxDistOrigin = Math.abs(maxDistOrigin);
        maxDistOrigin *= 1.0000000020000002;
        double[] center = new double[this.dims];
        for (int d = 0; d < this.dims; ++d) {
            center[d] = key[d] > 0.0 ? maxDistOrigin : -maxDistOrigin;
        }
        this.root = new QNode(center, maxDistOrigin);
    }

    public boolean containsExact(double[] key) {
        if (this.root == null) {
            return false;
        }
        return this.root.getExact(key) != null;
    }

    @Override
    public T queryExact(double[] key) {
        if (this.root == null) {
            return null;
        }
        QEntry<T> e = this.root.getExact(key);
        return e == null ? null : (T)e.value();
    }

    @Override
    public T remove(double[] key) {
        if (this.root == null) {
            return null;
        }
        QEntry<T> e = this.root.remove(null, key, this.maxNodeSize);
        if (e == null) {
            return null;
        }
        --this.size;
        return e.value();
    }

    @Override
    public T update(double[] oldKey, double[] newKey) {
        if (this.root == null) {
            return null;
        }
        boolean[] requiresReinsert = new boolean[]{false};
        QEntry<T> e = this.root.update(null, oldKey, newKey, this.maxNodeSize, requiresReinsert, 0, 50);
        if (e == null) {
            return null;
        }
        if (requiresReinsert[0]) {
            this.ensureCoverage(e);
            QNode<T> r = this.root;
            int depth = 0;
            while (r instanceof QNode) {
                r = r.tryPut(e, this.maxNodeSize, depth++ > 50);
            }
        }
        return e.value();
    }

    private void ensureCoverage(QEntry<T> e) {
        double[] p = e.point();
        while (!e.enclosedBy(this.root.getCenter(), this.root.getRadius())) {
            double[] center = this.root.getCenter();
            double radius = this.root.getRadius();
            double[] center2 = new double[center.length];
            double radius2 = radius * 2.0;
            for (int d = 0; d < center.length; ++d) {
                center2[d] = p[d] < center[d] - radius ? center[d] - radius : center[d] + radius;
            }
            this.root = new QNode<T>(center2, radius2, this.root);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.root = null;
    }

    public QIterator<T> query(double[] min, double[] max) {
        return new QIterator(this, min, max);
    }

    public List<QEntryDist<T>> knnQuery(double[] center, int k) {
        if (this.root == null) {
            return Collections.emptyList();
        }
        Comparator comp = (point1, point2) -> {
            double deltaDist = QUtil.distance(center, point1.point()) - QUtil.distance(center, point2.point());
            return deltaDist < 0.0 ? -1 : (deltaDist > 0.0 ? 1 : 0);
        };
        double distEstimate = this.distanceEstimate(this.root, center, k, comp);
        ArrayList<QEntryDist<T>> candidates = new ArrayList<QEntryDist<T>>();
        while (candidates.size() < k) {
            candidates.clear();
            this.rangeSearchKNN(this.root, center, candidates, k, distEstimate);
            distEstimate *= 2.0;
        }
        return candidates;
    }

    private double distanceEstimate(QNode<T> node, double[] point, int k, Comparator<QEntry<T>> comp) {
        if (node.isLeaf()) {
            int n = node.getEntries().size();
            QEntry[] data = node.getEntries().toArray(new QEntry[n]);
            Arrays.sort(data, comp);
            int pos = n < k ? n : k;
            double dist = QUtil.distance(point, data[pos - 1].point());
            if (n < k) {
                dist *= Math.pow((double)k / (double)n, 1.0 / (double)this.dims);
            }
            if (dist <= 0.0) {
                return node.getRadius();
            }
            return dist;
        }
        ArrayList<QNode<T>> nodes = node.getChildNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            QNode<T> sub = nodes.get(i);
            if (!QUtil.isPointEnclosed(point, sub.getCenter(), sub.getRadius())) continue;
            return this.distanceEstimate(sub, point, k, comp);
        }
        return node.getRadius() * Math.sqrt(point.length);
    }

    private double rangeSearchKNN(QNode<T> node, double[] center, ArrayList<QEntryDist<T>> candidates, int k, double maxRange) {
        if (node.isLeaf()) {
            ArrayList<QEntry<T>> points = node.getEntries();
            for (int i = 0; i < points.size(); ++i) {
                QEntry<T> p = points.get(i);
                double dist = QUtil.distance(center, p.point());
                if (!(dist < maxRange)) continue;
                candidates.add(new QEntryDist<T>(p, dist));
            }
            maxRange = this.adjustRegionKNN(candidates, k, maxRange);
        } else {
            ArrayList<QNode<T>> nodes = node.getChildNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                QNode<T> sub = nodes.get(i);
                if (sub == null || !(QUtil.distToRectNode(center, sub.getCenter(), sub.getRadius()) < maxRange)) continue;
                maxRange = this.rangeSearchKNN(sub, center, candidates, k, maxRange);
            }
        }
        return maxRange;
    }

    private double adjustRegionKNN(ArrayList<QEntryDist<T>> candidates, int k, double maxRange) {
        if (candidates.size() < k) {
            return maxRange;
        }
        candidates.sort(QEntryDist.COMP);
        while (candidates.size() > k) {
            candidates.remove(candidates.size() - 1);
        }
        double range = candidates.get(candidates.size() - 1).dist();
        return range;
    }

    @Override
    public String toStringTree() {
        StringBuilder sb = new StringBuilder();
        if (this.root == null) {
            sb.append("empty tree");
        } else {
            this.toStringTree(sb, this.root, 0, 0);
        }
        return sb.toString();
    }

    private void toStringTree(StringBuilder sb, QNode<T> node, int depth, int posInParent) {
        Iterator<?> it = node.getChildIterator();
        String prefix = "";
        for (int i = 0; i < depth; ++i) {
            prefix = prefix + ".";
        }
        sb.append(prefix + posInParent + " d=" + depth);
        sb.append(" " + Arrays.toString(node.getCenter()));
        sb.append("/" + node.getRadius() + NL);
        prefix = prefix + " ";
        int pos = 0;
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof QNode) {
                QNode sub = (QNode)o;
                this.toStringTree(sb, sub, depth + 1, pos);
            } else if (o instanceof QEntry) {
                QEntry e = (QEntry)o;
                sb.append(prefix + Arrays.toString(e.point()));
                sb.append(" v=" + e.value() + NL);
            }
            ++pos;
        }
    }

    public String toString() {
        return "KDTree;maxNodeSize=" + this.maxNodeSize + ";maxDepth=" + 50 + ";DEBUG=" + false + ";center/radius=" + (this.root == null ? "null" : Arrays.toString(this.root.getCenter()) + "/" + this.root.getRadius());
    }

    @Override
    public QStats getStats() {
        QStats s = new QStats();
        if (this.root != null) {
            this.root.checkNode(s, null, 0);
        }
        return s;
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public QueryIterator<PointEntry<T>> iterator() {
        if (this.root == null) {
            return this.query(new double[this.dims], new double[this.dims]);
        }
        throw new UnsupportedOperationException();
    }

    public QQueryIteratorKNN queryKNN(double[] center, int k) {
        return new QQueryIteratorKNN(center, k);
    }

    @Override
    public int getNodeCount() {
        return this.getStats().getNodeCount();
    }

    @Override
    public int getDepth() {
        return this.getStats().getMaxDepth();
    }

    public static class QStats {
        int nNodes;
        int maxDepth;

        public int getNodeCount() {
            return this.nNodes;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }
    }

    private class QQueryIteratorKNN
    implements QueryIteratorKNN<PointEntryDist<T>> {
        private Iterator<PointEntryDist<T>> it;

        public QQueryIteratorKNN(double[] center, int k) {
            this.reset(center, k);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public PointEntryDist<T> next() {
            return this.it.next();
        }

        @Override
        public void reset(double[] center, int k) {
            this.it = QuadTreeKD0.this.knnQuery(center, k).iterator();
        }
    }

    public static class QIterator<T>
    implements QueryIterator<PointEntry<T>> {
        private final QuadTreeKD0<T> tree;
        private ArrayDeque<Iterator<?>> stack = new ArrayDeque();
        private QEntry<T> next = null;
        private double[] min;
        private double[] max;

        QIterator(QuadTreeKD0<T> tree, double[] min, double[] max) {
            this.tree = tree;
            this.reset(min, max);
        }

        private void findNext() {
            while (!this.stack.isEmpty()) {
                Iterator<?> it = this.stack.peek();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (o instanceof QNode) {
                        QNode node = (QNode)o;
                        if (!QUtil.overlap(this.min, this.max, node.getCenter(), node.getRadius())) continue;
                        it = node.getChildIterator();
                        this.stack.push(it);
                        continue;
                    }
                    QEntry e = (QEntry)o;
                    if (!e.enclosedBy(this.min, this.max)) continue;
                    this.next = e;
                    return;
                }
                this.stack.pop();
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public QEntry<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            QEntry<T> ret = this.next;
            this.findNext();
            return ret;
        }

        @Override
        public void reset(double[] min, double[] max) {
            this.stack.clear();
            this.min = min;
            this.max = max;
            this.next = null;
            if (((QuadTreeKD0)this.tree).root != null) {
                this.stack.push(((QuadTreeKD0)this.tree).root.getChildIterator());
                this.findNext();
            }
        }
    }
}

