/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index;

import org.tinspin.index.PointEntry;
import org.tinspin.index.PointEntryDist;
import org.tinspin.index.PointIndex;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.RectangleEntry;
import org.tinspin.index.RectangleEntryDist;
import org.tinspin.index.RectangleIndex;
import org.tinspin.index.rtree.Entry;
import org.tinspin.index.rtree.RTree;

public class PointIndexWrapper<T>
implements PointIndex<T> {
    private final RectangleIndex<T> ind;

    private PointIndexWrapper(RectangleIndex<T> ind) {
        this.ind = ind;
    }

    public static <T> PointIndex<T> create(RectangleIndex<T> ind) {
        return new PointIndexWrapper<T>(ind);
    }

    @Override
    public QueryIterator<PointEntry<T>> iterator() {
        return new PointIter<T>(this.ind.iterator());
    }

    @Override
    public QueryIterator<PointEntry<T>> query(double[] min, double[] max) {
        return new PointIter<T>(this.ind.queryIntersect(min, max));
    }

    @Override
    public PointEntryDist<T> query1NN(double[] center) {
        RectangleEntryDist<T> r = this.ind.query1NN(center);
        return new PointDistW(r.lower(), r.value(), r.dist());
    }

    @Override
    public QueryIteratorKNN<PointEntryDist<T>> queryKNN(double[] center, int k) {
        return new PointDIter<T>(this.ind.queryKNN(center, k));
    }

    @Override
    public void insert(double[] key, T value) {
        this.ind.insert(key, key, value);
    }

    @Override
    public T remove(double[] point) {
        return this.ind.remove(point, point);
    }

    @Override
    public T update(double[] oldPoint, double[] newPoint) {
        return this.ind.update(oldPoint, oldPoint, newPoint, newPoint);
    }

    @Override
    public T queryExact(double[] point) {
        return this.ind.queryExact(point, point);
    }

    @Override
    public int getDims() {
        return this.ind.getDims();
    }

    @Override
    public int size() {
        return this.ind.size();
    }

    @Override
    public void clear() {
        this.ind.clear();
    }

    @Override
    public Object getStats() {
        return this.ind.getStats();
    }

    @Override
    public int getNodeCount() {
        return this.ind.getNodeCount();
    }

    @Override
    public int getDepth() {
        return this.ind.getDepth();
    }

    public void load(Entry<T>[] entries) {
        if (!(this.ind instanceof RTree)) {
            throw new UnsupportedOperationException("Bulkloading is only supported for RTrees");
        }
        ((RTree)this.ind).load(entries);
    }

    @Override
    public String toStringTree() {
        return this.ind.toStringTree();
    }

    private static class PointDIter<T>
    implements QueryIteratorKNN<PointEntryDist<T>> {
        private final QueryIteratorKNN<RectangleEntryDist<T>> it;

        PointDIter(QueryIteratorKNN<RectangleEntryDist<T>> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public PointEntryDist<T> next() {
            RectangleEntryDist e = (RectangleEntryDist)this.it.next();
            return new PointDistW(e.lower(), e.value(), e.dist());
        }

        @Override
        public void reset(double[] center, int k) {
            this.it.reset(center, k);
        }
    }

    private static class PointDistW<T>
    extends PointW<T>
    implements PointEntryDist<T> {
        private double dist;

        PointDistW(double[] point, T value, double dist) {
            super(point, value);
            this.dist = dist;
        }

        @Override
        public double dist() {
            return this.dist;
        }
    }

    private static class PointIter<T>
    implements QueryIterator<PointEntry<T>> {
        private final QueryIterator<RectangleEntry<T>> it;

        PointIter(QueryIterator<RectangleEntry<T>> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public PointEntry<T> next() {
            RectangleEntry e = (RectangleEntry)this.it.next();
            return new PointW(e.lower(), e.value());
        }

        @Override
        public void reset(double[] min, double[] max) {
            this.it.reset(min, max);
        }
    }

    private static class PointW<T>
    implements PointEntry<T> {
        private double[] point;
        private T value;

        PointW(double[] point, T value) {
            this.point = point;
            this.value = value;
        }

        @Override
        public double[] point() {
            return this.point;
        }

        @Override
        public T value() {
            return this.value;
        }
    }
}

