/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.kdtree;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.tinspin.index.PointEntry;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.kdtree.KDTree;
import org.tinspin.index.kdtree.Node;

public class KDIterator<T>
implements QueryIterator<PointEntry<T>> {
    private final KDTree<T> tree;
    private IteratorStack stack = new IteratorStack();
    private Node<T> next = null;
    private double[] min;
    private double[] max;

    KDIterator(KDTree<T> tree, double[] min, double[] max) {
        this.tree = tree;
        this.reset(min, max);
    }

    private void findNext() {
        while (!this.stack.isEmpty()) {
            IteratorPos itPos = this.stack.peek();
            Node node = itPos.node;
            if (itPos.doLeft && node.getLo() != null) {
                itPos.doLeft = false;
                this.stack.prepareAndPush(node.getLo(), this.min, this.max, itPos.depth + 1, this.tree.getDims());
                continue;
            }
            if (itPos.doKey) {
                itPos.doKey = false;
                if (KDTree.isEnclosed(node.getKey(), this.min, this.max)) {
                    this.next = node;
                    return;
                }
            }
            if (itPos.doRight && node.getHi() != null) {
                itPos.doRight = false;
                this.stack.prepareAndPush(node.getHi(), this.min, this.max, itPos.depth + 1, this.tree.getDims());
                continue;
            }
            this.stack.pop();
        }
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Node<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Node<T> ret = this.next;
        this.findNext();
        return ret;
    }

    @Override
    public void reset(double[] min, double[] max) {
        this.stack.clear();
        this.min = min;
        this.max = max;
        this.next = null;
        if (this.tree.getRoot() != null) {
            this.stack.prepareAndPush(this.tree.getRoot(), min, max, 0, this.tree.getDims());
            this.findNext();
        }
    }

    private class IteratorStack {
        private final ArrayList<IteratorPos<T>> stack = new ArrayList();
        private int size = 0;

        IteratorStack() {
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        IteratorPos<T> prepareAndPush(Node<T> node, double[] min, double[] max, int depth, int dims) {
            if (this.size == this.stack.size()) {
                this.stack.add(new IteratorPos());
            }
            IteratorPos ni = this.stack.get(this.size++);
            ni.set(node, min, max, depth, dims);
            return ni;
        }

        IteratorPos<T> peek() {
            return this.stack.get(this.size - 1);
        }

        IteratorPos<T> pop() {
            return this.stack.get(--this.size);
        }

        public void clear() {
            this.size = 0;
        }
    }

    private static class IteratorPos<T> {
        private Node<T> node;
        private int depth;
        private boolean doLeft;
        private boolean doKey;
        private boolean doRight;

        private IteratorPos() {
        }

        void set(Node<T> node, double[] min, double[] max, int depth, int dims) {
            this.node = node;
            this.depth = depth;
            int pos = depth % dims;
            double[] key = node.getKey();
            this.doLeft = min[pos] < key[pos];
            this.doRight = max[pos] > key[pos];
            this.doKey = this.doLeft || this.doRight || key[pos] == min[pos] || key[pos] == max[pos];
        }
    }
}

