/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.kdtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.tinspin.index.PointEntry;
import org.tinspin.index.PointEntryDist;
import org.tinspin.index.PointIndex;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.kdtree.KDEntryDist;
import org.tinspin.index.kdtree.KDIterator;
import org.tinspin.index.kdtree.Node;

public class KDTree<T>
implements PointIndex<T> {
    private static final String NL = System.lineSeparator();
    public static final boolean DEBUG = false;
    private final int dims;
    private int size = 0;
    private int modCount = 0;
    private boolean invariantBroken = false;
    private Node<T> root;
    private static final Comparator<KDEntryDist<?>> compKnn = (point1, point2) -> {
        double deltaDist = point1.dist() - point2.dist();
        return deltaDist < 0.0 ? -1 : (deltaDist > 0.0 ? 1 : 0);
    };

    public static void main(String ... args) {
        for (int i = 0; i < 10; ++i) {
            try {
                KDTree.test(i);
                continue;
            }
            catch (Exception e) {
                System.out.println("Failed with r=" + i);
                throw new RuntimeException(e);
            }
        }
    }

    private static void test(int r) {
        double[][] point_list = new double[500000][14];
        Random R = new Random(r);
        for (double[] p : point_list) {
            Arrays.setAll(p, i -> R.nextInt(100));
        }
        KDTree<double[]> tree = KDTree.create(point_list[0].length);
        for (double[] data : point_list) {
            tree.insert(data, data);
        }
        for (double[] key : point_list) {
            if (tree.containsExact(key)) continue;
            throw new IllegalStateException("" + Arrays.toString(key));
        }
        for (double[] key : point_list) {
            System.out.println(Arrays.toString((double[])tree.queryExact(key)));
        }
        for (double[] key : point_list) {
            System.out.println("kNN query: " + Arrays.toString(key));
            QueryIteratorKNN iter = tree.queryKNN(key, 1);
            if (!iter.hasNext()) {
                throw new IllegalStateException("kNN() failed: " + Arrays.toString(key));
            }
            double[] answer = ((PointEntryDist)iter.next()).point();
            if (answer == key || Arrays.equals(answer, key)) continue;
            throw new IllegalStateException("Expected " + Arrays.toString(key) + " but got " + Arrays.toString(answer));
        }
        for (double[] key : point_list) {
            System.out.println("Removing: " + Arrays.toString(key));
            if (!tree.containsExact(key)) {
                throw new IllegalStateException("containsExact() failed: " + Arrays.toString(key));
            }
            double[] answer = (double[])tree.remove(key);
            if (answer == key || Arrays.equals(answer, key)) continue;
            throw new IllegalStateException("Expected " + Arrays.toString(key) + " but got " + Arrays.toString(answer));
        }
    }

    private KDTree(int dims) {
        this.dims = dims;
    }

    public static <T> KDTree<T> create(int dims) {
        return new KDTree<T>(dims);
    }

    @Override
    public void insert(double[] key, T value) {
        ++this.size;
        ++this.modCount;
        if (this.root == null) {
            this.root = new Node<T>(key, value);
            return;
        }
        Node<T> n = this.root;
        int depth = 0;
        do {
            n = n.getClosestNodeOrAddPoint(key, value, depth, this.dims);
            ++depth;
        } while (n != null);
    }

    public boolean containsExact(double[] key) {
        return this.findNodeExcat(key, new RemoveResult()) != null;
    }

    @Override
    public T queryExact(double[] key) {
        Node e = this.findNodeExcat(key, new RemoveResult());
        return e == null ? null : (T)e.getValue();
    }

    private Node<T> findNodeExcat(double[] key, RemoveResult<T> resultDepth) {
        if (this.root == null) {
            return null;
        }
        return this.invariantBroken ? this.findNodeExactSlow(key, this.root, 0, null, resultDepth) : this.findNodeExcatFast(key, null, resultDepth);
    }

    private Node<T> findNodeExcatFast(double[] key, Node<T> parent, RemoveResult<T> resultDepth) {
        Node<T> n = this.root;
        int depth = 0;
        do {
            double[] nodeKey;
            double nodeX;
            int pos;
            double keyX;
            if ((keyX = key[pos = depth % this.dims]) == (nodeX = (nodeKey = n.getKey())[pos]) && Arrays.equals(key, nodeKey)) {
                resultDepth.depth = depth;
                resultDepth.nodeParent = parent;
                return n;
            }
            parent = n;
            n = keyX >= nodeX ? n.getHi() : n.getLo();
            ++depth;
        } while (n != null);
        return n;
    }

    private Node<T> findNodeExactSlow(double[] key, Node<T> n, int depth, Node<T> parent, RemoveResult<T> resultDepth) {
        do {
            double[] nodeKey;
            double nodeX;
            int pos;
            double keyX;
            if ((keyX = key[pos = depth % this.dims]) == (nodeX = (nodeKey = n.getKey())[pos])) {
                Node<T> n2;
                if (Arrays.equals(key, nodeKey)) {
                    resultDepth.depth = depth;
                    resultDepth.nodeParent = parent;
                    return n;
                }
                if (n.getLo() != null && (n2 = this.findNodeExactSlow(key, n.getLo(), depth + 1, parent, resultDepth)) != null) {
                    return n2;
                }
            }
            parent = n;
            n = keyX >= nodeX ? n.getHi() : n.getLo();
            ++depth;
        } while (n != null);
        return n;
    }

    @Override
    public T remove(double[] key) {
        if (this.root == null) {
            return null;
        }
        RemoveResult removeResult = new RemoveResult();
        Node eToRemove = this.findNodeExcat(key, removeResult);
        if (eToRemove == null) {
            return null;
        }
        ++this.modCount;
        Object value = eToRemove.getValue();
        if (eToRemove == this.root && this.size == 1) {
            this.root = null;
            this.size = 0;
            this.invariantBroken = false;
        }
        removeResult.nodeParent = null;
        while (eToRemove != null && !eToRemove.isLeaf()) {
            removeResult.node = null;
            int depth = removeResult.depth;
            int pos = depth % this.dims;
            if (((this.modCount & 1) == 0 || eToRemove.getHi() == null) && eToRemove.getLo() != null) {
                removeResult.best = Double.NEGATIVE_INFINITY;
                this.removeMaxLeaf(eToRemove.getLo(), eToRemove, pos, depth + 1, removeResult);
            } else if (eToRemove.getHi() != null) {
                removeResult.best = Double.POSITIVE_INFINITY;
                this.removeMinLeaf(eToRemove.getHi(), eToRemove, pos, depth + 1, removeResult);
            }
            eToRemove.setKeyValue(removeResult.node.getKey(), removeResult.node.getValue());
            eToRemove = removeResult.node;
        }
        Node parent = removeResult.nodeParent;
        if (parent != null) {
            if (parent.getLo() == eToRemove) {
                parent.setLeft(null);
            } else if (parent.getHi() == eToRemove) {
                parent.setRight(null);
            } else {
                throw new IllegalStateException();
            }
        }
        --this.size;
        return value;
    }

    private void removeMinLeaf(Node<T> node, Node<T> parent, int pos, int depth, RemoveResult<T> result) {
        double localX = node.getKey()[pos];
        if (pos == depth % this.dims) {
            if (node.getLo() != null) {
                this.removeMinLeaf(node.getLo(), node, pos, depth + 1, result);
            } else if (localX <= result.best) {
                result.node = node;
                result.nodeParent = parent;
                result.best = localX;
                result.depth = depth;
                this.invariantBroken |= result.best == localX;
            }
        } else {
            if (localX <= result.best) {
                result.node = node;
                result.nodeParent = parent;
                result.best = localX;
                result.depth = depth;
                this.invariantBroken |= result.best == localX;
            }
            if (node.getLo() != null) {
                this.removeMinLeaf(node.getLo(), node, pos, depth + 1, result);
            }
            if (node.getHi() != null) {
                this.removeMinLeaf(node.getHi(), node, pos, depth + 1, result);
            }
        }
    }

    private void removeMaxLeaf(Node<T> node, Node<T> parent, int pos, int depth, RemoveResult<T> result) {
        double localX = node.getKey()[pos];
        if (pos == depth % this.dims) {
            if (node.getHi() != null) {
                this.removeMaxLeaf(node.getHi(), node, pos, depth + 1, result);
            } else if (localX >= result.best) {
                result.node = node;
                result.nodeParent = parent;
                result.best = localX;
                result.depth = depth;
                this.invariantBroken |= result.best == localX;
            }
        } else {
            if (localX >= result.best) {
                result.node = node;
                result.nodeParent = parent;
                result.best = localX;
                result.depth = depth;
                this.invariantBroken |= result.best == localX;
            }
            if (node.getLo() != null) {
                this.removeMaxLeaf(node.getLo(), node, pos, depth + 1, result);
            }
            if (node.getHi() != null) {
                this.removeMaxLeaf(node.getHi(), node, pos, depth + 1, result);
            }
        }
    }

    @Override
    public T update(double[] oldKey, double[] newKey) {
        if (this.root == null) {
            return null;
        }
        T value = this.remove(oldKey);
        this.insert(newKey, value);
        return value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.root = null;
        this.invariantBroken = false;
        ++this.modCount;
    }

    public KDIterator<T> query(double[] min, double[] max) {
        return new KDIterator(this, min, max);
    }

    static boolean isEnclosed(double[] point, double[] min, double[] max) {
        for (int i = 0; i < point.length; ++i) {
            if (!(point[i] < min[i]) && !(point[i] > max[i])) continue;
            return false;
        }
        return true;
    }

    private static double distance(double[] p1, double[] p2) {
        double dist = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            double d = p1[i] - p2[i];
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    public KDEntryDist<T> nnQuery(double[] center) {
        if (this.root == null) {
            return null;
        }
        KDEntryDist candidate = new KDEntryDist(null, Double.POSITIVE_INFINITY);
        this.rangeSearch1NN(this.root, center, candidate, 0, Double.POSITIVE_INFINITY);
        return candidate;
    }

    private double rangeSearch1NN(Node<T> node, double[] center, KDEntryDist<T> candidate, int depth, double maxRange) {
        int pos = depth % this.dims;
        if (node.getLo() != null && (center[pos] < node.getKey()[pos] || node.getHi() == null)) {
            maxRange = this.rangeSearch1NN(node.getLo(), center, candidate, depth + 1, maxRange);
            if (center[pos] + maxRange >= node.getKey()[pos]) {
                maxRange = this.addCandidate(node, center, candidate, maxRange);
                if (node.getHi() != null) {
                    maxRange = this.rangeSearch1NN(node.getHi(), center, candidate, depth + 1, maxRange);
                }
            }
        } else if (node.getHi() != null) {
            maxRange = this.rangeSearch1NN(node.getHi(), center, candidate, depth + 1, maxRange);
            if (center[pos] <= node.getKey()[pos] + maxRange) {
                maxRange = this.addCandidate(node, center, candidate, maxRange);
                if (node.getLo() != null) {
                    maxRange = this.rangeSearch1NN(node.getLo(), center, candidate, depth + 1, maxRange);
                }
            }
        } else {
            maxRange = this.addCandidate(node, center, candidate, maxRange);
        }
        return maxRange;
    }

    private double addCandidate(Node<T> node, double[] center, KDEntryDist<T> candidate, double maxRange) {
        double dist = KDTree.distance(center, node.getKey());
        if (dist >= maxRange) {
            return maxRange;
        }
        candidate.set(node, dist);
        return dist;
    }

    public List<KDEntryDist<T>> knnQuery(double[] center, int k) {
        if (this.root == null) {
            return Collections.emptyList();
        }
        ArrayList<KDEntryDist<T>> candidates = new ArrayList<KDEntryDist<T>>(k);
        this.rangeSearchKNN(this.root, center, candidates, k, 0, Double.POSITIVE_INFINITY);
        return candidates;
    }

    private double rangeSearchKNN(Node<T> node, double[] center, ArrayList<KDEntryDist<T>> candidates, int k, int depth, double maxRange) {
        int pos = depth % this.dims;
        if (node.getLo() != null && (center[pos] < node.getKey()[pos] || node.getHi() == null)) {
            maxRange = this.rangeSearchKNN(node.getLo(), center, candidates, k, depth + 1, maxRange);
            if (center[pos] + maxRange >= node.getKey()[pos]) {
                maxRange = this.addCandidate(node, center, candidates, k, maxRange);
                if (node.getHi() != null) {
                    maxRange = this.rangeSearchKNN(node.getHi(), center, candidates, k, depth + 1, maxRange);
                }
            }
        } else if (node.getHi() != null) {
            maxRange = this.rangeSearchKNN(node.getHi(), center, candidates, k, depth + 1, maxRange);
            if (center[pos] <= node.getKey()[pos] + maxRange) {
                maxRange = this.addCandidate(node, center, candidates, k, maxRange);
                if (node.getLo() != null) {
                    maxRange = this.rangeSearchKNN(node.getLo(), center, candidates, k, depth + 1, maxRange);
                }
            }
        } else {
            maxRange = this.addCandidate(node, center, candidates, k, maxRange);
        }
        return maxRange;
    }

    private double addCandidate(Node<T> node, double[] center, ArrayList<KDEntryDist<T>> candidates, int k, double maxRange) {
        KDEntryDist<T> cand;
        double dist = KDTree.distance(center, node.getKey());
        if (dist > maxRange) {
            return maxRange;
        }
        if (dist == maxRange && candidates.size() >= k) {
            return maxRange;
        }
        if (candidates.size() >= k) {
            cand = candidates.remove(k - 1);
            cand.set(node, dist);
        } else {
            cand = new KDEntryDist<T>(node, dist);
        }
        int insertionPos = Collections.binarySearch(candidates, cand, compKnn);
        insertionPos = insertionPos >= 0 ? insertionPos : -(insertionPos + 1);
        candidates.add(insertionPos, cand);
        return candidates.size() < k ? maxRange : candidates.get(candidates.size() - 1).dist();
    }

    @Override
    public String toStringTree() {
        StringBuilder sb = new StringBuilder();
        if (this.root == null) {
            sb.append("empty tree");
        } else {
            this.toStringTree(sb, this.root, 0);
        }
        return sb.toString();
    }

    private void toStringTree(StringBuilder sb, Node<T> node, int depth) {
        String prefix = "";
        for (int i = 0; i < depth; ++i) {
            prefix = prefix + ".";
        }
        prefix = prefix + " ";
        if (node.getLo() != null) {
            this.toStringTree(sb, node.getLo(), depth + 1);
        }
        sb.append(prefix + Arrays.toString(node.point()));
        sb.append(" v=" + node.value());
        sb.append(" l/r=");
        sb.append(node.getLo() == null ? null : Arrays.toString(node.getLo().point()));
        sb.append("/");
        sb.append(node.getHi() == null ? null : Arrays.toString(node.getHi().point()));
        sb.append(NL);
        if (node.getHi() != null) {
            this.toStringTree(sb, node.getHi(), depth + 1);
        }
    }

    public String toString() {
        return "KDTree;size=" + this.size + ";DEBUG=" + false + ";center=" + (this.root == null ? "null" : Arrays.toString(this.root.getKey()));
    }

    @Override
    public KDStats getStats() {
        KDStats s = new KDStats();
        if (this.root != null) {
            this.root.checkNode(s, 0);
        }
        return s;
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public QueryIterator<PointEntry<T>> iterator() {
        if (this.root == null) {
            return this.query(new double[this.dims], new double[this.dims]);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public KDEntryDist<T> query1NN(double[] center) {
        return this.nnQuery(center);
    }

    public KDQueryIteratorKNN<T> queryKNN(double[] center, int k) {
        return new KDQueryIteratorKNN(this, center, k);
    }

    @Override
    public int getNodeCount() {
        return this.getStats().getNodeCount();
    }

    @Override
    public int getDepth() {
        return this.getStats().getMaxDepth();
    }

    Node<T> getRoot() {
        return this.root;
    }

    public static class KDStats {
        int nNodes;
        int maxDepth;

        public int getNodeCount() {
            return this.nNodes;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }
    }

    private static class KDQueryIteratorKNN<T>
    implements QueryIteratorKNN<PointEntryDist<T>> {
        private Iterator<? extends PointEntryDist<T>> it;
        private final KDTree<T> tree;

        public KDQueryIteratorKNN(KDTree<T> tree, double[] center, int k) {
            this.tree = tree;
            this.reset(center, k);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public PointEntryDist<T> next() {
            return this.it.next();
        }

        @Override
        public void reset(double[] center, int k) {
            this.it = this.tree.knnQuery(center, k).iterator();
        }
    }

    private static class RemoveResult<T> {
        Node<T> node = null;
        Node<T> nodeParent = null;
        double best;
        int depth;

        private RemoveResult() {
        }
    }
}

