/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qthypercube2;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.tinspin.index.PointEntry;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.qthypercube2.QEntry;
import org.tinspin.index.qthypercube2.QNode;
import org.tinspin.index.qthypercube2.QUtil;
import org.tinspin.index.qthypercube2.QuadTreeKD;

public class QIterator0<T>
implements QueryIterator<PointEntry<T>> {
    private final QuadTreeKD<T> tree;
    private IteratorStack stack = new IteratorStack();
    private QEntry<T> next = null;
    private double[] min;
    private double[] max;

    QIterator0(QuadTreeKD<T> tree, double[] min, double[] max) {
        this.tree = tree;
        this.reset(min, max);
    }

    private void findNext() {
        while (!this.stack.isEmpty()) {
            StackEntry se = this.stack.peek();
            while (se.pos < se.len) {
                QEntry qe;
                Object e;
                int pos;
                ++se.pos;
                if (se.isLeaf()) {
                    e = (QEntry)se.entries[pos];
                    if (!((QEntry)e).enclosedBy(this.min, this.max)) continue;
                    this.next = e;
                    return;
                }
                e = se.entries[pos];
                if (e instanceof QNode) {
                    QNode node = (QNode)e;
                    if (!QUtil.overlap(this.min, this.max, node.getCenter(), node.getRadius())) continue;
                    se = this.stack.prepareAndPush(node);
                    continue;
                }
                if (e == null || !(qe = (QEntry)e).enclosedBy(this.min, this.max)) continue;
                this.next = qe;
                return;
            }
            this.stack.pop();
        }
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public QEntry<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        QEntry<T> ret = this.next;
        this.findNext();
        return ret;
    }

    @Override
    public void reset(double[] min, double[] max) {
        this.stack.clear();
        this.min = min;
        this.max = max;
        this.next = null;
        if (this.tree.getRoot() != null) {
            this.stack.prepareAndPush(this.tree.getRoot());
            this.findNext();
        }
    }

    private static class StackEntry<T> {
        int pos;
        Object[] entries;
        boolean isLeaf;
        int len;

        private StackEntry() {
        }

        void set(QNode<T> node) {
            this.pos = 0;
            this.entries = node.getEntries();
            this.isLeaf = node.isLeaf();
            this.len = this.isLeaf ? node.getValueCount() : this.entries.length;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }
    }

    private class IteratorStack {
        private final ArrayList<StackEntry<T>> stack = new ArrayList();
        private int size = 0;

        IteratorStack() {
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        StackEntry<T> prepareAndPush(QNode<T> node) {
            if (this.size == this.stack.size()) {
                this.stack.add(new StackEntry());
            }
            StackEntry ni = this.stack.get(this.size++);
            ni.set(node);
            return ni;
        }

        StackEntry<T> peek() {
            return this.stack.get(this.size - 1);
        }

        StackEntry<T> pop() {
            return this.stack.get(--this.size);
        }

        public void clear() {
            this.size = 0;
        }
    }
}

