/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qthypercube2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.RectangleEntry;
import org.tinspin.index.RectangleEntryDist;
import org.tinspin.index.RectangleIndex;
import org.tinspin.index.qthypercube2.QNode;
import org.tinspin.index.qthypercube2.QREntry;
import org.tinspin.index.qthypercube2.QREntryDist;
import org.tinspin.index.qthypercube2.QRIterator;
import org.tinspin.index.qthypercube2.QRNode;
import org.tinspin.index.qthypercube2.QUtil;
import org.tinspin.index.qthypercube2.QuadTreeKD;

public class QuadTreeRKD<T>
implements RectangleIndex<T> {
    private static final int MAX_DEPTH = 50;
    private static final String NL = System.lineSeparator();
    public static final boolean DEBUG = false;
    private static final int DEFAULT_MAX_NODE_SIZE = 10;
    private final int dims;
    private final int maxNodeSize;
    private QRNode<T> root = null;
    private int size = 0;

    private QuadTreeRKD(int dims, int maxNodeSize) {
        this.dims = dims;
        this.maxNodeSize = maxNodeSize;
    }

    public static <T> QuadTreeRKD<T> create(int dims) {
        return new QuadTreeRKD<T>(dims, 10);
    }

    @Deprecated
    public static <T> QuadTreeRKD<T> create(int dims, int maxNodeSize) {
        return new QuadTreeRKD<T>(dims, maxNodeSize);
    }

    public static <T> QuadTreeRKD<T> create(int dims, int maxNodeSize, double[] min, double[] max) {
        double radius = 0.0;
        double[] center = new double[dims];
        for (int i = 0; i < dims; ++i) {
            center[i] = (max[i] + min[i]) / 2.0;
            if (!(max[i] - min[i] > radius)) continue;
            radius = max[i] - min[i];
        }
        return QuadTreeRKD.create(dims, maxNodeSize, center, radius);
    }

    public static <T> QuadTreeRKD<T> create(int dims, int maxNodeSize, double[] center, double radius) {
        QuadTreeRKD<T> t = new QuadTreeRKD<T>(dims, maxNodeSize);
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius must be > 0 but was " + radius);
        }
        t.root = new QRNode(Arrays.copyOf(center, center.length), radius);
        return t;
    }

    @Override
    public void insert(double[] keyL, double[] keyU, T value) {
        ++this.size;
        QREntry<T> e = new QREntry<T>(keyL, keyU, value);
        if (this.root == null) {
            this.initializeRoot(keyL, keyU);
        }
        this.ensureCoverage(e);
        QRNode<T> r = this.root;
        int depth = 0;
        while (r instanceof QRNode) {
            r = r.tryPut(e, this.maxNodeSize, depth++ > 50);
        }
    }

    private void initializeRoot(double[] keyL, double[] keyU) {
        double[] center = new double[this.dims];
        double radius = 0.0;
        for (int d = 0; d < this.dims; ++d) {
            center[d] = (keyU[d] + keyL[d]) / 2.0;
            if (!(keyU[d] - keyL[d] > radius)) continue;
            radius = keyU[d] - keyL[d];
        }
        this.root = new QRNode(center, radius *= 5.0);
    }

    public boolean containsExact(double[] keyL, double[] keyU) {
        if (this.root == null) {
            return false;
        }
        return this.root.getExact(keyL, keyU) != null;
    }

    @Override
    public T queryExact(double[] keyL, double[] keyU) {
        if (this.root == null) {
            return null;
        }
        QREntry<T> e = this.root.getExact(keyL, keyU);
        return e == null ? null : (T)e.value();
    }

    @Override
    public T remove(double[] keyL, double[] keyU) {
        if (this.root == null) {
            return null;
        }
        QREntry<T> e = this.root.remove(null, keyL, keyU, this.maxNodeSize);
        if (e == null) {
            return null;
        }
        --this.size;
        return e.value();
    }

    @Override
    public T update(double[] oldKeyL, double[] oldKeyU, double[] newKeyL, double[] newKeyU) {
        if (this.root == null) {
            return null;
        }
        boolean[] requiresReinsert = new boolean[]{false};
        QREntry<T> e = this.root.update(null, oldKeyL, oldKeyU, newKeyL, newKeyU, this.maxNodeSize, requiresReinsert, 0, 50);
        if (e == null) {
            return null;
        }
        if (requiresReinsert[0]) {
            this.ensureCoverage(e);
            QRNode<T> r = this.root;
            int depth = 0;
            while (r instanceof QNode) {
                r = r.tryPut(e, this.maxNodeSize, depth++ > 50);
            }
        }
        return e.value();
    }

    private void ensureCoverage(QREntry<T> e) {
        double[] pLow = e.lower();
        while (!e.enclosedBy(this.root.getCenter(), this.root.getRadius())) {
            double[] center = this.root.getCenter();
            double radius = this.root.getRadius();
            double[] center2 = new double[center.length];
            double radius2 = radius * 2.0;
            int subNodePos = 0;
            for (int d = 0; d < center.length; ++d) {
                subNodePos <<= 1;
                if (pLow[d] < center[d] - radius) {
                    center2[d] = center[d] - radius;
                    subNodePos |= 1;
                    continue;
                }
                center2[d] = center[d] + radius;
            }
            this.root = new QRNode<T>(center2, radius2, this.root, subNodePos);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.root = null;
    }

    public QRIterator<T> queryIntersect(double[] min, double[] max) {
        return new QRIterator(this, min, max);
    }

    public List<QREntryDist<T>> knnQuery(double[] center, int k) {
        if (this.root == null) {
            return Collections.emptyList();
        }
        Comparator comp = (e1, e2) -> {
            double deltaDist = QUtil.distToRectEdge(center, e1) - QUtil.distToRectEdge(center, e2);
            return deltaDist < 0.0 ? -1 : (deltaDist > 0.0 ? 1 : 0);
        };
        double distEstimate = this.distanceEstimate(this.root, center, k, comp);
        ArrayList<QREntryDist<T>> candidates = new ArrayList<QREntryDist<T>>();
        while (candidates.size() < k) {
            candidates.clear();
            this.rangeSearchKNN(this.root, center, candidates, k, distEstimate);
            distEstimate *= 2.0;
        }
        return candidates;
    }

    private double distanceEstimate(QRNode<T> node, double[] point, int k, Comparator<QREntry<T>> comp) {
        if (node.getChildNodes() != null) {
            QRNode<T>[] nodes = node.getChildNodes();
            for (int i = 0; i < nodes.length; ++i) {
                if (nodes[i] == null || !QUtil.isPointEnclosed(point, nodes[i].getCenter(), nodes[i].getRadius())) continue;
                return this.distanceEstimate(nodes[i], point, k, comp);
            }
            return node.getRadius() * Math.sqrt(point.length);
        }
        int n = node.getEntries().size();
        QREntry[] data = node.getEntries().toArray(new QREntry[n]);
        Arrays.sort(data, comp);
        int pos = n < k ? n : k;
        double dist = QUtil.distToRectEdge(point, data[pos - 1]);
        if (n < k) {
            dist *= Math.pow((double)k / (double)n, 1.0 / (double)this.dims);
        }
        if (dist <= 0.0) {
            return node.getRadius() * 2.0;
        }
        return dist;
    }

    private double rangeSearchKNN(QRNode<T> node, double[] center, ArrayList<QREntryDist<T>> candidates, int k, double maxRange) {
        QRNode<T>[] nodes;
        ArrayList<QREntry<T>> points = node.getEntries();
        if (points != null) {
            for (int i = 0; i < points.size(); ++i) {
                QREntry<T> p = points.get(i);
                double dist = QUtil.distToRectEdge(center, p);
                if (!(dist < maxRange)) continue;
                candidates.add(new QREntryDist<T>(p, dist));
            }
            maxRange = this.adjustRegionKNN(candidates, k, maxRange);
        }
        if ((nodes = node.getChildNodes()) != null) {
            for (int i = 0; i < nodes.length; ++i) {
                QRNode<T> sub = nodes[i];
                if (sub == null || !(QUtil.distToRectNode(center, sub.getCenter(), sub.getRadius()) < maxRange)) continue;
                maxRange = this.rangeSearchKNN(sub, center, candidates, k, maxRange);
            }
        }
        return maxRange;
    }

    private double adjustRegionKNN(ArrayList<QREntryDist<T>> candidates, int k, double maxRange) {
        if (candidates.size() < k) {
            return maxRange;
        }
        candidates.sort(QREntryDist.COMP);
        while (candidates.size() > k) {
            candidates.remove(candidates.size() - 1);
        }
        double range = candidates.get(candidates.size() - 1).dist();
        return range;
    }

    @Override
    public String toStringTree() {
        StringBuilder sb = new StringBuilder();
        if (this.root == null) {
            sb.append("empty tree");
        } else {
            this.toStringTree(sb, this.root, 0, 0);
        }
        return sb.toString();
    }

    private void toStringTree(StringBuilder sb, QRNode<T> node, int depth, int posInParent) {
        int i;
        String prefix = "";
        for (int i2 = 0; i2 < depth; ++i2) {
            prefix = prefix + ".";
        }
        sb.append(prefix + posInParent + " d=" + depth);
        sb.append(" " + Arrays.toString(node.getCenter()));
        sb.append("/" + node.getRadius() + NL);
        prefix = prefix + " ";
        int pos = 0;
        if (node.getChildNodes() != null) {
            for (i = 0; i < node.getChildNodes().length; ++i) {
                QRNode<T> sub = node.getChildNodes()[i];
                if (sub == null) continue;
                this.toStringTree(sb, sub, depth + 1, pos);
            }
        }
        if (node.getEntries() != null) {
            for (i = 0; i < node.getEntries().size(); ++i) {
                QREntry<T> e = node.getEntries().get(i);
                sb.append(prefix + Arrays.toString(e.lower()) + Arrays.toString(e.upper()));
                sb.append(" v=" + e.value() + NL);
            }
            ++pos;
        }
    }

    public String toString() {
        return "QuadTreeRKD;maxNodeSize=" + this.maxNodeSize + ";maxDepth=" + 50 + ";DEBUG=" + false + ";center/radius=" + (this.root == null ? "null" : Arrays.toString(this.root.getCenter()) + "/" + this.root.getRadius());
    }

    @Override
    public QuadTreeKD.QStats getStats() {
        QuadTreeKD.QStats s = new QuadTreeKD.QStats(this.dims);
        if (this.root != null) {
            this.root.checkNode(s, null, 0);
        }
        return s;
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public int getNodeCount() {
        return this.getStats().getNodeCount();
    }

    @Override
    public QueryIterator<RectangleEntry<T>> iterator() {
        throw new UnsupportedOperationException();
    }

    public QRQueryIteratorKNN queryKNN(double[] center, int k) {
        return new QRQueryIteratorKNN(center, k);
    }

    @Override
    public int getDepth() {
        return this.getStats().getMaxDepth();
    }

    protected QRNode<T> getRoot() {
        return this.root;
    }

    private class QRQueryIteratorKNN
    implements QueryIteratorKNN<RectangleEntryDist<T>> {
        private Iterator<RectangleEntryDist<T>> it;

        public QRQueryIteratorKNN(double[] center, int k) {
            this.reset(center, k);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public RectangleEntryDist<T> next() {
            return this.it.next();
        }

        @Override
        public void reset(double[] center, int k) {
            this.it = QuadTreeRKD.this.knnQuery(center, k).iterator();
        }
    }
}

