/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qtplain;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.RectangleEntry;
import org.tinspin.index.RectangleEntryDist;
import org.tinspin.index.RectangleIndex;
import org.tinspin.index.qtplain.QNode;
import org.tinspin.index.qtplain.QREntry;
import org.tinspin.index.qtplain.QREntryDist;
import org.tinspin.index.qtplain.QRNode;
import org.tinspin.index.qtplain.QUtil;
import org.tinspin.index.qtplain.QuadTreeKD0;

public class QuadTreeRKD0<T>
implements RectangleIndex<T> {
    private static final int MAX_DEPTH = 50;
    private static final String NL = System.lineSeparator();
    public static final boolean DEBUG = false;
    private static final int DEFAULT_MAX_NODE_SIZE = 10;
    private final int dims;
    private final int maxNodeSize;
    private QRNode<T> root = null;
    private int size = 0;

    private QuadTreeRKD0(int dims, int maxNodeSize) {
        this.dims = dims;
        this.maxNodeSize = maxNodeSize;
    }

    public static <T> QuadTreeRKD0<T> create(int dims) {
        return new QuadTreeRKD0<T>(dims, 10);
    }

    @Deprecated
    public static <T> QuadTreeRKD0<T> create(int dims, int maxNodeSize) {
        return new QuadTreeRKD0<T>(dims, maxNodeSize);
    }

    public static <T> QuadTreeRKD0<T> create(int dims, int maxNodeSize, double[] min, double[] max) {
        double radius = 0.0;
        double[] center = new double[dims];
        for (int i = 0; i < dims; ++i) {
            center[i] = (max[i] + min[i]) / 2.0;
            if (!(max[i] - min[i] > radius)) continue;
            radius = max[i] - min[i];
        }
        return QuadTreeRKD0.create(dims, maxNodeSize, center, radius);
    }

    public static <T> QuadTreeRKD0<T> create(int dims, int maxNodeSize, double[] center, double radius) {
        QuadTreeRKD0<T> t = new QuadTreeRKD0<T>(dims, maxNodeSize);
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius must be > 0 but was " + radius);
        }
        t.root = new QRNode(Arrays.copyOf(center, center.length), radius);
        return t;
    }

    @Override
    public void insert(double[] keyL, double[] keyU, T value) {
        ++this.size;
        QREntry<T> e = new QREntry<T>(keyL, keyU, value);
        if (this.root == null) {
            this.initializeRoot(keyL, keyU);
        }
        this.ensureCoverage(e);
        QRNode<T> r = this.root;
        int depth = 0;
        while (r instanceof QRNode) {
            r = r.tryPut(e, this.maxNodeSize, depth++ > 50);
        }
    }

    private void initializeRoot(double[] keyL, double[] keyU) {
        double[] center = new double[this.dims];
        double radius = 0.0;
        for (int d = 0; d < this.dims; ++d) {
            center[d] = (keyU[d] + keyL[d]) / 2.0;
            if (!(keyU[d] - keyL[d] > radius)) continue;
            radius = keyU[d] - keyL[d];
        }
        this.root = new QRNode(center, radius *= 5.0);
    }

    public boolean containsExact(double[] keyL, double[] keyU) {
        if (this.root == null) {
            return false;
        }
        return this.root.getExact(keyL, keyU) != null;
    }

    @Override
    public T queryExact(double[] keyL, double[] keyU) {
        if (this.root == null) {
            return null;
        }
        QREntry<T> e = this.root.getExact(keyL, keyU);
        return e == null ? null : (T)e.value();
    }

    @Override
    public T remove(double[] keyL, double[] keyU) {
        if (this.root == null) {
            System.err.println("Failed remove 1: " + Arrays.toString(keyL) + Arrays.toString(keyU));
            return null;
        }
        QREntry<T> e = this.root.remove(null, keyL, keyU, this.maxNodeSize);
        if (e == null) {
            System.err.println("Failed remove 2: " + Arrays.toString(keyL) + Arrays.toString(keyU));
            return null;
        }
        --this.size;
        return e.value();
    }

    @Override
    public T update(double[] oldKeyL, double[] oldKeyU, double[] newKeyL, double[] newKeyU) {
        if (this.root == null) {
            return null;
        }
        boolean[] requiresReinsert = new boolean[]{false};
        QREntry<T> e = this.root.update(null, oldKeyL, oldKeyU, newKeyL, newKeyU, this.maxNodeSize, requiresReinsert, 0, 50);
        if (e == null) {
            System.err.println("Failed reinsert 1: " + Arrays.toString(oldKeyL) + Arrays.toString(oldKeyU));
            return null;
        }
        if (requiresReinsert[0]) {
            System.err.println("Failed reinsert 2: " + Arrays.toString(oldKeyL) + Arrays.toString(oldKeyU));
            this.ensureCoverage(e);
            QRNode<T> r = this.root;
            int depth = 0;
            while (r instanceof QNode) {
                r = r.tryPut(e, this.maxNodeSize, depth++ > 50);
            }
        }
        return e.value();
    }

    private void ensureCoverage(QREntry<T> e) {
        double[] pLow = e.lower();
        while (!e.enclosedBy(this.root.getCenter(), this.root.getRadius())) {
            double[] center = this.root.getCenter();
            double radius = this.root.getRadius();
            double[] center2 = new double[center.length];
            double radius2 = radius * 2.0;
            for (int d = 0; d < center.length; ++d) {
                center2[d] = pLow[d] < center[d] - radius ? center[d] - radius : center[d] + radius;
            }
            this.root = new QRNode<T>(center2, radius2, this.root);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.root = null;
    }

    public QRIterator<T> queryIntersect(double[] min, double[] max) {
        return new QRIterator(this, min, max);
    }

    public List<QREntryDist<T>> knnQuery(double[] center, int k) {
        if (this.root == null) {
            return Collections.emptyList();
        }
        Comparator comp = (e1, e2) -> {
            double deltaDist = QUtil.distToRectEdge(center, e1) - QUtil.distToRectEdge(center, e2);
            return deltaDist < 0.0 ? -1 : (deltaDist > 0.0 ? 1 : 0);
        };
        double distEstimate = this.distanceEstimate(this.root, center, k, comp);
        ArrayList<QREntryDist<T>> candidates = new ArrayList<QREntryDist<T>>();
        while (candidates.size() < k) {
            candidates.clear();
            this.rangeSearchKNN(this.root, center, candidates, k, distEstimate);
            distEstimate *= 2.0;
        }
        return candidates;
    }

    private double distanceEstimate(QRNode<T> node, double[] point, int k, Comparator<QREntry<T>> comp) {
        if (node.getChildNodes() != null) {
            ArrayList<QRNode<T>> nodes = node.getChildNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                QRNode<T> sub = nodes.get(i);
                if (!QUtil.isPointEnclosed(point, sub.getCenter(), sub.getRadius())) continue;
                return this.distanceEstimate(sub, point, k, comp);
            }
            return node.getRadius() * Math.sqrt(point.length);
        }
        int n = node.getEntries().size();
        QREntry[] data = node.getEntries().toArray(new QREntry[n]);
        Arrays.sort(data, comp);
        int pos = n < k ? n : k;
        double dist = QUtil.distToRectEdge(point, data[pos - 1]);
        if (n < k) {
            dist *= Math.pow((double)k / (double)n, 1.0 / (double)this.dims);
        }
        if (dist <= 0.0) {
            return node.getRadius() * 2.0;
        }
        return dist;
    }

    private double rangeSearchKNN(QRNode<T> node, double[] center, ArrayList<QREntryDist<T>> candidates, int k, double maxRange) {
        ArrayList<QRNode<T>> nodes;
        ArrayList<QREntry<T>> points = node.getEntries();
        if (points != null) {
            for (int i = 0; i < points.size(); ++i) {
                QREntry<T> p = points.get(i);
                double dist = QUtil.distToRectEdge(center, p);
                if (!(dist < maxRange)) continue;
                candidates.add(new QREntryDist<T>(p, dist));
            }
            maxRange = this.adjustRegionKNN(candidates, k, maxRange);
        }
        if ((nodes = node.getChildNodes()) != null) {
            for (int i = 0; i < nodes.size(); ++i) {
                QRNode<T> sub = nodes.get(i);
                if (!(QUtil.distToRectNode(center, sub.getCenter(), sub.getRadius()) < maxRange)) continue;
                maxRange = this.rangeSearchKNN(sub, center, candidates, k, maxRange);
            }
        }
        return maxRange;
    }

    private double adjustRegionKNN(ArrayList<QREntryDist<T>> candidates, int k, double maxRange) {
        if (candidates.size() < k) {
            return maxRange;
        }
        candidates.sort(QREntryDist.COMP);
        while (candidates.size() > k) {
            candidates.remove(candidates.size() - 1);
        }
        double range = candidates.get(candidates.size() - 1).dist();
        return range;
    }

    @Override
    public String toStringTree() {
        StringBuilder sb = new StringBuilder();
        if (this.root == null) {
            sb.append("empty tree");
        } else {
            this.toStringTree(sb, this.root, 0, 0);
        }
        return sb.toString();
    }

    private void toStringTree(StringBuilder sb, QRNode<T> node, int depth, int posInParent) {
        Iterator<?> it = node.getChildIterator();
        String prefix = "";
        for (int i = 0; i < depth; ++i) {
            prefix = prefix + ".";
        }
        sb.append(prefix + posInParent + " d=" + depth);
        sb.append(" " + Arrays.toString(node.getCenter()));
        sb.append("/" + node.getRadius() + NL);
        prefix = prefix + " ";
        int pos = 0;
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof QRNode) {
                QRNode sub = (QRNode)o;
                this.toStringTree(sb, sub, depth + 1, pos);
            } else {
                QREntry e = (QREntry)o;
                sb.append(prefix + Arrays.toString(e.lower()) + Arrays.toString(e.upper()));
                sb.append(" v=" + e.value() + NL);
            }
            ++pos;
        }
    }

    public String toString() {
        return "QuadTreeRKD0;maxNodeSize=" + this.maxNodeSize + ";maxDepth=" + 50 + ";DEBUG=" + false + ";center/radius=" + (this.root == null ? "null" : Arrays.toString(this.root.getCenter()) + "/" + this.root.getRadius());
    }

    @Override
    public QuadTreeKD0.QStats getStats() {
        QuadTreeKD0.QStats s = new QuadTreeKD0.QStats();
        if (this.root != null) {
            this.root.checkNode(s, null, 0);
        }
        return s;
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public int getNodeCount() {
        return this.getStats().getNodeCount();
    }

    @Override
    public QueryIterator<RectangleEntry<T>> iterator() {
        throw new UnsupportedOperationException();
    }

    public QRQueryIteratorKNN queryKNN(double[] center, int k) {
        return new QRQueryIteratorKNN(center, k);
    }

    @Override
    public int getDepth() {
        return this.getStats().getMaxDepth();
    }

    private class QRQueryIteratorKNN
    implements QueryIteratorKNN<RectangleEntryDist<T>> {
        private Iterator<RectangleEntryDist<T>> it;

        public QRQueryIteratorKNN(double[] center, int k) {
            this.reset(center, k);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public RectangleEntryDist<T> next() {
            return this.it.next();
        }

        @Override
        public void reset(double[] center, int k) {
            this.it = QuadTreeRKD0.this.knnQuery(center, k).iterator();
        }
    }

    public static class QRIterator<T>
    implements QueryIterator<RectangleEntry<T>> {
        private final QuadTreeRKD0<T> tree;
        private ArrayDeque<Iterator<?>> stack = new ArrayDeque();
        private QREntry<T> next = null;
        private double[] min;
        private double[] max;

        QRIterator(QuadTreeRKD0<T> tree, double[] min, double[] max) {
            this.tree = tree;
            this.reset(min, max);
        }

        private void findNext() {
            while (!this.stack.isEmpty()) {
                Iterator<?> it = this.stack.peek();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (o instanceof QRNode) {
                        QRNode node = (QRNode)o;
                        if (!QUtil.overlap(this.min, this.max, node.getCenter(), node.getRadius())) continue;
                        it = node.getChildIterator();
                        this.stack.push(it);
                        continue;
                    }
                    QREntry e = (QREntry)o;
                    if (!QUtil.overlap(this.min, this.max, e.lower(), e.upper())) continue;
                    this.next = e;
                    return;
                }
                this.stack.pop();
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public QREntry<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            QREntry<T> ret = this.next;
            this.findNext();
            return ret;
        }

        @Override
        public void reset(double[] min, double[] max) {
            this.stack.clear();
            this.min = min;
            this.max = max;
            this.next = null;
            if (((QuadTreeRKD0)this.tree).root != null) {
                this.stack.push(((QuadTreeRKD0)this.tree).root.getChildIterator());
                this.findNext();
            }
        }
    }
}

