/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.array;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.tinspin.index.PointEntry;
import org.tinspin.index.PointEntryDist;
import org.tinspin.index.PointIndex;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.QueryIteratorKNN;

public class PointArray<T>
implements PointIndex<T> {
    private final double[][] phc;
    private final int dims;
    private int N;
    private PointEntry<T>[] values;
    private int insPos = 0;
    private final Comparator<KnnEntry<T>> COMP = new Comparator<KnnEntry<T>>(){

        @Override
        public int compare(KnnEntry<T> o1, KnnEntry<T> o2) {
            return o1.compareTo(o2);
        }
    };

    public PointArray(int dims, int size) {
        this.N = size;
        this.dims = dims;
        this.phc = new double[this.N][dims];
        this.values = new PointEntry[this.N];
    }

    @Override
    public void insert(double[] key, T value) {
        System.arraycopy(key, 0, this.phc[this.insPos], 0, this.dims);
        this.values[this.insPos] = new KnnEntry<T>(key, value, -1.0);
        ++this.insPos;
    }

    @Override
    public T queryExact(double[] point) {
        for (int j = 0; j < this.N; ++j) {
            if (!this.eq(this.phc[j], point)) continue;
            return this.values[j].value();
        }
        return null;
    }

    private boolean eq(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private boolean geq(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] < b[i])) continue;
            return false;
        }
        return true;
    }

    private boolean leq(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] > b[i])) continue;
            return false;
        }
        return true;
    }

    public AQueryIterator query(double[] min, double[] max) {
        return new AQueryIterator(min, max);
    }

    @Override
    public QueryIterator<? extends PointEntry<T>> iterator() {
        throw new UnsupportedOperationException();
    }

    public AQueryIteratorKNN queryKNN(double[] center, int k) {
        return new AQueryIteratorKNN(center, k);
    }

    private ArrayList<KnnEntry<T>> knnQuery(double[] center, int k) {
        ArrayList<KnnEntry<T>> ret = new ArrayList<KnnEntry<T>>(k);
        for (int i = 0; i < this.phc.length; ++i) {
            double[] p = this.phc[i];
            double dist = PointArray.dist(center, p);
            if (ret.size() < k) {
                ret.add(new KnnEntry<T>(p, this.values[i].value(), dist));
                ret.sort(this.COMP);
                continue;
            }
            if (!(((KnnEntry)ret.get(k - 1)).dist > dist)) continue;
            ret.remove(k - 1);
            ret.add(new KnnEntry<T>(p, this.values[i].value(), dist));
            ret.sort(this.COMP);
        }
        return ret;
    }

    private static double dist(double[] a, double[] b) {
        double dist = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double d = a[i] - b[i];
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    @Override
    public T update(double[] oldPoint, double[] newPoint) {
        for (int i = 0; i < this.N; ++i) {
            if (!this.eq(this.phc[i], oldPoint)) continue;
            System.arraycopy(newPoint, 0, this.phc[i], 0, this.dims);
            return this.values[i].value();
        }
        return null;
    }

    @Override
    public T remove(double[] point) {
        for (int i = 0; i < this.N; ++i) {
            if (this.phc[i] == null || !this.eq(this.phc[i], point)) continue;
            T v = this.values[i].value();
            this.values[i] = null;
            this.phc[i] = null;
            return v;
        }
        return null;
    }

    public String toString() {
        return "NaiveArray";
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public int size() {
        return this.N;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.N; ++i) {
            this.values[i] = null;
            this.phc[i] = null;
        }
        this.N = 0;
    }

    @Override
    public Object getStats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNodeCount() {
        return 1;
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public String toStringTree() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.N; ++i) {
            s.append(Arrays.toString(this.phc[i]) + " v=" + this.values[i]);
        }
        return s.toString();
    }

    private static class KnnEntry<T>
    implements Comparable<KnnEntry<T>>,
    PointEntryDist<T> {
        private final double[] p;
        private final double dist;
        private final T val;

        KnnEntry(double[] p, T val, double dist) {
            this.p = p;
            this.val = val;
            this.dist = dist;
        }

        @Override
        public int compareTo(KnnEntry<T> o) {
            double d = this.dist - o.dist;
            return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
        }

        public String toString() {
            return "d=" + this.dist + ":" + Arrays.toString(this.p);
        }

        @Override
        public double[] point() {
            return this.p;
        }

        @Override
        public T value() {
            return this.val;
        }

        @Override
        public double dist() {
            return this.dist;
        }
    }

    private class AQueryIteratorKNN
    implements QueryIteratorKNN<PointEntryDist<T>> {
        private Iterator<PointEntryDist<T>> it;

        public AQueryIteratorKNN(double[] center, int k) {
            this.reset(center, k);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public PointEntryDist<T> next() {
            return this.it.next();
        }

        @Override
        public void reset(double[] center, int k) {
            this.it = PointArray.this.knnQuery(center, k).iterator();
        }
    }

    private class AQueryIterator
    implements QueryIterator<PointEntry<T>> {
        private Iterator<PointEntry<T>> it;

        public AQueryIterator(double[] min, double[] max) {
            this.reset(min, max);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public PointEntry<T> next() {
            return this.it.next();
        }

        @Override
        public void reset(double[] min, double[] max) {
            ArrayList<PointEntry> results = new ArrayList<PointEntry>();
            for (int i = 0; i < PointArray.this.N; ++i) {
                if (!PointArray.this.leq(PointArray.this.phc[i], max) || !PointArray.this.geq(PointArray.this.phc[i], min)) continue;
                results.add(PointArray.this.values[i]);
            }
            this.it = results.iterator();
        }
    }
}

