/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.phtree;

import ch.ethz.globis.phtree.PhTreeF;
import org.tinspin.index.PointEntry;
import org.tinspin.index.PointEntryDist;
import org.tinspin.index.PointIndex;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.phtree.DistEntryP;
import org.tinspin.index.phtree.EntryP;

public class PHTreeP<T>
implements PointIndex<T> {
    private final PhTreeF<T> tree;

    private PHTreeP(int dims) {
        this.tree = PhTreeF.create((int)dims);
    }

    public static <T> PHTreeP<T> createPHTree(int dims) {
        return new PHTreeP<T>(dims);
    }

    @Override
    public int getDims() {
        return this.tree.getDim();
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public void clear() {
        this.tree.clear();
    }

    @Override
    public Object getStats() {
        return this.tree.getInternalTree().getStats();
    }

    @Override
    public int getNodeCount() {
        return this.tree.getInternalTree().getStats().getNodeCount();
    }

    @Override
    public int getDepth() {
        return this.tree.getInternalTree().getStats().getBitDepth();
    }

    @Override
    public String toStringTree() {
        return this.tree.getInternalTree().toStringTree();
    }

    @Override
    public void insert(double[] key, T value) {
        this.tree.put(key, value);
    }

    @Override
    public T remove(double[] point) {
        return (T)this.tree.remove(point);
    }

    @Override
    public T update(double[] oldPoint, double[] newPoint) {
        return (T)this.tree.update(oldPoint, newPoint);
    }

    @Override
    public T queryExact(double[] point) {
        return (T)this.tree.get(point);
    }

    @Override
    public QueryIterator<PointEntry<T>> query(double[] min, double[] max) {
        return new QueryIteratorPH(this.tree.query(min, max));
    }

    @Override
    public QueryIterator<PointEntry<T>> iterator() {
        return new IteratorPH((PhTreeF.PhIteratorF)this.tree.queryExtent());
    }

    @Override
    public QueryIteratorKNN<PointEntryDist<T>> queryKNN(double[] center, int k) {
        return new QueryIteratorKnnPH(this.tree.nearestNeighbour(k, center));
    }

    private static class QueryIteratorKnnPH<T>
    implements QueryIteratorKNN<PointEntryDist<T>> {
        private final PhTreeF.PhKnnQueryF<T> iter;

        private QueryIteratorKnnPH(PhTreeF.PhKnnQueryF<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public PointEntryDist<T> next() {
            PhTreeF.PhEntryDistF e = this.iter.nextEntryReuse();
            return new DistEntryP<Object>((double[])e.getKey().clone(), e.getValue(), e.dist());
        }

        @Override
        public void reset(double[] center, int k) {
            this.iter.reset(k, null, center);
        }
    }

    private static class QueryIteratorPH<T>
    implements QueryIterator<PointEntry<T>> {
        private final PhTreeF.PhQueryF<T> iter;

        private QueryIteratorPH(PhTreeF.PhQueryF<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public PointEntry<T> next() {
            PhTreeF.PhEntryF e = this.iter.nextEntryReuse();
            return new EntryP<Object>((double[])e.getKey().clone(), e.getValue());
        }

        @Override
        public void reset(double[] min, double[] max) {
            this.iter.reset(min, max);
        }
    }

    private static class IteratorPH<T>
    implements QueryIterator<PointEntry<T>> {
        private final PhTreeF.PhIteratorF<T> iter;

        private IteratorPH(PhTreeF.PhIteratorF<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public PointEntry<T> next() {
            PhTreeF.PhEntryF e = this.iter.nextEntryReuse();
            return new EntryP<Object>((double[])e.getKey().clone(), e.getValue());
        }

        @Override
        public void reset(double[] min, double[] max) {
            throw new UnsupportedOperationException();
        }
    }
}

