/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import org.tinspin.index.RectangleEntry;

public interface Filter {
    public static final Filter ALL = new Filter(){

        @Override
        public boolean intersects(double[] min, double[] max) {
            return true;
        }
    };

    public boolean intersects(double[] var1, double[] var2);

    default public boolean matches(RectangleEntry<?> entry) {
        return this.intersects(entry.lower(), entry.upper());
    }

    public static class UnionFilter
    implements Filter {
        private final Filter filter1;
        private final Filter filter2;

        public UnionFilter(Filter filter1, Filter filter2) {
            this.filter1 = filter1;
            this.filter2 = filter2;
        }

        @Override
        public boolean intersects(double[] min, double[] max) {
            return this.filter1.intersects(min, max) || this.filter2.intersects(min, max);
        }

        @Override
        public boolean matches(RectangleEntry<?> entry) {
            return this.filter1.matches(entry) || this.filter2.matches(entry);
        }

        public UnionFilter union(Filter anotherFilter) {
            return new UnionFilter(this, anotherFilter);
        }
    }

    public static class RectangleIntersectFilter
    implements Filter {
        private final double[] lower;
        private final double[] upper;

        public RectangleIntersectFilter(double[] lower, double[] upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public boolean intersects(double[] min, double[] max) {
            boolean inter = true;
            for (int i = 0; i < min.length; ++i) {
                inter &= this.upper[i] > min[i];
                inter &= this.lower[i] < max[i];
            }
            return inter;
        }
    }
}

