/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.RectangleEntry;
import org.tinspin.index.rtree.Entry;
import org.tinspin.index.rtree.RTree;
import org.tinspin.index.rtree.RTreeNode;

public class RTreeIterator<T>
implements QueryIterator<RectangleEntry<T>> {
    private final RTree<T> tree;
    private double[] min;
    private double[] max;
    private IteratorStack stack;
    private boolean hasNext = true;
    private Entry<T> next;

    public RTreeIterator(RTree<T> tree, double[] min, double[] max) {
        this.stack = new IteratorStack(tree.getDepth());
        this.tree = tree;
        this.reset(min, max);
    }

    @Override
    public void reset(double[] min, double[] max) {
        if (this.stack.stack.length < this.tree.getDepth()) {
            this.stack = new IteratorStack(this.tree.getDepth());
        } else {
            this.stack.size = 0;
        }
        this.min = min;
        this.max = max;
        this.hasNext = true;
        if (!Entry.checkOverlap(min, max, this.tree.getRoot())) {
            this.hasNext = false;
            return;
        }
        this.stack.prepareAndPush(this.tree.getRoot());
        this.findNext();
    }

    private void findNext() {
        block0: while (!this.stack.isEmpty()) {
            IterPos ip = this.stack.peek();
            ArrayList entries = ip.node.getEntries();
            while (ip.pos < entries.size()) {
                Entry e = entries.get(ip.pos);
                ip.pos++;
                if (!Entry.checkOverlap(this.min, this.max, e)) continue;
                if (e instanceof RTreeNode) {
                    this.stack.prepareAndPush((RTreeNode)e);
                    continue block0;
                }
                this.next = e;
                return;
            }
            this.stack.pop();
        }
        this.hasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Entry<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Entry<T> ret = this.next;
        this.findNext();
        return ret;
    }

    private static class IterPos<T> {
        private RTreeNode<T> node;
        private int pos;

        private IterPos() {
        }

        public void init(RTreeNode<T> node) {
            this.node = node;
            this.pos = 0;
        }
    }

    private class IteratorStack {
        private final IterPos<T>[] stack;
        private int size = 0;

        IteratorStack(int depth) {
            this.stack = new IterPos[depth];
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        IterPos<T> prepareAndPush(RTreeNode<T> node) {
            IterPos ni;
            if ((ni = this.stack[this.size++]) == null) {
                ni = new IterPos();
                this.stack[this.size - 1] = ni;
            }
            ni.init(node);
            return ni;
        }

        IterPos<T> peek() {
            return this.stack[this.size - 1];
        }

        IterPos<T> pop() {
            return this.stack[--this.size];
        }
    }
}

