/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.tinspin.index.rtree.DistEntry;
import org.tinspin.index.rtree.DistanceFunction;
import org.tinspin.index.rtree.Entry;
import org.tinspin.index.rtree.RTree;
import org.tinspin.index.rtree.RTreeNode;
import org.tinspin.index.rtree.RTreeNodeDir;

public class RTreeQuery1NN<T> {
    private final DEComparator COMP = new DEComparator();
    private final RTree<T> tree;
    private double[] center;
    private IteratorStack stack;
    private DistanceFunction dist;

    public RTreeQuery1NN(RTree<T> tree) {
        this.stack = new IteratorStack(tree.getDepth(), 10);
        this.tree = tree;
    }

    public DistEntry<T> reset(double[] center, DistanceFunction dist) {
        if (this.stack.stack.length < this.tree.getDepth()) {
            this.stack = new IteratorStack(this.tree.getDepth(), 10);
        } else {
            this.stack.size = 0;
        }
        if (dist != null) {
            this.dist = dist;
        }
        if (this.dist == null) {
            this.dist = DistanceFunction.EDGE;
        }
        if (this.dist != DistanceFunction.EDGE) {
            System.err.println("This distance iterator only works for EDGE distance");
        }
        this.center = center;
        if (this.tree.size() == 0) {
            return null;
        }
        this.stack.prepareAndPush(this.tree.getRoot(), Double.POSITIVE_INFINITY);
        return this.findCandidate();
    }

    private DistEntry<T> findCandidate() {
        DistEntry<Object> candidate = new DistEntry<Object>(null, null, null, Double.POSITIVE_INFINITY);
        double currentDist = Double.MAX_VALUE;
        while (!this.stack.isEmpty()) {
            IterPos ip = this.stack.peek();
            if (ip.node instanceof RTreeNodeDir) {
                if (ip.pos < ip.maxPos && ip.subNodes[ip.pos].dist() < currentDist) {
                    this.stack.prepareAndPush((RTreeNode)ip.subNodes[ip.pos].value(), currentDist);
                    ++ip.pos;
                    continue;
                }
            } else {
                ArrayList entries = ip.node.getEntries();
                while (ip.pos < entries.size()) {
                    Entry e = entries.get(ip.pos);
                    ++ip.pos;
                    double d = this.dist.dist(this.center, e.min, e.max);
                    if (!(candidate.dist() > d)) continue;
                    candidate.set(e, d);
                    currentDist = d;
                }
            }
            this.stack.pop();
        }
        return candidate;
    }

    protected void sortEntries(IterPos<T> iPos, double minDist) {
        int i;
        ArrayList subNodes = ((RTreeNodeDir)iPos.node).getChildren();
        DistEntry<RTreeNode<T>>[] ret = iPos.subNodes;
        int pos = 0;
        for (i = 0; i < subNodes.size(); ++i) {
            RTreeNode e = subNodes.get(i);
            double d = this.dist.dist(this.center, e.min, e.max);
            if (!(d < minDist)) continue;
            ret[pos++].set(e.lower(), e.upper(), e, d);
        }
        Arrays.sort(ret, 0, pos, this.COMP);
        for (i = 0; i < pos; ++i) {
            if (!(ret[i].dist() > minDist)) continue;
            pos = i;
            break;
        }
        iPos.maxPos = pos;
    }

    private static class IterPos<T> {
        final DistEntry<RTreeNode<T>>[] subNodes;
        RTreeNode<T> node;
        int pos;
        int maxPos;

        public IterPos(int nSubNodes) {
            this.subNodes = new DistEntry[nSubNodes];
            for (int i = 0; i < nSubNodes; ++i) {
                this.subNodes[i] = new DistEntry<Object>(null, null, null, Double.POSITIVE_INFINITY);
            }
        }

        void init(RTreeNode<T> node) {
            this.node = node;
            this.pos = 0;
        }
    }

    private static class DEComparator
    implements Comparator<DistEntry<?>> {
        private DEComparator() {
        }

        @Override
        public int compare(DistEntry<?> o1, DistEntry<?> o2) {
            double d = o1.dist() - o2.dist();
            return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
        }
    }

    private class IteratorStack {
        private final IterPos<T>[] stack;
        private int size = 0;

        IteratorStack(int depth, int nSubNodes) {
            this.stack = new IterPos[depth];
            for (int i = 0; i < this.stack.length; ++i) {
                this.stack[i] = new IterPos(nSubNodes);
            }
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        IterPos<T> prepareAndPush(RTreeNode<T> node, double minDist) {
            IterPos ni = this.stack[this.size++];
            ni.init(node);
            if (ni.node instanceof RTreeNodeDir) {
                RTreeQuery1NN.this.sortEntries(ni, minDist);
            }
            return ni;
        }

        IterPos<T> peek() {
            return this.stack[this.size - 1];
        }

        IterPos<T> pop() {
            return this.stack[--this.size];
        }
    }
}

