/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.array;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.RectangleEntry;
import org.tinspin.index.RectangleEntryDist;
import org.tinspin.index.RectangleIndex;
import org.tinspin.index.Stats;

public class RectArray<T>
implements RectangleIndex<T> {
    private final double[][] phc;
    private final int dims;
    private int N;
    private RectangleEntry<T>[] values;
    private int insPos = 0;
    private final Comparator<KnnEntry<T>> COMP = new Comparator<KnnEntry<T>>(){

        @Override
        public int compare(KnnEntry<T> o1, KnnEntry<T> o2) {
            return o1.compareTo(o2);
        }
    };

    public RectArray(int dims, int size) {
        this.N = size;
        this.dims = dims;
        this.phc = new double[2 * this.N][dims];
        this.values = new RectangleEntry[this.N];
    }

    @Override
    public void insert(double[] lower, double[] upper, T value) {
        System.arraycopy(lower, 0, this.phc[this.insPos * 2], 0, this.dims);
        System.arraycopy(upper, 0, this.phc[this.insPos * 2 + 1], 0, this.dims);
        this.values[this.insPos] = new KnnEntry<T>(lower, upper, value, -1.0);
        ++this.insPos;
    }

    @Override
    public T queryExact(double[] lower, double[] upper) {
        for (int j = 0; j < this.N; ++j) {
            if (!this.eq(this.phc[j * 2], lower) || !this.eq(this.phc[j * 2 + 1], upper)) continue;
            return this.values[j].value();
        }
        return null;
    }

    private boolean eq(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private boolean geq(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] < b[i])) continue;
            return false;
        }
        return true;
    }

    private boolean leq(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] > b[i])) continue;
            return false;
        }
        return true;
    }

    public AQueryIterator queryIntersect(double[] min, double[] max) {
        return new AQueryIterator(min, max);
    }

    @Override
    public QueryIterator<RectangleEntry<T>> iterator() {
        throw new UnsupportedOperationException();
    }

    public AQueryIteratorKNN queryKNN(double[] center, int k) {
        return new AQueryIteratorKNN(center, k);
    }

    private ArrayList<KnnEntry<T>> knnQuery(double[] center, int k) {
        ArrayList<KnnEntry<T>> ret = new ArrayList<KnnEntry<T>>(k);
        for (int i = 0; i < this.phc.length / 2; ++i) {
            double[] min = this.phc[i * 2];
            double[] max = this.phc[i * 2 + 1];
            double dist = RectArray.distREdge(center, min, max);
            if (ret.size() < k) {
                ret.add(new KnnEntry<T>(min, max, this.values[i].value(), dist));
                ret.sort(this.COMP);
                continue;
            }
            if (!(((KnnEntry)ret.get(k - 1)).dist > dist)) continue;
            ret.remove(k - 1);
            ret.add(new KnnEntry<T>(min, max, this.values[i].value(), dist));
            ret.sort(this.COMP);
        }
        return ret;
    }

    private static double distREdge(double[] center, double[] rLower, double[] rUpper) {
        double dist = 0.0;
        for (int i = 0; i < center.length; ++i) {
            double d = 0.0;
            if (center[i] > rUpper[i]) {
                d = center[i] - rUpper[i];
            } else if (center[i] < rLower[i]) {
                d = rLower[i] - center[i];
            }
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    @Override
    public T update(double[] lo1, double[] up1, double[] lo2, double[] up2) {
        for (int i = 0; i < this.N; ++i) {
            if (!this.eq(this.phc[i * 2], lo1) || !this.eq(this.phc[i * 2 + 1], up1)) continue;
            System.arraycopy(lo2, 0, this.phc[i * 2], 0, this.dims);
            System.arraycopy(up2, 0, this.phc[i * 2 + 1], 0, this.dims);
            return this.values[i].value();
        }
        return null;
    }

    @Override
    public T remove(double[] lower, double[] upper) {
        for (int i = 0; i < this.N; ++i) {
            if (this.phc[i * 2] == null || !this.eq(this.phc[i * 2], lower) || !this.eq(this.phc[i * 2 + 1], upper)) continue;
            this.phc[i * 2] = null;
            this.phc[i * 2 + 1] = null;
            T val = this.values[i].value();
            return val;
        }
        return null;
    }

    public String toString() {
        return "NaiveArray";
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public int size() {
        return this.N;
    }

    @Override
    public void clear() {
        int i;
        for (i = 0; i < this.N; ++i) {
            this.values[i] = null;
        }
        for (i = 0; i < 2 * this.N; ++i) {
            this.phc[i] = null;
        }
        this.N = 0;
    }

    @Override
    public Stats getStats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNodeCount() {
        return 1;
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public String toStringTree() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.N; ++i) {
            s.append(Arrays.toString(this.phc[i * 2]) + "/" + Arrays.toString(this.phc[i * 2 + 1]) + " v=" + this.values[i]);
        }
        return s.toString();
    }

    private static class KnnEntry<T>
    implements Comparable<KnnEntry<T>>,
    RectangleEntryDist<T> {
        private final double[] min;
        private final double[] max;
        private final T val;
        private final double dist;

        KnnEntry(double[] min, double[] max, T val, double dist) {
            this.min = min;
            this.max = max;
            this.val = val;
            this.dist = dist;
        }

        @Override
        public int compareTo(KnnEntry<T> o) {
            double d = this.dist - o.dist;
            return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
        }

        public String toString() {
            return "d=" + this.dist + ":" + Arrays.toString(this.min) + "/" + Arrays.toString(this.max);
        }

        @Override
        public double[] lower() {
            return this.min;
        }

        @Override
        public double[] upper() {
            return this.max;
        }

        @Override
        public T value() {
            return this.val;
        }

        @Override
        public double dist() {
            return this.dist;
        }
    }

    private class AQueryIteratorKNN
    implements QueryIteratorKNN<RectangleEntryDist<T>> {
        private Iterator<RectangleEntryDist<T>> it;

        public AQueryIteratorKNN(double[] center, int k) {
            this.reset(center, k);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public RectangleEntryDist<T> next() {
            return this.it.next();
        }

        public AQueryIteratorKNN reset(double[] center, int k) {
            this.it = RectArray.this.knnQuery(center, k).iterator();
            return this;
        }
    }

    private class AQueryIterator
    implements QueryIterator<RectangleEntry<T>> {
        private Iterator<RectangleEntry<T>> it;

        public AQueryIterator(double[] min, double[] max) {
            this.reset(min, max);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public RectangleEntry<T> next() {
            return this.it.next();
        }

        @Override
        public void reset(double[] min, double[] max) {
            ArrayList<RectangleEntry> results = new ArrayList<RectangleEntry>();
            for (int i = 0; i < RectArray.this.N; ++i) {
                if (!RectArray.this.leq(RectArray.this.phc[i * 2], max) || !RectArray.this.geq(RectArray.this.phc[i * 2 + 1], min)) continue;
                results.add(RectArray.this.values[i]);
            }
            this.it = results.iterator();
        }
    }
}

