/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qthypercube2;

import java.util.Arrays;
import org.tinspin.index.qthypercube2.QEntry;
import org.tinspin.index.qthypercube2.QUtil;
import org.tinspin.index.qthypercube2.QuadTreeKD2;

public class QNode<T> {
    private double[] center;
    private double radius;
    private QEntry<T>[] values;
    private Object[] subs;
    private int nValues = 0;
    private boolean isLeaf;

    QNode(double[] center, double radius) {
        this.center = center;
        this.radius = radius;
        this.values = new QEntry[2];
        this.isLeaf = true;
    }

    QNode(double[] center, double radius, QNode<T> subNode, int subNodePos) {
        this.center = center;
        this.radius = radius;
        this.values = null;
        this.subs = new Object[1 << center.length];
        this.subs[subNodePos] = subNode;
        this.isLeaf = false;
    }

    QNode<T> tryPut(QEntry<T> e, int maxNodeSize, boolean enforceLeaf) {
        if (!this.isLeaf()) {
            return this.getOrCreateSub(e, maxNodeSize, enforceLeaf);
        }
        if (this.nValues < maxNodeSize || enforceLeaf || this.areAllPointsIdentical(e)) {
            this.addValue(e, maxNodeSize);
            return null;
        }
        QEntry<T>[] vals = this.values;
        int nVal = this.nValues;
        this.clearValues();
        this.subs = new Object[1 << this.center.length];
        this.isLeaf = false;
        for (int i = 0; i < nVal; ++i) {
            QEntry<T> e2 = vals[i];
            for (QNode<T> sub = this.getOrCreateSub(e2, maxNodeSize, enforceLeaf); sub != null; sub = sub.tryPut(e2, maxNodeSize, false)) {
            }
        }
        return this.getOrCreateSub(e, maxNodeSize, enforceLeaf);
    }

    private boolean areAllPointsIdentical(QEntry<T> e) {
        for (int i = 0; i < this.nValues; ++i) {
            if (e.isExact(this.values[i])) continue;
            return false;
        }
        return true;
    }

    private QEntry<T>[] getValues() {
        return this.values;
    }

    private void addValue(QEntry<T> e, int maxNodeSize) {
        int maxLen;
        int n = maxLen = this.nValues >= maxNodeSize ? this.nValues * 2 : maxNodeSize;
        if (this.nValues >= this.getValues().length) {
            this.values = Arrays.copyOf(this.getValues(), this.nValues * 3 > maxLen ? maxLen : this.nValues * 3);
        }
        this.getValues()[this.nValues++] = e;
    }

    private void removeValue(int pos) {
        if (this.isLeaf) {
            if (pos < --this.nValues) {
                System.arraycopy(this.getValues(), pos + 1, this.getValues(), pos, this.nValues - pos);
            }
        } else {
            --this.nValues;
            this.subs[pos] = null;
        }
    }

    private void clearValues() {
        this.values = null;
        this.nValues = 0;
    }

    private QNode<T> getOrCreateSub(QEntry<T> e, int maxNodeSize, boolean enforceLeaf) {
        QNode<T> sub;
        int pos = this.calcSubPosition(e.point());
        Object n = this.subs[pos];
        if (n instanceof QNode) {
            return (QNode)n;
        }
        if (n == null) {
            this.subs[pos] = e;
            ++this.nValues;
            return null;
        }
        QEntry e2 = (QEntry)n;
        --this.nValues;
        this.subs[pos] = sub = this.createSubForEntry(pos);
        sub.tryPut(e2, maxNodeSize, enforceLeaf);
        return sub;
    }

    private QNode<T> createSubForEntry(int subNodePos) {
        double[] centerSub = new double[this.center.length];
        int mask = 1 << this.center.length;
        double radiusSub = this.radius / 2.0;
        for (int d = 0; d < this.center.length; ++d) {
            centerSub[d] = (subNodePos & (mask >>= 1)) > 0 ? this.center[d] + radiusSub : this.center[d] - radiusSub;
        }
        return new QNode<T>(centerSub, radiusSub);
    }

    int calcSubPosition(double[] p) {
        int subNodePos = 0;
        for (int d = 0; d < this.center.length; ++d) {
            subNodePos <<= 1;
            if (!(p[d] >= this.center[d])) continue;
            subNodePos |= 1;
        }
        return subNodePos;
    }

    QEntry<T> remove(QNode<T> parent, double[] key, int maxNodeSize) {
        if (!this.isLeaf()) {
            QEntry e;
            int pos = this.calcSubPosition(key);
            Object o = this.subs[pos];
            if (o instanceof QNode) {
                return ((QNode)o).remove(this, key, maxNodeSize);
            }
            if (o instanceof QEntry && this.removeSub(parent, key, pos, e = (QEntry)o, maxNodeSize)) {
                return e;
            }
            return null;
        }
        for (int i = 0; i < this.nValues; ++i) {
            QEntry<T> e = this.values[i];
            if (!this.removeSub(parent, key, i, e, maxNodeSize)) continue;
            return e;
        }
        return null;
    }

    private boolean removeSub(QNode<T> parent, double[] key, int pos, QEntry<T> e, int maxNodeSize) {
        if (QUtil.isPointEqual(e.point(), key)) {
            this.removeValue(pos);
            if (parent != null) {
                super.checkAndMergeLeafNodes(maxNodeSize);
            }
            return true;
        }
        return false;
    }

    QEntry<T> update(QNode<T> parent, double[] keyOld, double[] keyNew, int maxNodeSize, boolean[] requiresReinsert, int currentDepth, int maxDepth) {
        QEntry<T> e;
        if (!this.isLeaf()) {
            int pos = this.calcSubPosition(keyOld);
            e = this.subs[pos];
            if (e == null) {
                return null;
            }
            if (e instanceof QNode) {
                QNode sub = (QNode)((Object)e);
                QEntry<T> ret = sub.update(this, keyOld, keyNew, maxNodeSize, requiresReinsert, currentDepth + 1, maxDepth);
                if (ret != null && requiresReinsert[0] && QUtil.isPointEnclosed(ret.point(), this.center, this.radius / 1.000000001)) {
                    requiresReinsert[0] = false;
                    QNode<T> r = this;
                    while (r instanceof QNode) {
                        r = r.tryPut(ret, maxNodeSize, currentDepth++ > maxDepth);
                    }
                }
                return ret;
            }
            QEntry<T> qe = e;
            if (QUtil.isPointEqual(qe.point(), keyOld)) {
                this.removeValue(pos);
                qe.setKey(keyNew);
                if (QUtil.isPointEnclosed(keyNew, this.center, this.radius / 1.000000001)) {
                    QNode<T> r = this;
                    while (r instanceof QNode) {
                        r = r.tryPut(qe, maxNodeSize, currentDepth++ > maxDepth);
                    }
                    requiresReinsert[0] = false;
                } else {
                    requiresReinsert[0] = true;
                    if (parent != null) {
                        super.checkAndMergeLeafNodes(maxNodeSize);
                    }
                }
                return qe;
            }
        }
        for (int i = 0; i < this.nValues; ++i) {
            e = this.getValues()[i];
            if (!QUtil.isPointEqual(e.point(), keyOld)) continue;
            this.removeValue(i);
            e.setKey(keyNew);
            this.updateSub(keyNew, e, parent, maxNodeSize, requiresReinsert);
            return e;
        }
        requiresReinsert[0] = false;
        return null;
    }

    private void updateSub(double[] keyNew, QEntry<T> e, QNode<T> parent, int maxNodeSize, boolean[] requiresReinsert) {
        if (QUtil.isPointEnclosed(keyNew, this.center, this.radius / 1.000000001)) {
            this.addValue(e, maxNodeSize);
            requiresReinsert[0] = false;
        } else {
            requiresReinsert[0] = true;
            if (parent != null) {
                super.checkAndMergeLeafNodes(maxNodeSize);
            }
        }
    }

    private void checkAndMergeLeafNodes(int maxNodeSize) {
        QNode sub;
        Object e;
        int i;
        int nTotal = this.nValues;
        for (i = 0; i < this.subs.length; ++i) {
            e = this.subs[i];
            if (!(e instanceof QNode)) continue;
            sub = (QNode)e;
            if (!sub.isLeaf()) {
                return;
            }
            if ((nTotal += sub.getValueCount()) <= maxNodeSize) continue;
            return;
        }
        this.values = new QEntry[nTotal];
        this.nValues = 0;
        for (i = 0; i < this.subs.length; ++i) {
            e = this.subs[i];
            if (e instanceof QNode) {
                sub = (QNode)e;
                for (int j = 0; j < sub.nValues; ++j) {
                    this.values[this.nValues++] = sub.values[j];
                }
                continue;
            }
            if (!(e instanceof QEntry)) continue;
            this.values[this.nValues++] = (QEntry)e;
        }
        this.subs = null;
        this.isLeaf = true;
    }

    double[] getCenter() {
        return this.center;
    }

    double getRadius() {
        return this.radius;
    }

    QEntry<T> getExact(double[] key) {
        if (!this.isLeaf()) {
            QEntry e;
            int pos = this.calcSubPosition(key);
            Object sub = this.subs[pos];
            if (sub instanceof QNode) {
                return ((QNode)sub).getExact(key);
            }
            if (sub != null && QUtil.isPointEqual((e = (QEntry)sub).point(), key)) {
                return e;
            }
            return null;
        }
        for (int i = 0; i < this.nValues; ++i) {
            QEntry<T> e = this.values[i];
            if (!QUtil.isPointEqual(e.point(), key)) continue;
            return e;
        }
        return null;
    }

    Object[] getEntries() {
        return this.isLeaf ? this.values : this.subs;
    }

    public String toString() {
        return "center/radius=" + Arrays.toString(this.center) + "/" + this.radius + " " + System.identityHashCode(this);
    }

    void checkNode(QuadTreeKD2.QStats s, QNode<T> parent, int depth) {
        if (depth > s.maxDepth) {
            s.maxDepth = depth;
        }
        ++s.nNodes;
        if (parent != null && !QUtil.isRectEnclosed(this.center, this.radius, parent.center, parent.radius * 1.000000001)) {
            for (int d = 0; d < this.center.length; ++d) {
                System.out.println("Outer: " + parent.radius + " " + Arrays.toString(parent.center));
                System.out.println("Child: " + this.radius + " " + Arrays.toString(this.center));
                System.out.println(parent.center[d] + parent.radius + " vs " + (this.center[d] + this.radius));
                System.out.println("r=" + (parent.center[d] + parent.radius) / (this.center[d] + this.radius));
                System.out.println(parent.center[d] - parent.radius + " vs " + (this.center[d] - this.radius));
                System.out.println("r=" + (parent.center[d] - parent.radius) / (this.center[d] - this.radius));
            }
            throw new IllegalStateException();
        }
        if (this.values != null) {
            ++s.nLeaf;
            s.nEntries += this.nValues;
            int n = this.nValues;
            s.histoValues[n] = s.histoValues[n] + 1;
            for (int i = 0; i < this.nValues; ++i) {
                QEntry<T> e = this.values[i];
                this.checkEntry(e);
            }
            if (this.subs != null) {
                throw new IllegalStateException();
            }
        } else {
            ++s.nInner;
            if ((long)this.subs.length != 1L << s.dims) {
                throw new IllegalStateException();
            }
            int nSubs = 0;
            for (int i = 0; i < this.subs.length; ++i) {
                Object n = this.subs[i];
                if (n instanceof QNode) {
                    ++nSubs;
                    ((QNode)n).checkNode(s, this, depth + 1);
                    continue;
                }
                if (n == null) continue;
                ++s.nEntries;
                this.checkEntry(n);
            }
            s.histo(nSubs);
        }
    }

    private void checkEntry(Object o) {
        QEntry e = (QEntry)o;
        if (!QUtil.isPointEnclosed(e.point(), this.center, this.radius * 1.000000001)) {
            System.out.println("Node: " + this.radius + " " + Arrays.toString(this.center));
            System.out.println("Child: " + Arrays.toString(e.point()));
            for (int d = 0; d < this.center.length; ++d) {
                System.out.println("min/max for " + d);
                System.out.println("min: " + (this.center[d] - this.radius) + " vs " + e.point()[d]);
                System.out.println("r=" + (this.center[d] - this.radius) / e.point()[d]);
                System.out.println("max: " + (this.center[d] + this.radius) + " vs " + e.point()[d]);
                System.out.println("r=" + (this.center[d] + this.radius) / e.point()[d]);
            }
            throw new IllegalStateException();
        }
    }

    boolean isLeaf() {
        return this.isLeaf;
    }

    public int getValueCount() {
        return this.nValues;
    }
}

