/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qthypercube2;

public class QUtil {
    static final double EPS_MUL = 1.000000001;

    public static boolean isPointEnclosed(double[] point, double[] min, double[] max) {
        for (int d = 0; d < min.length; ++d) {
            if (!(point[d] < min[d]) && !(point[d] > max[d])) continue;
            return false;
        }
        return true;
    }

    public static boolean isPointEnclosed(double[] point, double[] center, double radius) {
        for (int d = 0; d < center.length; ++d) {
            if (!(point[d] < center[d] - radius) && !(point[d] > center[d] + radius)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPointEqual(double[] p1, double[] p2) {
        for (int d = 0; d < p1.length; ++d) {
            if (p1[d] == p2[d]) continue;
            return false;
        }
        return true;
    }

    public static boolean isRectEqual(double[] p1L, double[] p1U, double[] p2L, double[] p2U) {
        return QUtil.isPointEqual(p1L, p2L) && QUtil.isPointEqual(p1U, p2U);
    }

    public static boolean overlap(double[] min, double[] max, double[] min2, double[] max2) {
        for (int d = 0; d < min.length; ++d) {
            if (!(max[d] < min2[d]) && !(min[d] > max2[d])) continue;
            return false;
        }
        return true;
    }

    public static boolean overlap(double[] min, double[] max, double[] center, double radius) {
        for (int d = 0; d < min.length; ++d) {
            if (!(max[d] < center[d] - radius) && !(min[d] > center[d] + radius)) continue;
            return false;
        }
        return true;
    }

    public static boolean isRectEnclosed(double[] minEnclosed, double[] maxEnclosed, double[] minOuter, double[] maxOuter) {
        for (int d = 0; d < minOuter.length; ++d) {
            if (!(maxOuter[d] < maxEnclosed[d]) && !(minOuter[d] > minEnclosed[d])) continue;
            return false;
        }
        return true;
    }

    public static boolean isRectEnclosed(double[] minEnclosed, double[] maxEnclosed, double[] centerOuter, double radiusOuter) {
        for (int d = 0; d < centerOuter.length; ++d) {
            double radOuter = radiusOuter;
            if (!(centerOuter[d] + radOuter < maxEnclosed[d]) && !(centerOuter[d] - radOuter > minEnclosed[d])) continue;
            return false;
        }
        return true;
    }

    public static boolean isRectEnclosed(double[] centerEnclosed, double radiusEnclosed, double[] centerOuter, double radiusOuter) {
        for (int d = 0; d < centerOuter.length; ++d) {
            double radOuter = radiusOuter;
            double radEncl = radiusEnclosed;
            if (!(centerOuter[d] + radOuter < centerEnclosed[d] + radEncl) && !(centerOuter[d] - radOuter > centerEnclosed[d] - radEncl)) continue;
            return false;
        }
        return true;
    }

    public static double distance(double[] p1, double[] p2) {
        double dist = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            double d = p1[i] - p2[i];
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    public static double distToRectCenter(double[] p, double[] rMin, double[] rMax) {
        double dist = 0.0;
        for (int i = 0; i < p.length; ++i) {
            double d = (rMin[i] + rMax[i]) / 2.0 - p[i];
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    static double distToRectEdge(double[] center, double[] rLower, double[] rUpper) {
        double dist = 0.0;
        for (int i = 0; i < center.length; ++i) {
            double d = 0.0;
            if (center[i] > rUpper[i]) {
                d = center[i] - rUpper[i];
            } else if (center[i] < rLower[i]) {
                d = rLower[i] - center[i];
            }
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    static double distToRectNode(double[] point, double[] nodeCenter, double nodeRadius) {
        double dist = 0.0;
        for (int i = 0; i < point.length; ++i) {
            double d = 0.0;
            if (point[i] > nodeCenter[i] + nodeRadius) {
                d = point[i] - (nodeCenter[i] + nodeRadius);
            } else if (point[i] < nodeCenter[i] - nodeRadius) {
                d = nodeCenter[i] - nodeRadius - point[i];
            }
            dist += d * d;
        }
        return Math.sqrt(dist);
    }
}

