/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qthypercube2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.tinspin.index.PointEntry;
import org.tinspin.index.PointEntryDist;
import org.tinspin.index.PointIndex;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.Stats;
import org.tinspin.index.qthypercube2.QEntry;
import org.tinspin.index.qthypercube2.QEntryDist;
import org.tinspin.index.qthypercube2.QIterator0;
import org.tinspin.index.qthypercube2.QIterator1;
import org.tinspin.index.qthypercube2.QIterator2;
import org.tinspin.index.qthypercube2.QNode;
import org.tinspin.index.qthypercube2.QUtil;

public class QuadTreeKD2<T>
implements PointIndex<T> {
    public static boolean ENABLE_HCI_1 = true;
    public static boolean ENABLE_HCI_2 = true;
    private static final int MAX_DEPTH = 50;
    private static final String NL = System.lineSeparator();
    public static final boolean DEBUG = false;
    private static final int DEFAULT_MAX_NODE_SIZE = 10;
    private final int dims;
    private final int maxNodeSize;
    private QNode<T> root = null;
    private int size = 0;
    private static Comparator<KnnTemp> KnnTempComp = (point1, point2) -> {
        double deltaDist = point1.dist - point2.dist;
        return deltaDist < 0.0 ? -1 : (deltaDist > 0.0 ? 1 : 0);
    };

    private QuadTreeKD2(int dims, int maxNodeSize) {
        this.dims = dims;
        this.maxNodeSize = maxNodeSize;
    }

    public static <T> QuadTreeKD2<T> create(int dims) {
        int maxNodeSize = 10;
        if (2 * dims > 10) {
            maxNodeSize = 2 * dims;
        }
        return new QuadTreeKD2<T>(dims, maxNodeSize);
    }

    public static <T> QuadTreeKD2<T> create(int dims, int maxNodeSize) {
        return new QuadTreeKD2<T>(dims, maxNodeSize);
    }

    public static <T> QuadTreeKD2<T> create(int dims, int maxNodeSize, double[] center, double radius) {
        QuadTreeKD2<T> t = new QuadTreeKD2<T>(dims, maxNodeSize);
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius must be > 0 but was " + radius);
        }
        t.root = new QNode(Arrays.copyOf(center, center.length), radius);
        return t;
    }

    @Override
    public void insert(double[] key, T value) {
        ++this.size;
        QEntry<T> e = new QEntry<T>(key, value);
        if (this.root == null) {
            this.initializeRoot(key);
        }
        this.ensureCoverage(e);
        QNode<T> r = this.root;
        int depth = 0;
        while (r instanceof QNode) {
            r = r.tryPut(e, this.maxNodeSize, depth++ > 50);
        }
    }

    private void initializeRoot(double[] key) {
        double lo = Double.MAX_VALUE;
        double hi = -1.7976931348623157E308;
        for (int d = 0; d < this.dims; ++d) {
            lo = lo > key[d] ? key[d] : lo;
            hi = hi < key[d] ? key[d] : hi;
        }
        if (lo == 0.0 && hi == 0.0) {
            hi = 1.0;
        }
        double maxDistOrigin = Math.abs(hi) > Math.abs(lo) ? hi : lo;
        maxDistOrigin = Math.abs(maxDistOrigin);
        double[] center = new double[this.dims];
        for (int d = 0; d < this.dims; ++d) {
            center[d] = key[d] > 0.0 ? maxDistOrigin : -maxDistOrigin;
        }
        this.root = new QNode(center, maxDistOrigin);
    }

    public boolean containsExact(double[] key) {
        if (this.root == null) {
            return false;
        }
        return this.root.getExact(key) != null;
    }

    @Override
    public T queryExact(double[] key) {
        if (this.root == null) {
            return null;
        }
        QEntry<T> e = this.root.getExact(key);
        return e == null ? null : (T)e.value();
    }

    @Override
    public T remove(double[] key) {
        if (this.root == null) {
            return null;
        }
        QEntry<T> e = this.root.remove(null, key, this.maxNodeSize);
        if (e == null) {
            return null;
        }
        --this.size;
        return e.value();
    }

    @Override
    public T update(double[] oldKey, double[] newKey) {
        if (this.root == null) {
            return null;
        }
        boolean[] requiresReinsert = new boolean[]{false};
        QEntry<T> e = this.root.update(null, oldKey, newKey, this.maxNodeSize, requiresReinsert, 0, 50);
        if (e == null) {
            return null;
        }
        if (requiresReinsert[0]) {
            this.ensureCoverage(e);
            QNode<T> r = this.root;
            int depth = 0;
            while (r instanceof QNode) {
                r = r.tryPut(e, this.maxNodeSize, depth++ > 50);
            }
        }
        return e.value();
    }

    private void ensureCoverage(QEntry<T> e) {
        double[] p = e.point();
        while (!e.enclosedBy(this.root.getCenter(), this.root.getRadius())) {
            double[] center = this.root.getCenter();
            double radius = this.root.getRadius();
            double[] center2 = new double[center.length];
            double radius2 = radius * 2.0;
            int subNodePos = 0;
            for (int d = 0; d < center.length; ++d) {
                subNodePos <<= 1;
                if (p[d] < center[d] - radius) {
                    center2[d] = center[d] - radius;
                    subNodePos |= 1;
                    continue;
                }
                center2[d] = center[d] + radius;
            }
            this.root = new QNode<T>(center2, radius2, this.root, subNodePos);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.root = null;
    }

    @Override
    public QueryIterator<PointEntry<T>> query(double[] min, double[] max) {
        if (ENABLE_HCI_2) {
            return new QIterator2(this, min, max);
        }
        if (ENABLE_HCI_1) {
            return new QIterator1(this, min, max);
        }
        return new QIterator0(this, min, max);
    }

    public List<QEntryDist<T>> knnQuery(double[] center, int k) {
        if (this.root == null) {
            return Collections.emptyList();
        }
        ArrayList<QEntryDist<T>> candidates = new ArrayList<QEntryDist<T>>();
        this.rangeSearchKNN(this.root, center, candidates, k, Double.MAX_VALUE);
        return candidates;
    }

    private double rangeSearchKNN(QNode<T> node, double[] center, ArrayList<QEntryDist<T>> candidates, int k, double maxRange) {
        int i;
        Object ePos;
        int posHC = node.calcSubPosition(center);
        Object[] entries = node.getEntries();
        Object alreadyVisited = null;
        if (!node.isLeaf() && (ePos = entries[posHC]) instanceof QNode) {
            maxRange = this.rangeSearchKNN((QNode)ePos, center, candidates, k, maxRange);
            alreadyVisited = ePos;
        }
        ArrayList<KnnTemp> buffer = new ArrayList<KnnTemp>();
        for (i = 0; i < entries.length; ++i) {
            double dist;
            Object e = entries[i];
            if (e instanceof QNode && e != alreadyVisited) {
                QNode n = (QNode)e;
                dist = QUtil.distToRectNode(center, n.getCenter(), n.getRadius());
                this.addToBuffer(n, dist, maxRange, buffer);
                continue;
            }
            if (!(e instanceof QEntry)) continue;
            QEntry p = (QEntry)e;
            dist = QUtil.distance(center, p.point());
            this.addToBuffer(p, dist, maxRange, buffer);
        }
        buffer.sort(KnnTempComp);
        for (i = 0; i < buffer.size(); ++i) {
            KnnTemp t = (KnnTemp)buffer.get(i);
            if (t.dist > maxRange) continue;
            Object o = t.o;
            if (o instanceof QNode && o != alreadyVisited) {
                maxRange = this.rangeSearchKNN((QNode)o, center, candidates, k, maxRange);
                continue;
            }
            if (!(o instanceof QEntry)) continue;
            QEntry p = (QEntry)o;
            candidates.add(new QEntryDist(p, t.dist));
            maxRange = this.adjustRegionKNN(candidates, k, maxRange);
        }
        return maxRange;
    }

    private void addToBuffer(Object o, double dist, double maxDist, ArrayList<KnnTemp> buffer) {
        if (dist < maxDist) {
            buffer.add(new KnnTemp(o, dist));
        }
    }

    private double adjustRegionKNN(ArrayList<QEntryDist<T>> candidates, int k, double maxRange) {
        if (candidates.size() < k) {
            return maxRange;
        }
        candidates.sort(QEntryDist.COMP);
        while (candidates.size() > k) {
            candidates.remove(candidates.size() - 1);
        }
        double range = candidates.get(candidates.size() - 1).dist();
        return range;
    }

    @Override
    public String toStringTree() {
        StringBuilder sb = new StringBuilder();
        if (this.root == null) {
            sb.append("empty tree");
        } else {
            this.toStringTree(sb, this.root, 0, 0);
        }
        return sb.toString();
    }

    private void toStringTree(StringBuilder sb, QNode<T> node, int depth, int posInParent) {
        int i;
        String prefix = "";
        for (i = 0; i < depth; ++i) {
            prefix = prefix + ".";
        }
        sb.append(prefix + posInParent + " d=" + depth);
        sb.append(" " + Arrays.toString(node.getCenter()));
        sb.append("/" + node.getRadius() + NL);
        prefix = prefix + " ";
        for (i = 0; i < node.getEntries().length; ++i) {
            Object o = node.getEntries()[i];
            if (o instanceof QNode) {
                QNode sub = (QNode)o;
                this.toStringTree(sb, sub, depth + 1, i);
                continue;
            }
            if (o == null) continue;
            QEntry e = (QEntry)o;
            sb.append(prefix + Arrays.toString(e.point()));
            sb.append(" v=" + e.value() + NL);
        }
    }

    public String toString() {
        return "QuadTreeKD2;maxNodeSize=" + this.maxNodeSize + ";maxDepth=" + 50 + ";DEBUG=" + false + ";center/radius=" + (this.root == null ? "null" : Arrays.toString(this.root.getCenter()) + "/" + this.root.getRadius()) + ";HCI-1/2=" + ENABLE_HCI_1 + "/" + ENABLE_HCI_2;
    }

    @Override
    public QStats getStats() {
        QStats s = new QStats(this.dims);
        if (this.root != null) {
            this.root.checkNode(s, null, 0);
        }
        return s;
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public QueryIterator<PointEntry<T>> iterator() {
        if (this.root == null) {
            return this.query(new double[this.dims], new double[this.dims]);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryIteratorKNN<PointEntryDist<T>> queryKNN(double[] center, int k) {
        return new QQueryIteratorKNN(center, k);
    }

    @Override
    public int getNodeCount() {
        return this.getStats().getNodeCount();
    }

    @Override
    public int getDepth() {
        return this.getStats().getMaxDepth();
    }

    protected QNode<T> getRoot() {
        return this.root;
    }

    public static class QStats
    extends Stats {
        final int[] histoValues = new int[100];
        final int[] histoSubs;
        static final int HISTO_MAX = 1025;
        final int dims;

        public QStats(int dims) {
            super(0L, 0L, 0L);
            this.dims = dims;
            int histoSize = 1 + (1 << dims);
            this.histoSubs = new int[histoSize > 1025 ? 1025 : histoSize];
        }

        public void histo(int pos) {
            if (pos < this.histoSubs.length) {
                int n = pos;
                this.histoSubs[n] = this.histoSubs[n] + 1;
            } else {
                int n = this.histoSubs.length - 1;
                this.histoSubs[n] = this.histoSubs[n] + 1;
            }
        }

        @Override
        public String toString() {
            return super.toString() + ";\n" + "histoVal:" + Arrays.toString(this.histoValues) + "\n" + "histoSub:" + Arrays.toString(this.histoSubs);
        }
    }

    private class QQueryIteratorKNN
    implements QueryIteratorKNN<PointEntryDist<T>> {
        private Iterator<PointEntryDist<T>> it;

        public QQueryIteratorKNN(double[] center, int k) {
            this.reset(center, k);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public PointEntryDist<T> next() {
            return this.it.next();
        }

        public QQueryIteratorKNN reset(double[] center, int k) {
            this.it = QuadTreeKD2.this.knnQuery(center, k).iterator();
            return this;
        }
    }

    private static class KnnTemp {
        Object o;
        double dist;

        public KnnTemp(Object o, double d) {
            this.o = o;
            this.dist = d;
        }
    }
}

