/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.RectangleDistanceFunction;
import org.tinspin.index.RectangleEntryDist;
import org.tinspin.index.rtree.DistEntry;
import org.tinspin.index.rtree.Entry;
import org.tinspin.index.rtree.KnnResult;
import org.tinspin.index.rtree.RTree;
import org.tinspin.index.rtree.RTreeNode;
import org.tinspin.index.rtree.RTreeNodeDir;

public class RTreeQueryKnnOld<T>
implements QueryIteratorKNN<RectangleEntryDist<T>> {
    private final DEComparator COMP = new DEComparator();
    private final RTree<T> tree;
    private double[] center;
    private IteratorStack stack;
    private final KnnResult<T> candidates;
    private Iterator<DistEntry<T>> iter;
    private RectangleDistanceFunction dist;

    public RTreeQueryKnnOld(RTree<T> tree, double[] center, int k, RectangleDistanceFunction dist) {
        this.stack = new IteratorStack(tree.getDepth());
        this.tree = tree;
        this.candidates = new KnnResult(k);
        this.reset(center, k, dist == null ? RectangleDistanceFunction.EDGE : dist);
    }

    @Override
    public RTreeQueryKnnOld<T> reset(double[] center, int k) {
        this.reset(center, k, null);
        return this;
    }

    public void reset(double[] center, int k, RectangleDistanceFunction dist) {
        if (this.stack.stack.length < this.tree.getDepth()) {
            this.stack = new IteratorStack(this.tree.getDepth());
        } else {
            this.stack.size = 0;
        }
        if (dist != null) {
            this.dist = dist;
        }
        if (this.dist != RectangleDistanceFunction.EDGE) {
            System.err.println("This distance iterator only works for EDGE distance");
        }
        this.center = center;
        this.candidates.clear(k);
        if (k <= 0 || this.tree.size() == 0) {
            this.iter = this.candidates.iterator();
            return;
        }
        double distEst = Double.MAX_VALUE;
        this.stack.prepareAndPush(this.tree.getRoot());
        this.findCandidates(distEst);
    }

    private void findCandidates(double currentDist) {
        while (!this.stack.isEmpty()) {
            IterPos ip = this.stack.peek();
            if (ip.node instanceof RTreeNodeDir) {
                if (ip.pos < ip.subNodes.length && ip.subNodes[ip.pos].dist() < currentDist) {
                    this.stack.prepareAndPush((RTreeNode)ip.subNodes[ip.pos].value());
                    ++ip.pos;
                    continue;
                }
            } else {
                ArrayList entries = ip.node.getEntries();
                while (ip.pos < entries.size()) {
                    Entry e = entries.get(ip.pos);
                    ++ip.pos;
                    double eDist = this.dist(this.center, e.min, e.max);
                    if (!(eDist < currentDist)) continue;
                    currentDist = this.checkCandidate(e, eDist);
                }
            }
            this.stack.pop();
        }
        this.iter = this.candidates.iterator();
    }

    private DistEntry<RTreeNode<T>>[] sortEntries(IterPos<T> ni) {
        ArrayList entries = ((RTreeNodeDir)ni.node).getChildren();
        DistEntry[] ret = new DistEntry[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            RTreeNode e = entries.get(i);
            double d = this.dist(this.center, e.min, e.max);
            ret[i] = new DistEntry(e.lower(), e.upper(), e, d);
        }
        Arrays.sort(ret, this.COMP);
        return ret;
    }

    private double checkCandidate(Entry<T> e, double eDist) {
        return this.candidates.add(e, eDist);
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public DistEntry<T> next() {
        return this.iter.next();
    }

    private double dist(double[] center, double[] min, double[] max) {
        this.tree.incNDistKNN();
        return this.dist.dist(center, min, max);
    }

    private static class IterPos<T> {
        DistEntry<RTreeNode<T>>[] subNodes;
        RTreeNode<T> node;
        int pos;

        private IterPos() {
        }

        void init(RTreeNode<T> node) {
            this.node = node;
            this.pos = 0;
        }
    }

    private static class DEComparator
    implements Comparator<DistEntry<?>> {
        private DEComparator() {
        }

        @Override
        public int compare(DistEntry<?> o1, DistEntry<?> o2) {
            double d = o1.dist() - o2.dist();
            return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
        }
    }

    private class IteratorStack {
        private final IterPos<T>[] stack;
        private int size = 0;

        IteratorStack(int depth) {
            this.stack = new IterPos[depth];
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        IterPos<T> prepareAndPush(RTreeNode<T> node) {
            IterPos ni;
            if ((ni = this.stack[this.size++]) == null) {
                ni = new IterPos();
                this.stack[this.size - 1] = ni;
            }
            ni.init(node);
            if (ni.node instanceof RTreeNodeDir) {
                ni.subNodes = RTreeQueryKnnOld.this.sortEntries(ni);
            }
            return ni;
        }

        IterPos<T> peek() {
            return this.stack[this.size - 1];
        }

        IterPos<T> pop() {
            return this.stack[--this.size];
        }
    }
}

