/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index;

import java.util.function.Predicate;
import org.tinspin.index.Index;
import org.tinspin.index.PointDistanceFunction;
import org.tinspin.index.PointEntry;
import org.tinspin.index.PointEntryDist;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.QueryIteratorKNN;

public interface PointIndexMM<T>
extends Index<T> {
    public void insert(double[] var1, T var2);

    public boolean remove(double[] var1, T var2);

    public boolean removeIf(double[] var1, Predicate<PointEntry<T>> var2);

    public boolean update(double[] var1, double[] var2, T var3);

    public boolean contains(double[] var1, T var2);

    public QueryIterator<PointEntry<T>> query(double[] var1);

    public QueryIterator<PointEntry<T>> iterator();

    public QueryIterator<PointEntry<T>> query(double[] var1, double[] var2);

    default public PointEntryDist<T> query1NN(double[] center) {
        QueryIteratorKNN<PointEntryDist<T>> it = this.queryKNN(center, 1);
        if (it.hasNext()) {
            return (PointEntryDist)it.next();
        }
        return null;
    }

    default public QueryIteratorKNN<PointEntryDist<T>> queryKNN(double[] center, int k) {
        return this.queryKNN(center, k, PointDistanceFunction.L2);
    }

    public QueryIteratorKNN<PointEntryDist<T>> queryKNN(double[] var1, int var2, PointDistanceFunction var3);
}

