/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index;

import org.tinspin.index.PointDistanceFunction;
import org.tinspin.index.RectangleEntry;

@FunctionalInterface
public interface RectangleDistanceFunction {
    public static final RectangleDistanceFunction CENTER = RectangleDistanceFunction::centerDistance;
    public static final RectangleDistanceFunction EDGE = RectangleDistanceFunction::edgeDistance;

    public double dist(double[] var1, double[] var2, double[] var3);

    default public double dist(double[] center, RectangleEntry<?> entry) {
        return this.dist(center, entry.lower(), entry.upper());
    }

    public static double centerDistance(double[] center, double[] min, double[] max) {
        double dist = 0.0;
        for (int i = 0; i < center.length; ++i) {
            double d = (min[i] + max[i]) * 0.5 - center[i];
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    public static double edgeDistance(double[] center, double[] min, double[] max) {
        double dist = 0.0;
        for (int i = 0; i < center.length; ++i) {
            double d = 0.0;
            if (min[i] > center[i]) {
                d = min[i] - center[i];
            } else if (max[i] < center[i]) {
                d = center[i] - max[i];
            }
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    public static class EdgeDistance {
        final PointDistanceFunction distFn;

        public EdgeDistance(PointDistanceFunction distFn) {
            this.distFn = distFn;
        }

        public double edgeDistance(double[] center, double[] min, double[] max) {
            double[] dist = new double[center.length];
            for (int i = 0; i < center.length; ++i) {
                double d = 0.0;
                if (min[i] > center[i]) {
                    d = min[i] - center[i];
                } else if (max[i] < center[i]) {
                    d = center[i] - max[i];
                }
                dist[i] = d;
            }
            return this.distFn.dist(dist, center);
        }
    }

    public static class FarthestNeighbor
    implements RectangleDistanceFunction {
        private static final double EPSILON = 9.9E-324;
        private final RectangleDistanceFunction dist;

        public FarthestNeighbor(RectangleDistanceFunction dist) {
            this.dist = dist;
        }

        @Override
        public double dist(double[] center, double[] min, double[] max) {
            double d = this.dist.dist(center, min, max);
            if (d < 9.9E-324) {
                return Double.POSITIVE_INFINITY;
            }
            return 1.0 / d;
        }

        @Override
        public double dist(double[] center, RectangleEntry<?> entry) {
            double d = this.dist.dist(center, entry);
            if (d < 9.9E-324) {
                return Double.POSITIVE_INFINITY;
            }
            return 1.0 / d;
        }
    }

    public static class RectangleDist
    implements RectangleDistanceFunction {
        private final double[] lower;
        private final double[] upper;

        public RectangleDist(double[] lower, double[] upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public double dist(double[] ignored, double[] min, double[] max) {
            double dist = 0.0;
            for (int i = 0; i < this.lower.length; ++i) {
                double d = 0.0;
                if (min[i] > this.upper[i]) {
                    d = min[i] - this.upper[i];
                } else if (max[i] < this.lower[i]) {
                    d = this.lower[i] - max[i];
                }
                dist += d * d;
            }
            return dist;
        }
    }
}

