/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.array;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.RectangleDistanceFunction;
import org.tinspin.index.RectangleEntry;
import org.tinspin.index.RectangleEntryDist;
import org.tinspin.index.RectangleIndex;
import org.tinspin.index.RectangleIndexMM;
import org.tinspin.index.Stats;
import org.tinspin.index.util.QueryIteratorWrapper;

public class RectArray<T>
implements RectangleIndex<T>,
RectangleIndexMM<T> {
    private final double[][] phc;
    private final int dims;
    private int N;
    private int size;
    private final RectangleEntry<T>[] values;
    private int insPos = 0;
    private final Comparator<KnnEntry<T>> COMP = KnnEntry::compareTo;

    public RectArray(int dims, int size) {
        this.N = size;
        this.size = 0;
        this.dims = dims;
        this.phc = new double[2 * this.N][dims];
        this.values = new RectangleEntry[this.N];
    }

    @Override
    public void insert(double[] lower, double[] upper, T value) {
        System.arraycopy(lower, 0, this.phc[this.insPos * 2], 0, this.dims);
        System.arraycopy(upper, 0, this.phc[this.insPos * 2 + 1], 0, this.dims);
        this.values[this.insPos] = new KnnEntry<T>(lower, upper, value, -1.0);
        ++this.insPos;
        ++this.size;
    }

    @Override
    public T remove(double[] lower, double[] upper) {
        for (int i = 0; i < this.N; ++i) {
            if (this.phc[i * 2] == null || !this.eq(this.phc[i * 2], lower) || !this.eq(this.phc[i * 2 + 1], upper)) continue;
            this.phc[i * 2] = null;
            this.phc[i * 2 + 1] = null;
            --this.size;
            return this.values[i].value();
        }
        return null;
    }

    @Override
    public boolean remove(double[] lower, double[] upper, T value) {
        return this.removeIf(lower, upper, e -> Objects.equals(value, e.value()));
    }

    @Override
    public boolean removeIf(double[] lower, double[] upper, Predicate<RectangleEntry<T>> condition) {
        for (int i = 0; i < this.N; ++i) {
            if (this.phc[i * 2] == null || !this.eq(this.phc[i * 2], lower) || !this.eq(this.phc[i * 2 + 1], upper) || !condition.test(this.values[i])) continue;
            this.phc[i * 2] = null;
            this.phc[i * 2 + 1] = null;
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public T update(double[] lo1, double[] up1, double[] lo2, double[] up2) {
        for (int i = 0; i < this.N; ++i) {
            if (!this.eq(this.phc[i * 2], lo1) || !this.eq(this.phc[i * 2 + 1], up1)) continue;
            System.arraycopy(lo2, 0, this.phc[i * 2], 0, this.dims);
            System.arraycopy(up2, 0, this.phc[i * 2 + 1], 0, this.dims);
            return this.values[i].value();
        }
        return null;
    }

    @Override
    public boolean update(double[] lo1, double[] up1, double[] lo2, double[] up2, T value) {
        for (int i = 0; i < this.N; ++i) {
            if (!this.eq(this.phc[i * 2], lo1) || !this.eq(this.phc[i * 2 + 1], up1) || !this.eq(this.phc[i * 2], lo1) || !this.eq(this.phc[i * 2 + 1], up1) || !Objects.equals(value, this.values[i].value())) continue;
            System.arraycopy(lo2, 0, this.phc[i * 2], 0, this.dims);
            System.arraycopy(up2, 0, this.phc[i * 2 + 1], 0, this.dims);
            return true;
        }
        return false;
    }

    @Override
    public T queryExact(double[] lower, double[] upper) {
        for (int j = 0; j < this.N; ++j) {
            if (!this.eq(this.phc[j * 2], lower) || !this.eq(this.phc[j * 2 + 1], upper)) continue;
            return this.values[j].value();
        }
        return null;
    }

    @Override
    public boolean contains(double[] lower, double[] upper, T value) {
        for (int i = 0; i < this.N; ++i) {
            if (!this.eq(this.phc[i * 2], lower) || !this.eq(this.phc[i * 2 + 1], upper) || !Objects.equals(value, this.values[i].value())) continue;
            return true;
        }
        return false;
    }

    @Override
    public QueryIterator<RectangleEntry<T>> queryRectangle(double[] lower, double[] upper) {
        return new QueryIteratorWrapper<RectangleEntry<T>>(lower, upper, (low, upp) -> {
            ArrayList<RectangleEntry<T>> result = new ArrayList<RectangleEntry<T>>();
            for (int i = 0; i < this.N; ++i) {
                if (this.phc[i * 2] == null || !this.eq(this.phc[i * 2], (double[])low) || !this.eq(this.phc[i * 2 + 1], (double[])upp)) continue;
                result.add(this.values[i]);
            }
            return result.iterator();
        });
    }

    private boolean eq(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private boolean geq(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] < b[i])) continue;
            return false;
        }
        return true;
    }

    private boolean leq(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] > b[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public QueryIterator<RectangleEntry<T>> queryIntersect(double[] min, double[] max) {
        return new QueryIteratorWrapper<RectangleEntry<T>>(min, max, (lower, upper) -> {
            ArrayList<RectangleEntry<T>> results = new ArrayList<RectangleEntry<T>>();
            for (int i = 0; i < this.N; ++i) {
                if (!this.leq(this.phc[i * 2], (double[])upper) || !this.geq(this.phc[i * 2 + 1], (double[])lower)) continue;
                results.add(this.values[i]);
            }
            return results.iterator();
        });
    }

    @Override
    public RectangleEntryDist<T> query1NN(double[] center) {
        return (RectangleEntryDist)this.queryKNN(center, 1).next();
    }

    @Override
    public QueryIterator<RectangleEntry<T>> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryIteratorKNN<RectangleEntryDist<T>> queryKNN(double[] center, int k) {
        return new AQueryIteratorKNN(center, k);
    }

    @Override
    public QueryIteratorKNN<RectangleEntryDist<T>> queryKNN(double[] center, int k, RectangleDistanceFunction distFn) {
        return null;
    }

    private ArrayList<KnnEntry<T>> knnQuery(double[] center, int k) {
        ArrayList<KnnEntry<T>> ret = new ArrayList<KnnEntry<T>>(k);
        for (int i = 0; i < this.phc.length / 2; ++i) {
            double[] min = this.phc[i * 2];
            double[] max = this.phc[i * 2 + 1];
            double dist = RectArray.distREdge(center, min, max);
            if (ret.size() < k) {
                ret.add(new KnnEntry<T>(min, max, this.values[i].value(), dist));
                ret.sort(this.COMP);
                continue;
            }
            if (!(ret.get((int)(k - 1)).dist > dist)) continue;
            ret.remove(k - 1);
            ret.add(new KnnEntry<T>(min, max, this.values[i].value(), dist));
            ret.sort(this.COMP);
        }
        return ret;
    }

    private static double distREdge(double[] center, double[] rLower, double[] rUpper) {
        double dist = 0.0;
        for (int i = 0; i < center.length; ++i) {
            double d = 0.0;
            if (center[i] > rUpper[i]) {
                d = center[i] - rUpper[i];
            } else if (center[i] < rLower[i]) {
                d = rLower[i] - center[i];
            }
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    public String toString() {
        return "NaiveArray";
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        int i;
        for (i = 0; i < this.N; ++i) {
            this.values[i] = null;
        }
        for (i = 0; i < 2 * this.N; ++i) {
            this.phc[i] = null;
        }
        this.N = 0;
        this.size = 0;
    }

    @Override
    public Stats getStats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNodeCount() {
        return 1;
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public String toStringTree() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.N; ++i) {
            s.append(Arrays.toString(this.phc[i * 2])).append("/").append(Arrays.toString(this.phc[i * 2 + 1])).append(" v=").append(this.values[i]);
        }
        return s.toString();
    }

    private static class KnnEntry<T>
    implements Comparable<KnnEntry<T>>,
    RectangleEntryDist<T> {
        private final double[] min;
        private final double[] max;
        private final T val;
        private final double dist;

        KnnEntry(double[] min, double[] max, T val, double dist) {
            this.min = min;
            this.max = max;
            this.val = val;
            this.dist = dist;
        }

        @Override
        public int compareTo(KnnEntry<T> o) {
            double d = this.dist - o.dist;
            return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
        }

        public String toString() {
            return "d=" + this.dist + ":" + Arrays.toString(this.min) + "/" + Arrays.toString(this.max);
        }

        @Override
        public double[] lower() {
            return this.min;
        }

        @Override
        public double[] upper() {
            return this.max;
        }

        @Override
        public T value() {
            return this.val;
        }

        @Override
        public double dist() {
            return this.dist;
        }
    }

    private class AQueryIteratorKNN
    implements QueryIteratorKNN<RectangleEntryDist<T>> {
        private Iterator<RectangleEntryDist<T>> it;

        public AQueryIteratorKNN(double[] center, int k) {
            this.reset(center, k);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public RectangleEntryDist<T> next() {
            return this.it.next();
        }

        public AQueryIteratorKNN reset(double[] center, int k) {
            this.it = RectArray.this.knnQuery(center, k).iterator();
            return this;
        }
    }
}

