/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.covertree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.tinspin.index.PointDistanceFunction;
import org.tinspin.index.PointEntryDist;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.covertree.CoverTree;
import org.tinspin.index.covertree.Node;
import org.tinspin.index.covertree.PointDist;

public class CoverTreeQueryKnn<T>
implements QueryIteratorKNN<PointEntryDist<T>> {
    private final Comparator<PointDist<?>> COMP = PointDist.COMPARATOR;
    private final CoverTree<T> tree;
    private double[] center;
    private Iterator<PointDist<T>> iter;
    private PointDistanceFunction dist;
    private final ArrayList<PointDist<T>> candidates = new ArrayList();
    private final ArrayList<PointDist<Object>> pool = new ArrayList();
    private final PriorityQueue<PointDist<Object>> queue = new PriorityQueue(this.COMP);

    public CoverTreeQueryKnn(CoverTree<T> tree, double[] center, int k, PointDistanceFunction dist) {
        this.tree = tree;
        this.reset(center, k, dist == null ? PointDistanceFunction.L2 : dist);
    }

    @Override
    public CoverTreeQueryKnn<T> reset(double[] center, int k) {
        this.reset(center, k, null);
        return this;
    }

    public void reset(double[] center, int k, PointDistanceFunction dist) {
        if (dist != null) {
            this.dist = dist;
        }
        if (this.dist != PointDistanceFunction.L2) {
            System.err.println("This distance iterator only works for L2 distance");
        }
        this.center = center;
        this.pool.addAll(this.queue);
        this.queue.clear();
        this.candidates.clear();
        this.candidates.ensureCapacity(k);
        if (k <= 0 || this.tree.size() == 0) {
            this.iter = this.candidates.iterator();
            return;
        }
        this.search(k);
        this.iter = this.candidates.iterator();
    }

    private void search(int k) {
        this.addToQueue(this.tree.getRoot());
        while (!this.queue.isEmpty()) {
            PointDist<Object> candidate = this.queue.poll();
            Object o = candidate.value();
            if (!(o instanceof Node)) {
                this.candidates.add(candidate);
                if (this.candidates.size() < k) continue;
                return;
            }
            ArrayList entries = ((Node)o).getChildren();
            if (entries != null) {
                for (int i = 0; i < entries.size(); ++i) {
                    this.addToQueue(entries.get(i));
                }
            }
            this.pool.add(candidate);
        }
    }

    private void addToQueue(Node<T> node) {
        double dRootPoint = this.dist.dist(this.center, node.point());
        double maxDist = node.maxdist(this.tree);
        double dRootNode = maxDist > dRootPoint ? 0.0 : dRootPoint - maxDist;
        this.queue.add(this.createEntry(node.point().point(), node, dRootNode));
        this.queue.add(this.createEntry(node.point().point(), node.point(), dRootPoint));
    }

    private PointDist<Object> createEntry(double[] data, Object val, double dist) {
        if (this.pool.isEmpty()) {
            return new PointDist<Object>(data, val, dist);
        }
        PointDist<Object> e = this.pool.remove(this.pool.size() - 1);
        e.set(data, val, dist);
        return e;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public PointDist<T> next() {
        return this.iter.next();
    }
}

