/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.kdtree;

import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.tinspin.index.PointDistanceFunction;
import org.tinspin.index.PointEntry;
import org.tinspin.index.PointEntryDist;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.kdtree.KDEntryDist;
import org.tinspin.index.kdtree.Node;
import org.tinspin.index.util.MinHeap;
import org.tinspin.index.util.MinMaxHeap;

public class KDIteratorKnn<T>
implements QueryIteratorKNN<PointEntryDist<T>> {
    private final Node<T> root;
    private final PointDistanceFunction distFn;
    private final Predicate<PointEntry<T>> filterFn;
    MinHeap<NodeDist<T>> queueN = MinHeap.create((t1, t2) -> t1.closestDist < t2.closestDist);
    MinMaxHeap<KDEntryDist<T>> queueV = MinMaxHeap.create((t1, t2) -> t1.dist() < t2.dist());
    double maxNodeDist = Double.POSITIVE_INFINITY;
    private PointEntryDist<T> current;
    private int remaining;
    private double[] center;
    private double currentDistance;

    KDIteratorKnn(Node<T> root, int minResults, double[] center, PointDistanceFunction distFn, Predicate<PointEntry<T>> filterFn) {
        this.filterFn = filterFn;
        this.distFn = distFn;
        this.root = root;
        this.reset(center, minResults);
    }

    @Override
    public QueryIteratorKNN<PointEntryDist<T>> reset(double[] center, int minResults) {
        this.center = center;
        this.currentDistance = Double.MAX_VALUE;
        this.remaining = minResults;
        this.maxNodeDist = Double.POSITIVE_INFINITY;
        this.current = null;
        if (minResults <= 0 || this.root == null) {
            return this;
        }
        this.queueN.clear();
        this.queueV.clear();
        double[] closest = (double[])center.clone();
        this.queueN.push(new NodeDist<T>(this.distFn.dist(center, closest), this.root, closest));
        this.findNextElement();
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public PointEntryDist<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        PointEntryDist<T> ret = this.current;
        this.findNextElement();
        return ret;
    }

    public double distance() {
        return this.currentDistance;
    }

    private void findNextElement() {
        while (!(this.remaining <= 0 || this.queueN.isEmpty() && this.queueV.isEmpty())) {
            double d;
            boolean useV;
            boolean bl = useV = !this.queueV.isEmpty();
            if (useV && !this.queueN.isEmpty()) {
                boolean bl2 = useV = this.queueV.peekMin().dist() <= this.queueN.peekMin().closestDist;
            }
            if (useV) {
                KDEntryDist<T> result = this.queueV.peekMin();
                this.queueV.popMin();
                --this.remaining;
                this.current = result;
                this.currentDistance = result.dist();
                return;
            }
            NodeDist<T> entry = this.queueN.peekMin();
            this.queueN.popMin();
            if (entry.closestDist > this.maxNodeDist && this.queueV.size() >= this.remaining) continue;
            Node node = entry.node;
            if (this.filterFn.test(node) && (d = this.distFn.dist(this.center, node.getKey())) <= this.maxNodeDist) {
                this.queueV.push(new KDEntryDist(node, d));
                if (this.queueV.size() >= this.remaining) {
                    if (this.queueV.size() > this.remaining) {
                        this.queueV.popMax();
                    }
                    double dMax = this.queueV.peekMax().dist();
                    this.maxNodeDist = Math.min(this.maxNodeDist, dMax);
                }
            }
            if (node.getLo() != null) {
                this.createEntryLo(entry);
            }
            if (node.getHi() == null) continue;
            this.createEntryHi(entry);
        }
        this.current = null;
        this.currentDistance = Double.POSITIVE_INFINITY;
    }

    void createEntryHi(NodeDist<T> entry) {
        double newClosestDist;
        double[] newClosest;
        double splitX;
        Node node = entry.node;
        int splitDim = node.getDim();
        if (this.center[splitDim] < (splitX = node.getKey()[splitDim])) {
            newClosest = (double[])entry.closest.clone();
            newClosest[splitDim] = splitX;
            newClosestDist = this.distFn.dist(newClosest, this.center);
        } else {
            newClosest = entry.closest;
            newClosestDist = entry.closestDist;
        }
        if (newClosestDist <= this.maxNodeDist) {
            this.queueN.push(new NodeDist(newClosestDist, node.getHi(), newClosest));
        }
    }

    void createEntryLo(NodeDist<T> entry) {
        double newClosestDist;
        double[] newClosest;
        double splitX;
        Node node = entry.node;
        int splitDim = node.getDim();
        if (this.center[splitDim] > (splitX = node.getKey()[splitDim])) {
            newClosest = (double[])entry.closest.clone();
            newClosest[splitDim] = splitX;
            newClosestDist = this.distFn.dist(newClosest, this.center);
        } else {
            newClosest = entry.closest;
            newClosestDist = entry.closestDist;
        }
        if (newClosestDist <= this.maxNodeDist) {
            this.queueN.push(new NodeDist(newClosestDist, node.getLo(), newClosest));
        }
    }

    private static class NodeDist<T> {
        double closestDist;
        Node<T> node;
        double[] closest;

        NodeDist(double closestDist, Node<T> node, double[] closest) {
            this.closestDist = closestDist;
            this.node = node;
            this.closest = closest;
        }
    }
}

