/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.phtree;

import ch.ethz.globis.phtree.PhEntryDistF;
import ch.ethz.globis.phtree.PhEntryF;
import ch.ethz.globis.phtree.PhTreeMultiMapF2;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import org.tinspin.index.PointDistanceFunction;
import org.tinspin.index.PointEntry;
import org.tinspin.index.PointEntryDist;
import org.tinspin.index.PointIndexMM;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.Stats;
import org.tinspin.index.phtree.DistEntryP;
import org.tinspin.index.phtree.EntryP;
import org.tinspin.index.phtree.PHStats;

public class PHTreeMMP<T>
implements PointIndexMM<T> {
    private final PhTreeMultiMapF2<T> tree;

    private PHTreeMMP(int dims) {
        this.tree = PhTreeMultiMapF2.create((int)dims);
    }

    public static <T> PHTreeMMP<T> create(int dims) {
        return new PHTreeMMP<T>(dims);
    }

    @Override
    public int getDims() {
        return this.tree.getDim();
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public void clear() {
        this.tree.clear();
    }

    @Override
    public Stats getStats() {
        return new PHStats(this.tree.getStats(), this.tree.getDim());
    }

    @Override
    public int getNodeCount() {
        return this.tree.getStats().getNodeCount();
    }

    @Override
    public int getDepth() {
        return this.tree.getStats().getBitDepth();
    }

    @Override
    public String toStringTree() {
        return this.tree.toStringTree();
    }

    @Override
    public void insert(double[] key, T value) {
        this.tree.put(key, value);
    }

    @Override
    public boolean remove(double[] key, T value) {
        return this.tree.remove(key, value);
    }

    @Override
    public boolean removeIf(double[] point, Predicate<PointEntry<T>> condition) {
        for (Object t : this.tree.get(point)) {
            if (!condition.test(new EntryP(point, t))) continue;
            return this.tree.remove(point, t);
        }
        return false;
    }

    @Override
    public boolean update(double[] oldPoint, double[] newPoint, T value) {
        return this.tree.update(oldPoint, value, newPoint);
    }

    @Override
    public boolean contains(double[] point, T value) {
        for (Object t : this.tree.get(point)) {
            if (!Objects.equals(value, t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public QueryIterator<PointEntry<T>> query(double[] key) {
        return new IteratorPlain(key, this.tree.get(key).iterator());
    }

    @Override
    public QueryIterator<PointEntry<T>> query(double[] min, double[] max) {
        return new IteratorWQ(this.tree.query(min, max));
    }

    @Override
    public QueryIterator<PointEntry<T>> iterator() {
        return new IteratorExtent(this.tree.queryExtent());
    }

    @Override
    public QueryIteratorKNN<PointEntryDist<T>> queryKNN(double[] center, int k) {
        return new IteratorKnn(this.tree.nearestNeighbour(k, center));
    }

    @Override
    public QueryIteratorKNN<PointEntryDist<T>> queryKNN(double[] center, int k, PointDistanceFunction distFn) {
        return null;
    }

    private static class IteratorKnn<T>
    implements QueryIteratorKNN<PointEntryDist<T>> {
        private final PhTreeMultiMapF2.PhKnnQueryF<T> iter;

        private IteratorKnn(PhTreeMultiMapF2.PhKnnQueryF<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public PointEntryDist<T> next() {
            PhEntryDistF e = this.iter.nextEntryReuse();
            return new DistEntryP<Object>((double[])e.getKey().clone(), e.getValue(), e.dist());
        }

        @Override
        public IteratorKnn<T> reset(double[] center, int k) {
            this.iter.reset(k, null, center);
            return this;
        }
    }

    private static class IteratorPlain<T>
    implements QueryIterator<PointEntry<T>> {
        private final Iterator<T> iter;
        private final double[] key;

        private IteratorPlain(double[] key, Iterator<T> iter) {
            this.iter = iter;
            this.key = key;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public PointEntry<T> next() {
            return new EntryP<T>(this.key, this.iter.next());
        }

        @Override
        public void reset(double[] min, double[] max) {
            throw new UnsupportedOperationException();
        }
    }

    private static class IteratorWQ<T>
    implements QueryIterator<PointEntry<T>> {
        private final PhTreeMultiMapF2.PhQueryF<T> iter;

        private IteratorWQ(PhTreeMultiMapF2.PhQueryF<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public PointEntry<T> next() {
            PhEntryF e = this.iter.nextEntryReuse();
            return new EntryP<Object>((double[])e.getKey().clone(), e.getValue());
        }

        @Override
        public void reset(double[] min, double[] max) {
            this.iter.reset(min, max);
        }
    }

    private static class IteratorExtent<T>
    implements QueryIterator<PointEntry<T>> {
        private final PhTreeMultiMapF2.PhIteratorF<T> iter;

        private IteratorExtent(PhTreeMultiMapF2.PhIteratorF<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public PointEntry<T> next() {
            PhEntryF e = this.iter.nextEntryReuse();
            return new EntryP<Object>((double[])e.getKey().clone(), e.getValue());
        }

        @Override
        public void reset(double[] min, double[] max) {
            throw new UnsupportedOperationException();
        }
    }
}

