/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qthypercube;

import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.RectangleDistanceFunction;
import org.tinspin.index.RectangleEntry;
import org.tinspin.index.RectangleEntryDist;
import org.tinspin.index.qthypercube.QREntry;
import org.tinspin.index.qthypercube.QREntryDist;
import org.tinspin.index.qthypercube.QRNode;
import org.tinspin.index.qthypercube.QUtil;
import org.tinspin.index.util.MinHeap;
import org.tinspin.index.util.MinMaxHeap;

public class QRIteratorKnn<T>
implements QueryIteratorKNN<RectangleEntryDist<T>> {
    private final QRNode<T> root;
    private final RectangleDistanceFunction distFn;
    private final Predicate<RectangleEntry<T>> filterFn;
    MinHeap<NodeDistT> queueN = MinHeap.create((t1, t2) -> t1.dist < t2.dist);
    MinMaxHeap<QREntryDist<T>> queueV = MinMaxHeap.create((t1, t2) -> t1.dist() < t2.dist());
    double maxNodeDist = Double.POSITIVE_INFINITY;
    private RectangleEntryDist<T> current;
    private int remaining;
    private double[] center;
    private double currentDistance;

    QRIteratorKnn(QRNode<T> root, int minResults, double[] center, RectangleDistanceFunction distFn, Predicate<RectangleEntry<T>> filterFn) {
        this.filterFn = filterFn;
        this.distFn = distFn;
        this.root = root;
        this.reset(center, minResults);
    }

    @Override
    public QueryIteratorKNN<RectangleEntryDist<T>> reset(double[] center, int minResults) {
        this.center = center;
        this.currentDistance = Double.MAX_VALUE;
        this.remaining = minResults;
        this.maxNodeDist = Double.POSITIVE_INFINITY;
        this.current = null;
        if (minResults <= 0 || this.root == null) {
            return this;
        }
        this.queueN.clear();
        this.queueV.clear();
        this.queueN.push(new NodeDistT(0.0, this.root));
        this.FindNextElement();
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public RectangleEntryDist<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        RectangleEntryDist<T> ret = this.current;
        this.FindNextElement();
        return ret;
    }

    public double distance() {
        return this.currentDistance;
    }

    private void FindNextElement() {
        while (!(this.remaining <= 0 || this.queueN.isEmpty() && this.queueV.isEmpty())) {
            boolean useV;
            boolean bl = useV = !this.queueV.isEmpty();
            if (useV && !this.queueN.isEmpty()) {
                boolean bl2 = useV = this.queueV.peekMin().dist() <= this.queueN.peekMin().dist;
            }
            if (useV) {
                RectangleEntryDist result = this.queueV.peekMin();
                this.queueV.popMin();
                --this.remaining;
                this.current = result;
                this.currentDistance = result.dist();
                return;
            }
            NodeDistT top = this.queueN.peekMin();
            this.queueN.popMin();
            QRNode node = top.node;
            double dNode = top.dist;
            if (dNode > this.maxNodeDist && this.queueV.size() >= this.remaining) continue;
            if (node.hasValues()) {
                for (QREntry qREntry : node.getEntries()) {
                    double d;
                    if (!this.filterFn.test(qREntry) || !((d = this.distFn.dist(this.center, qREntry)) <= this.maxNodeDist)) continue;
                    this.queueV.push(new QREntryDist(qREntry, d));
                    if (this.queueV.size() < this.remaining) continue;
                    if (this.queueV.size() > this.remaining) {
                        this.queueV.popMax();
                    }
                    double dMax = this.queueV.peekMax().dist();
                    this.maxNodeDist = Math.min(this.maxNodeDist, dMax);
                }
            }
            if (!node.hasChildNodes()) continue;
            for (QRNode subnode : node.getChildNodes()) {
                double dist;
                if (subnode == null || !((dist = QUtil.distToRectNodeEDGE(this.center, subnode.getCenter(), subnode.getRadius())) <= this.maxNodeDist)) continue;
                this.queueN.push(new NodeDistT(dist, subnode));
            }
        }
        this.current = null;
        this.currentDistance = Double.MAX_VALUE;
    }

    private class NodeDistT {
        double dist;
        QRNode<T> node;

        public NodeDistT(double dist, QRNode<T> node) {
            this.dist = dist;
            this.node = node;
        }
    }
}

