/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qthypercube;

import org.tinspin.index.PointDistanceFunction;
import org.tinspin.index.qthypercube.QREntry;

class QUtil {
    static final double EPS_MUL = 1.000000001;

    private QUtil() {
    }

    public static boolean isPointEnclosed(double[] point, double[] min, double[] max) {
        for (int d = 0; d < min.length; ++d) {
            if (!(point[d] < min[d]) && !(point[d] > max[d])) continue;
            return false;
        }
        return true;
    }

    public static boolean fitsIntoNode(double[] point, double[] center, double radius) {
        for (int d = 0; d < center.length; ++d) {
            if (!(point[d] < center[d] - radius) && !(point[d] >= center[d] + radius)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPointEqual(double[] p1, double[] p2) {
        for (int d = 0; d < p1.length; ++d) {
            if (p1[d] == p2[d]) continue;
            return false;
        }
        return true;
    }

    public static boolean isRectEqual(double[] p1L, double[] p1U, double[] p2L, double[] p2U) {
        return QUtil.isPointEqual(p1L, p2L) && QUtil.isPointEqual(p1U, p2U);
    }

    public static <T> boolean isRectEqual(QREntry<T> e, double[] keyL, double[] keyU) {
        return QUtil.isRectEqual(e.lower(), e.upper(), keyL, keyU);
    }

    public static boolean overlap(double[] min, double[] max, double[] min2, double[] max2) {
        for (int d = 0; d < min.length; ++d) {
            if (!(max[d] < min2[d]) && !(min[d] > max2[d])) continue;
            return false;
        }
        return true;
    }

    public static boolean overlap(double[] min, double[] max, double[] center, double radius) {
        for (int d = 0; d < min.length; ++d) {
            if (!(max[d] < center[d] - radius) && !(min[d] > center[d] + radius)) continue;
            return false;
        }
        return true;
    }

    public static boolean isRectEnclosed(double[] minEnclosed, double[] maxEnclosed, double[] minOuter, double[] maxOuter) {
        for (int d = 0; d < minOuter.length; ++d) {
            if (!(maxOuter[d] < maxEnclosed[d]) && !(minOuter[d] > minEnclosed[d])) continue;
            return false;
        }
        return true;
    }

    public static boolean fitsIntoNode(double[] minEnclosed, double[] maxEnclosed, double[] centerNode, double radiusNode) {
        for (int d = 0; d < centerNode.length; ++d) {
            if (!(centerNode[d] + radiusNode <= maxEnclosed[d]) && !(centerNode[d] - radiusNode > minEnclosed[d])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNodeEnclosed(double[] centerEnclosed, double radiusEnclosed, double[] centerOuter, double radiusOuter) {
        for (int d = 0; d < centerOuter.length; ++d) {
            if (!(centerOuter[d] + radiusOuter < centerEnclosed[d] + radiusEnclosed) && !(centerOuter[d] - radiusOuter > centerEnclosed[d] - radiusEnclosed)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static double distance(double[] p1, double[] p2) {
        double dist = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            double d = p1[i] - p2[i];
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    @Deprecated
    static double distToRectEdge(double[] point, double[] rLower, double[] rUpper) {
        double dist = 0.0;
        for (int i = 0; i < point.length; ++i) {
            double d = 0.0;
            if (point[i] > rUpper[i]) {
                d = point[i] - rUpper[i];
            } else if (point[i] < rLower[i]) {
                d = rLower[i] - point[i];
            }
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    @Deprecated
    public static double distToRectEdge(double[] p, QREntry<?> e) {
        return QUtil.distToRectEdge(p, e.lower(), e.upper());
    }

    static double distToRectNode(double[] point, double[] nodeCenter, double nodeRadius, PointDistanceFunction distFn) {
        double[] dist = new double[point.length];
        for (int i = 0; i < point.length; ++i) {
            double d = point[i];
            if (point[i] > nodeCenter[i] + nodeRadius) {
                d = nodeCenter[i] + nodeRadius;
            } else if (point[i] < nodeCenter[i] - nodeRadius) {
                d = nodeCenter[i] - nodeRadius;
            }
            dist[i] = d;
        }
        return distFn.dist(dist, point);
    }

    static double distToRectNodeEDGE(double[] point, double[] nodeCenter, double nodeRadius) {
        double[] dist = new double[point.length];
        for (int i = 0; i < point.length; ++i) {
            double d = point[i];
            if (point[i] > nodeCenter[i] + nodeRadius) {
                d = nodeCenter[i] + nodeRadius;
            } else if (point[i] < nodeCenter[i] - nodeRadius) {
                d = nodeCenter[i] - nodeRadius;
            }
            dist[i] = d;
        }
        return PointDistanceFunction.L2.dist(point, dist);
    }
}

