/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qthypercube2;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.tinspin.index.PointEntry;
import org.tinspin.index.QueryIterator;
import org.tinspin.index.qthypercube2.QEntry;
import org.tinspin.index.qthypercube2.QNode;
import org.tinspin.index.qthypercube2.QUtil;
import org.tinspin.index.qthypercube2.QuadTreeKD2;

public class QIterator2<T>
implements QueryIterator<PointEntry<T>> {
    private final QuadTreeKD2<T> tree;
    private IteratorStack stack = new IteratorStack();
    private QEntry<T> next = null;
    private double[] min;
    private double[] max;

    QIterator2(QuadTreeKD2<T> tree, double[] min, double[] max) {
        this.tree = tree;
        this.reset(min, max);
    }

    private void findNext() {
        while (!this.stack.isEmpty()) {
            StackEntry se = this.stack.peek();
            while (se.pos < (long)se.len) {
                Object e;
                if (se.isLeaf()) {
                    QEntry e2;
                    if (!QUtil.isPointEnclosed((e2 = (QEntry)se.entries[(int)se.pos++]).point(), this.min, this.max)) continue;
                    this.next = e2;
                    return;
                }
                int pos = (int)se.pos;
                se.inc();
                if (se.pos <= (long)pos) {
                    se.pos = Long.MAX_VALUE;
                }
                if ((e = se.entries[pos]) == null) continue;
                if (e instanceof QNode) {
                    QNode node = (QNode)e;
                    se = this.stack.prepareAndPush(node, this.min, this.max);
                    continue;
                }
                QEntry qe = (QEntry)e;
                if (!QUtil.isPointEnclosed(qe.point(), this.min, this.max)) continue;
                this.next = qe;
                return;
            }
            this.stack.pop();
        }
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public QEntry<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        QEntry<T> ret = this.next;
        this.findNext();
        return ret;
    }

    @Override
    public void reset(double[] min, double[] max) {
        this.stack.clear();
        this.min = min;
        this.max = max;
        this.next = null;
        if (this.tree.getRoot() != null) {
            this.stack.prepareAndPush(this.tree.getRoot(), min, max);
            this.findNext();
        }
    }

    private static class StackEntry<T> {
        long pos;
        long m0;
        long m1;
        Object[] entries;
        boolean isLeaf;
        int len;

        private StackEntry() {
        }

        void set(QNode<T> node, double[] min, double[] max) {
            this.entries = node.getEntries();
            this.isLeaf = node.isLeaf();
            if (this.isLeaf) {
                this.len = node.getValueCount();
                this.pos = 0L;
            } else {
                this.len = this.entries.length;
                this.m0 = 0L;
                this.m1 = 0L;
                double[] center = node.getCenter();
                for (int d = 0; d < center.length; ++d) {
                    this.m0 <<= 1;
                    this.m1 <<= 1;
                    if (!(max[d] >= center[d])) continue;
                    this.m1 |= 1L;
                    if (!(min[d] >= center[d])) continue;
                    this.m0 |= 1L;
                }
                this.pos = this.m0;
            }
        }

        boolean isLeaf() {
            return this.isLeaf;
        }

        void inc() {
            long r = this.pos | this.m1 ^ 0xFFFFFFFFFFFFFFFFL;
            this.pos = ++r & this.m1 | this.m0;
        }
    }

    private class IteratorStack {
        private final ArrayList<StackEntry<T>> stack = new ArrayList();
        private int size = 0;

        IteratorStack() {
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        StackEntry<T> prepareAndPush(QNode<T> node, double[] min, double[] max) {
            if (this.size == this.stack.size()) {
                this.stack.add(new StackEntry());
            }
            StackEntry ni = this.stack.get(this.size++);
            ni.set(node, min, max);
            return ni;
        }

        StackEntry<T> peek() {
            return this.stack.get(this.size - 1);
        }

        StackEntry<T> pop() {
            return this.stack.get(--this.size);
        }

        public void clear() {
            this.size = 0;
        }
    }
}

