/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qthypercube2;

import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.tinspin.index.PointDistanceFunction;
import org.tinspin.index.PointEntry;
import org.tinspin.index.PointEntryDist;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.qthypercube2.QEntry;
import org.tinspin.index.qthypercube2.QEntryDist;
import org.tinspin.index.qthypercube2.QNode;
import org.tinspin.index.qthypercube2.QUtil;
import org.tinspin.index.util.MinHeap;
import org.tinspin.index.util.MinMaxHeap;

public class QIteratorKnn<T>
implements QueryIteratorKNN<PointEntryDist<T>> {
    private final QNode<T> root;
    private final PointDistanceFunction distFn;
    private final Predicate<PointEntry<T>> filterFn;
    MinHeap<NodeDistT> queueN = MinHeap.create((t1, t2) -> t1.dist < t2.dist);
    MinMaxHeap<QEntryDist<T>> queueV = MinMaxHeap.create((t1, t2) -> t1.dist() < t2.dist());
    double maxNodeDist = Double.POSITIVE_INFINITY;
    private PointEntryDist<T> current;
    private int remaining;
    private double[] center;
    private double currentDistance;

    QIteratorKnn(QNode<T> root, int minResults, double[] center, PointDistanceFunction distFn, Predicate<PointEntry<T>> filterFn) {
        this.filterFn = filterFn;
        this.distFn = distFn;
        this.root = root;
        this.reset(center, minResults);
    }

    @Override
    public QueryIteratorKNN<PointEntryDist<T>> reset(double[] center, int minResults) {
        this.center = center;
        this.currentDistance = Double.MAX_VALUE;
        this.remaining = minResults;
        this.maxNodeDist = Double.POSITIVE_INFINITY;
        this.current = null;
        if (minResults <= 0 || this.root == null) {
            return this;
        }
        this.queueN.clear();
        this.queueV.clear();
        this.queueN.push(new NodeDistT(0.0, this.root));
        this.FindNextElement();
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public PointEntryDist<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        PointEntryDist<T> ret = this.current;
        this.FindNextElement();
        return ret;
    }

    public double distance() {
        return this.currentDistance;
    }

    private void FindNextElement() {
        while (!(this.remaining <= 0 || this.queueN.isEmpty() && this.queueV.isEmpty())) {
            boolean useV;
            boolean bl = useV = !this.queueV.isEmpty();
            if (useV && !this.queueN.isEmpty()) {
                boolean bl2 = useV = this.queueV.peekMin().dist() <= this.queueN.peekMin().dist;
            }
            if (useV) {
                PointEntryDist result = this.queueV.peekMin();
                this.queueV.popMin();
                --this.remaining;
                this.current = result;
                this.currentDistance = result.dist();
                return;
            }
            NodeDistT top = this.queueN.peekMin();
            this.queueN.popMin();
            QNode node = top.node;
            double dNode = top.dist;
            if (dNode > this.maxNodeDist && this.queueV.size() >= this.remaining) continue;
            if (node.isLeaf()) {
                for (QEntry entry : node.getValues()) {
                    this.processEntry(entry);
                }
                continue;
            }
            for (Object o : node.getEntries()) {
                if (o instanceof QNode) {
                    QNode subnode = (QNode)o;
                    double dist = QUtil.distToRectNode(this.center, subnode.getCenter(), subnode.getRadius(), this.distFn);
                    if (!(dist <= this.maxNodeDist)) continue;
                    this.queueN.push(new NodeDistT(dist, subnode));
                    continue;
                }
                this.processEntry((QEntry)o);
            }
        }
        this.current = null;
        this.currentDistance = Double.MAX_VALUE;
    }

    private void processEntry(QEntry<T> entry) {
        double d;
        if (entry != null && this.filterFn.test(entry) && (d = this.distFn.dist(this.center, entry.point())) <= this.maxNodeDist) {
            this.queueV.push(new QEntryDist<T>(entry, d));
            if (this.queueV.size() >= this.remaining) {
                if (this.queueV.size() > this.remaining) {
                    this.queueV.popMax();
                }
                double dMax = this.queueV.peekMax().dist();
                this.maxNodeDist = Math.min(this.maxNodeDist, dMax);
            }
        }
    }

    private class NodeDistT {
        double dist;
        QNode<T> node;

        public NodeDistT(double dist, QNode<T> node) {
            this.dist = dist;
            this.node = node;
        }
    }
}

