/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qtplain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Predicate;
import org.tinspin.index.PointEntry;
import org.tinspin.index.qtplain.QEntry;
import org.tinspin.index.qtplain.QUtil;
import org.tinspin.index.qtplain.QuadTreeKD0;

public class QNode<T> {
    private double[] center;
    private double radius;
    private ArrayList<QEntry<T>> values;
    private ArrayList<QNode<T>> subs;

    QNode(double[] center, double radius) {
        this.center = center;
        this.radius = radius;
        this.values = new ArrayList(2);
    }

    QNode(double[] center, double radius, QNode<T> subNode) {
        this.center = center;
        this.radius = radius;
        this.values = null;
        this.subs = new ArrayList();
        this.subs.add(subNode);
    }

    QNode<T> tryPut(QEntry<T> e, int maxNodeSize, boolean enforceLeaf) {
        if (this.values == null) {
            return this.getOrCreateSub(e);
        }
        if (this.values.size() < maxNodeSize || enforceLeaf || e.isExact(this.values.get(0))) {
            this.values.add(e);
            return null;
        }
        ArrayList<QEntry<T>> vals = this.values;
        this.values = null;
        this.subs = new ArrayList();
        for (int i = 0; i < vals.size(); ++i) {
            QEntry<T> e2 = vals.get(i);
            for (QNode<T> sub = this.getOrCreateSub(e2); sub != null; sub = sub.tryPut(e2, maxNodeSize, false)) {
            }
        }
        return this.getOrCreateSub(e);
    }

    private QNode<T> getOrCreateSub(QEntry<T> e) {
        QNode<T> n = this.findSubNode(e.point());
        if (n == null) {
            n = this.createSubForEntry(e.point());
            this.subs.add(n);
        }
        return n;
    }

    private QNode<T> createSubForEntry(double[] p) {
        double[] centerSub = new double[this.center.length];
        double radiusSub = this.radius / 2.0;
        for (int d = 0; d < this.center.length; ++d) {
            centerSub[d] = p[d] >= this.center[d] ? this.center[d] + radiusSub : this.center[d] - radiusSub;
        }
        return new QNode<T>(centerSub, radiusSub);
    }

    private QNode<T> findSubNode(double[] p) {
        for (int i = 0; i < this.subs.size(); ++i) {
            QNode<T> n = this.subs.get(i);
            if (!QUtil.fitsIntoNode(p, n.center, n.radius)) continue;
            return n;
        }
        return null;
    }

    QEntry<T> remove(QNode<T> parent, double[] key, int maxNodeSize, Predicate<PointEntry<T>> pred) {
        if (this.values == null) {
            QNode<T> sub = this.findSubNode(key);
            if (sub != null) {
                return sub.remove(this, key, maxNodeSize, pred);
            }
            return null;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            QEntry<T> e = this.values.get(i);
            if (!QUtil.isPointEqual(e.point(), key) || !pred.test(e)) continue;
            this.values.remove(i);
            if (parent != null) {
                parent.checkAndMergeLeafNodes(maxNodeSize);
            }
            return e;
        }
        return null;
    }

    QEntry<T> update(QNode<T> parent, double[] keyOld, double[] keyNew, int maxNodeSize, boolean[] requiresReinsert, int currentDepth, int maxDepth, Predicate<PointEntry<T>> pred) {
        if (this.values == null) {
            QNode<T> sub = this.findSubNode(keyOld);
            if (sub == null) {
                return null;
            }
            QEntry<T> ret = sub.update(this, keyOld, keyNew, maxNodeSize, requiresReinsert, currentDepth + 1, maxDepth, pred);
            if (ret != null && requiresReinsert[0] && QUtil.fitsIntoNode(ret.point(), this.center, this.radius)) {
                requiresReinsert[0] = false;
                for (QNode<T> r = this; r != null; r = r.tryPut(ret, maxNodeSize, currentDepth++ > maxDepth)) {
                }
            }
            return ret;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            QEntry<T> e = this.values.get(i);
            if (!QUtil.isPointEqual(e.point(), keyOld) || !pred.test(e)) continue;
            this.values.remove(i);
            e.setKey(keyNew);
            if (QUtil.fitsIntoNode(keyNew, this.center, this.radius)) {
                this.values.add(e);
                requiresReinsert[0] = false;
            } else {
                requiresReinsert[0] = true;
                if (parent != null) {
                    parent.checkAndMergeLeafNodes(maxNodeSize);
                }
            }
            return e;
        }
        requiresReinsert[0] = false;
        return null;
    }

    private void checkAndMergeLeafNodes(int maxNodeSize) {
        int i;
        int nTotal = 0;
        for (i = 0; i < this.subs.size(); ++i) {
            if (this.subs.get((int)i).values == null) {
                return;
            }
            if ((nTotal += this.subs.get((int)i).values.size()) <= maxNodeSize) continue;
            return;
        }
        this.values = new ArrayList(nTotal);
        for (i = 0; i < this.subs.size(); ++i) {
            this.values.addAll(this.subs.get((int)i).values);
        }
        this.subs = null;
    }

    double[] getCenter() {
        return this.center;
    }

    double getRadius() {
        return this.radius;
    }

    QEntry<T> getExact(double[] key, Predicate<PointEntry<T>> pred) {
        if (this.values == null) {
            QNode<T> sub = this.findSubNode(key);
            if (sub != null) {
                return sub.getExact(key, pred);
            }
            return null;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            QEntry<T> e = this.values.get(i);
            if (!QUtil.isPointEqual(e.point(), key) || !pred.test(e)) continue;
            return e;
        }
        return null;
    }

    ArrayList<QEntry<T>> getEntries() {
        return this.values;
    }

    Iterator<?> getChildIterator() {
        if (this.values != null) {
            return this.values.iterator();
        }
        return this.subs.iterator();
    }

    public String toString() {
        return "center/radius=" + Arrays.toString(this.center) + "/" + this.radius + " " + System.identityHashCode(this);
    }

    void checkNode(QuadTreeKD0.QStats s, QNode<T> parent, int depth) {
        if (depth > s.maxDepth) {
            s.maxDepth = depth;
        }
        ++s.nNodes;
        if (parent != null && !QUtil.isNodeEnclosed(this.center, this.radius, parent.center, parent.radius * 1.000000001)) {
            for (int d = 0; d < this.center.length; ++d) {
                System.out.println("Outer: " + parent.radius + " " + Arrays.toString(parent.center));
                System.out.println("Child: " + this.radius + " " + Arrays.toString(this.center));
                System.out.println(parent.center[d] + parent.radius + " vs " + (this.center[d] + this.radius));
                System.out.println("r=" + (parent.center[d] + parent.radius) / (this.center[d] + this.radius));
                System.out.println(parent.center[d] - parent.radius + " vs " + (this.center[d] - this.radius));
                System.out.println("r=" + (parent.center[d] - parent.radius) / (this.center[d] - this.radius));
            }
            throw new IllegalStateException();
        }
        if (this.values != null) {
            for (int i = 0; i < this.values.size(); ++i) {
                QEntry<T> e = this.values.get(i);
                if (QUtil.fitsIntoNode(e.point(), this.center, this.radius * 1.000000001)) continue;
                System.out.println("Node: " + this.radius + " " + Arrays.toString(this.center));
                System.out.println("Child: " + Arrays.toString(e.point()));
                for (int d = 0; d < this.center.length; ++d) {
                    System.out.println("min/max for " + d);
                    System.out.println("min: " + (this.center[d] - this.radius) + " vs " + e.point()[d]);
                    System.out.println("r=" + (this.center[d] - this.radius) / e.point()[d]);
                    System.out.println("max: " + (this.center[d] + this.radius) + " vs " + e.point()[d]);
                    System.out.println("r=" + (this.center[d] + this.radius) / e.point()[d]);
                }
                throw new IllegalStateException();
            }
            if (this.subs != null) {
                throw new IllegalStateException();
            }
        } else {
            for (int i = 0; i < this.subs.size(); ++i) {
                QNode<T> n = this.subs.get(i);
                n.checkNode(s, this, depth + 1);
            }
        }
    }

    boolean isLeaf() {
        return this.values != null;
    }

    ArrayList<QNode<T>> getChildNodes() {
        return this.subs;
    }

    void adjustRadius(double radius) {
        if (!this.isLeaf()) {
            throw new IllegalStateException();
        }
        this.radius = radius;
    }
}

