/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qtplain;

import java.util.Arrays;
import org.tinspin.index.RectangleEntry;
import org.tinspin.index.qtplain.QUtil;

public class QREntry<T>
implements RectangleEntry<T> {
    private double[] pointL;
    private double[] pointU;
    private final T value;

    public QREntry(double[] keyL, double[] keyU, T value) {
        this.pointL = keyL;
        this.pointU = keyU;
        this.value = value;
    }

    @Override
    public double[] lower() {
        return this.pointL;
    }

    @Override
    public double[] upper() {
        return this.pointU;
    }

    @Override
    public T value() {
        return this.value;
    }

    public boolean isExact(QREntry<T> e) {
        return QUtil.isPointEqual(this.pointL, e.lower()) && QUtil.isPointEqual(this.pointU, e.upper());
    }

    public String toString() {
        return "p=" + Arrays.toString(this.pointL) + "/" + Arrays.toString(this.pointU) + "  v=" + this.value + " " + System.identityHashCode(this);
    }

    public void setKey(double[] newPointL, double[] newPointU) {
        this.pointL = newPointL;
        this.pointU = newPointU;
    }
}

