/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qtplain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Predicate;
import org.tinspin.index.RectangleEntry;
import org.tinspin.index.qtplain.QREntry;
import org.tinspin.index.qtplain.QUtil;
import org.tinspin.index.qtplain.QuadTreeKD0;

public class QRNode<T> {
    private final double[] center;
    private final double radius;
    private ArrayList<QREntry<T>> values;
    private ArrayList<QRNode<T>> subs;

    QRNode(double[] center, double radius) {
        this.center = center;
        this.radius = radius;
        this.values = new ArrayList();
    }

    QRNode(double[] center, double radius, QRNode<T> subNode) {
        this.center = center;
        this.radius = radius;
        this.values = null;
        this.subs = new ArrayList();
        this.subs.add(subNode);
    }

    QRNode<T> tryPut(QREntry<T> e, int maxNodeSize, boolean enforceLeaf) {
        QRNode<T> sub1 = this.findSubNode(e.lower(), e.upper());
        if (this.subs != null && sub1 != this) {
            if (sub1 == null) {
                sub1 = this.createSubForEntry(e);
            }
            return sub1;
        }
        if (this.values == null) {
            this.values = new ArrayList();
        }
        if (this.values.size() < maxNodeSize || enforceLeaf || e.isExact(this.values.get(0)) || this.subs != null) {
            this.values.add(e);
            return null;
        }
        ArrayList<QREntry<T>> vals = this.values;
        vals.add(e);
        this.values = null;
        this.subs = new ArrayList();
        for (int i = 0; i < vals.size(); ++i) {
            QREntry<T> e2 = vals.get(i);
            QRNode<T> sub = this.findSubNode(e2.lower(), e2.upper());
            if (sub == this) {
                if (this.values == null) {
                    this.values = new ArrayList();
                }
                this.values.add(e2);
                continue;
            }
            if (sub == null) {
                sub = this.createSubForEntry(e2);
            }
            while (sub != null) {
                sub = sub.tryPut(e2, maxNodeSize, false);
            }
        }
        return null;
    }

    private QRNode<T> createSubForEntry(QREntry<T> e) {
        double[] centerSub = new double[this.center.length];
        double[] pMin = e.lower();
        double radiusSub = this.radius / 2.0;
        for (int d = 0; d < this.center.length; ++d) {
            centerSub[d] = pMin[d] >= this.center[d] ? this.center[d] + radiusSub : this.center[d] - radiusSub;
        }
        QRNode<T> n = new QRNode<T>(centerSub, radiusSub);
        this.subs.add(n);
        return n;
    }

    private QRNode<T> findSubNode(double[] pMin, double[] pMax) {
        int i;
        if (this.subs != null) {
            for (i = 0; i < this.subs.size(); ++i) {
                QRNode<T> n = this.subs.get(i);
                if (!QUtil.fitsIntoNode(pMin, pMax, n.center, n.radius)) continue;
                return n;
            }
        }
        for (i = 0; i < this.center.length; ++i) {
            if (!(pMin[i] < this.center[i]) || !(pMax[i] >= this.center[i])) continue;
            return this;
        }
        return null;
    }

    QREntry<T> remove(QRNode<T> parent, double[] keyL, double[] keyU, int maxNodeSize, Predicate<RectangleEntry<T>> condition) {
        QRNode<T> sub;
        if (this.subs != null && (sub = this.findSubNode(keyL, keyU)) != this) {
            if (sub != null) {
                return sub.remove(this, keyL, keyU, maxNodeSize, condition);
            }
            return null;
        }
        if (this.values == null) {
            return null;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            QREntry<T> e = this.values.get(i);
            if (!QUtil.isRectEqual(e, keyL, keyU) || !condition.test(e)) continue;
            this.values.remove(i);
            if (parent != null) {
                parent.checkAndMergeLeafNodes(maxNodeSize);
            }
            return e;
        }
        return null;
    }

    QREntry<T> update(QRNode<T> parent, double[] keyOldL, double[] keyOldU, double[] keyNewL, double[] keyNewU, int maxNodeSize, boolean[] requiresReinsert, int currentDepth, int maxDepth, Predicate<T> pred) {
        QRNode<T> sub;
        if (this.subs != null && (sub = this.findSubNode(keyOldL, keyOldU)) != this) {
            if (sub == null) {
                return null;
            }
            QREntry<T> ret = sub.update(this, keyOldL, keyOldU, keyNewL, keyNewU, maxNodeSize, requiresReinsert, currentDepth + 1, maxDepth, pred);
            if (ret != null && requiresReinsert[0] && QUtil.fitsIntoNode(ret.lower(), ret.upper(), this.center, this.radius)) {
                requiresReinsert[0] = false;
                for (QRNode<T> r = this; r != null; r = r.tryPut(ret, maxNodeSize, currentDepth++ > maxDepth)) {
                }
            }
            return ret;
        }
        if (this.values == null) {
            return null;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            QREntry<T> e = this.values.get(i);
            if (!QUtil.isRectEqual(e, keyOldL, keyOldU) || !pred.test(e.value())) continue;
            this.values.remove(i);
            e.setKey(keyNewL, keyNewU);
            if (QUtil.fitsIntoNode(keyNewL, keyNewU, this.center, this.radius)) {
                requiresReinsert[0] = false;
                QRNode<T> sub2 = this.findSubNode(keyNewL, keyNewU);
                if (sub2 == this) {
                    this.values.add(e);
                } else {
                    QRNode<T> r;
                    if (sub2 == null) {
                        r = this;
                    } else {
                        r = sub2;
                        ++currentDepth;
                    }
                    while (r != null) {
                        r = r.tryPut(e, maxNodeSize, currentDepth++ > maxDepth);
                    }
                }
            } else {
                requiresReinsert[0] = true;
                if (parent != null) {
                    parent.checkAndMergeLeafNodes(maxNodeSize);
                }
            }
            return e;
        }
        requiresReinsert[0] = false;
        return null;
    }

    private void checkAndMergeLeafNodes(int maxNodeSize) {
        int i;
        int nTotal = 0;
        if (this.values != null) {
            nTotal += this.values.size();
        }
        for (i = 0; i < this.subs.size(); ++i) {
            QRNode<T> sub = this.subs.get(i);
            if (sub.subs != null) {
                return;
            }
            if (sub.values != null) {
                nTotal += sub.values.size();
            }
            if (nTotal <= maxNodeSize) continue;
            return;
        }
        if (this.values == null) {
            this.values = new ArrayList();
        }
        for (i = 0; i < this.subs.size(); ++i) {
            this.values.addAll(this.subs.get((int)i).values);
        }
        this.subs = null;
    }

    double[] getCenter() {
        return this.center;
    }

    double getRadius() {
        return this.radius;
    }

    QREntry<T> getExact(double[] keyL, double[] keyU, Predicate<RectangleEntry<T>> condition) {
        QRNode<T> sub;
        if (this.subs != null && (sub = this.findSubNode(keyL, keyU)) != this) {
            if (sub != null) {
                return sub.getExact(keyL, keyU, condition);
            }
            return null;
        }
        if (this.values == null) {
            return null;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            QREntry<T> e = this.values.get(i);
            if (!QUtil.isRectEqual(e, keyL, keyU) || !condition.test(e)) continue;
            return e;
        }
        return null;
    }

    ArrayList<QREntry<T>> getEntries() {
        return this.values;
    }

    Iterator<?> getChildIterator() {
        if (this.subs == null) {
            return this.values.iterator();
        }
        return new ArrayIterator<QREntry<T>>(this.subs, this.values != null ? this.values : null);
    }

    public String toString() {
        return "center/radius=" + Arrays.toString(this.center) + "/" + this.radius + " " + System.identityHashCode(this);
    }

    void checkNode(QuadTreeKD0.QStats s, QRNode<T> parent, int depth) {
        int i;
        if (depth > s.maxDepth) {
            s.maxDepth = depth;
        }
        ++s.nNodes;
        if (parent == null || !QUtil.isNodeEnclosed(this.center, this.radius, parent.center, parent.radius * 1.000000001)) {
            // empty if block
        }
        if (this.values != null) {
            for (i = 0; i < this.values.size(); ++i) {
                QREntry<T> e = this.values.get(i);
                if (QUtil.fitsIntoNode(e.lower(), e.upper(), this.center, this.radius * 1.000000001)) continue;
                throw new IllegalStateException();
            }
        }
        if (this.subs != null) {
            for (i = 0; i < this.subs.size(); ++i) {
                QRNode<T> n = this.subs.get(i);
                if (n == null) continue;
                n.checkNode(s, this, depth + 1);
            }
        }
    }

    boolean hasValues() {
        return this.values != null;
    }

    boolean hasChildNodes() {
        return this.subs != null;
    }

    ArrayList<QRNode<T>> getChildNodes() {
        return this.subs;
    }

    private static class ArrayIterator<E>
    implements Iterator<E> {
        private Iterator<E> data;
        private ArrayList<E> data2;

        ArrayIterator(ArrayList<E> data1, ArrayList<E> data2) {
            this.data = data1.iterator();
            this.data2 = data2;
        }

        private void findNext() {
            if (!this.data.hasNext() && this.data2 != null) {
                this.data = this.data2.iterator();
                this.data2 = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.data.hasNext();
        }

        @Override
        public E next() {
            E ret = this.data.next();
            this.findNext();
            return ret;
        }
    }
}

