/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.Arrays;
import org.tinspin.index.RectangleEntry;

public class Entry<T>
implements RectangleEntry<T>,
Comparable<Entry<T>> {
    protected double[] min;
    protected double[] max;
    private T val;

    public Entry(double[] min, double[] max, T val) {
        this.min = min;
        this.max = max;
        this.val = val;
    }

    @Override
    public double[] lower() {
        return this.min;
    }

    @Override
    public double[] upper() {
        return this.max;
    }

    @Override
    public T value() {
        return this.val;
    }

    @Override
    public int compareTo(Entry<T> o) {
        return Double.compare(this.min[0], o.min[0]);
    }

    double calcOverlap(Entry<T> e) {
        double area = 1.0;
        for (int i = 0; i < this.min.length; ++i) {
            double d = Entry.min(this.max[i], e.max[i]) - Entry.max(this.min[i], e.min[i]);
            if (d <= 0.0) {
                return 0.0;
            }
            area *= d;
        }
        return area;
    }

    public boolean checkInclusion(double[] min2, double[] max2) {
        for (int i = 0; i < this.min.length; ++i) {
            if (!(this.min[i] > min2[i]) && !(this.max[i] < max2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean checkExactMatch(double[] min2, double[] max2) {
        for (int i = 0; i < this.min.length; ++i) {
            if (this.min[i] == min2[i] && this.max[i] == max2[i]) continue;
            return false;
        }
        return true;
    }

    public double calcArea() {
        double area = 1.0;
        for (int i = 0; i < this.min.length; ++i) {
            double d = this.max[i] - this.min[i];
            area *= d;
        }
        return area;
    }

    public void setToCover(Entry<T> e1, Entry<T> e2) {
        for (int i = 0; i < this.min.length; ++i) {
            this.min[i] = Entry.min(e1.min[i], e2.min[i]);
            this.max[i] = Entry.max(e1.max[i], e2.max[i]);
        }
    }

    static double min(double d1, double d2) {
        return d1 < d2 ? d1 : d2;
    }

    static double max(double d1, double d2) {
        return d1 > d2 ? d1 : d2;
    }

    public static double calcVolume(Entry<?> e) {
        return Entry.calcVolume(e.min, e.max);
    }

    public static double calcVolume(double[] min, double[] max) {
        double v = 1.0;
        for (int d = 0; d < min.length; ++d) {
            v *= max[d] - min[d];
        }
        return v;
    }

    public static void calcBoundingBox(Entry<?>[] entries, int start, int end, double[] minOut, double[] maxOut) {
        System.arraycopy(entries[start].min, 0, minOut, 0, minOut.length);
        System.arraycopy(entries[start].max, 0, maxOut, 0, maxOut.length);
        for (int i = start + 1; i < end; ++i) {
            for (int d = 0; d < minOut.length; ++d) {
                minOut[d] = Entry.min(minOut[d], entries[i].min[d]);
                maxOut[d] = Entry.max(maxOut[d], entries[i].max[d]);
            }
        }
    }

    public static double calcOverlap(double[] min1, double[] max1, double[] min2, double[] max2) {
        double area = 1.0;
        for (int i = 0; i < min1.length; ++i) {
            double d = Entry.min(max1[i], max2[i]) - Entry.max(min1[i], min2[i]);
            if (d <= 0.0) {
                return 0.0;
            }
            area *= d;
        }
        return area;
    }

    public static boolean checkOverlap(double[] min, double[] max, Entry<?> e) {
        for (int i = 0; i < min.length; ++i) {
            if (!(min[i] > e.max[i]) && !(max[i] < e.min[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean calcIncludes(double[] minOut, double[] maxOut, double[] minIn, double[] maxIn) {
        for (int i = 0; i < minOut.length; ++i) {
            if (!(minOut[i] > minIn[i]) && !(maxOut[i] < maxIn[i])) continue;
            return false;
        }
        return true;
    }

    public static double calcDeadspace(Entry<?>[] entries, int start, int end, double[] minOut, double[] maxOut) {
        Arrays.fill(minOut, Double.POSITIVE_INFINITY);
        Arrays.fill(maxOut, Double.NEGATIVE_INFINITY);
        double volumeSum = 0.0;
        for (int i = start; i < end; ++i) {
            double v = 1.0;
            for (int d = 0; d < minOut.length; ++d) {
                minOut[d] = Entry.min(minOut[d], entries[i].min[d]);
                maxOut[d] = Entry.max(maxOut[d], entries[i].max[d]);
                v *= entries[i].max[d] - entries[i].min[d];
            }
            volumeSum += v;
        }
        return Entry.calcVolume(minOut, maxOut) - volumeSum;
    }

    public static double calcMargin(double[] min2, double[] max2) {
        double d = 0.0;
        for (int i = 0; i < min2.length; ++i) {
            d += max2[i] - min2[i];
        }
        return d;
    }

    public static double calcCenterDistance(Entry<?> e1, Entry<?> e2) {
        double[] min1 = e1.min;
        double[] max1 = e1.max;
        double[] min2 = e2.min;
        double[] max2 = e2.max;
        double dist = 0.0;
        for (int i = 0; i < min1.length; ++i) {
            double d = min1[i] + max1[i] - (min2[i] + max2[i]);
            dist += (d *= 0.5) * d;
        }
        return Math.sqrt(dist);
    }

    public String toString() {
        double[] len = new double[this.min.length];
        Arrays.setAll(len, i -> this.max[i] - this.min[i]);
        return Arrays.toString(this.min) + "/" + Arrays.toString(this.max) + ";len=" + Arrays.toString(len) + ";v=" + this.val;
    }

    protected void set(Entry<T> e) {
        this.min = e.min;
        this.max = e.max;
        this.val = e.val;
    }

    public void set(double[] lower, double[] upper, T val) {
        this.min = lower;
        this.max = upper;
        this.val = val;
    }
}

