/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.tinspin.index.rtree.DistEntry;
import org.tinspin.index.rtree.Entry;

public class KnnResult<T>
implements Iterable<DistEntry<T>> {
    private int capacity;
    private DistEntry<T>[] entries;
    private int size;
    private double maxDist;

    public KnnResult(int capacity) {
        this.capacity = capacity;
        this.entries = new DistEntry[capacity];
        this.maxDist = Double.MAX_VALUE;
    }

    public double add(Entry<T> e, double distance) {
        DistEntry<T> de;
        if (this.size < this.capacity) {
            de = new DistEntry<T>(e.min, e.max, e.value(), distance);
            this.entries[this.size++] = de;
        } else {
            de = this.entries[this.size - 1];
            if (distance >= de.dist()) {
                return this.maxDist;
            }
            de.set(e, distance);
        }
        for (int pos = this.size - 1; pos >= 1 && this.entries[pos - 1].dist() > distance; --pos) {
            this.entries[pos] = this.entries[pos - 1];
        }
        this.entries[pos] = de;
        if (this.size == this.capacity) {
            this.maxDist = this.entries[this.size - 1].dist();
        }
        return this.maxDist;
    }

    @Override
    public Iterator<DistEntry<T>> iterator() {
        return new KnnResultIterator();
    }

    public void clear(int k) {
        if (k > this.entries.length) {
            this.entries = new DistEntry[k];
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.entries[i] = null;
            }
        }
        this.capacity = k;
        this.size = 0;
        this.maxDist = Double.MAX_VALUE;
    }

    private class KnnResultIterator
    implements Iterator<DistEntry<T>> {
        int pos = 0;

        private KnnResultIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < KnnResult.this.size;
        }

        @Override
        public DistEntry<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return KnnResult.this.entries[this.pos++];
        }
    }
}

