/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.tinspin.index.RectangleDistanceFunction;
import org.tinspin.index.RectangleEntry;
import org.tinspin.index.RectangleEntryDist;
import org.tinspin.index.RectangleIndex;
import org.tinspin.index.RectangleIndexMM;
import org.tinspin.index.Stats;
import org.tinspin.index.rtree.Entry;
import org.tinspin.index.rtree.Filter;
import org.tinspin.index.rtree.RStarTreeLogic;
import org.tinspin.index.rtree.RTreeIterator;
import org.tinspin.index.rtree.RTreeLogic;
import org.tinspin.index.rtree.RTreeMixedQuery;
import org.tinspin.index.rtree.RTreeNode;
import org.tinspin.index.rtree.RTreeNodeDir;
import org.tinspin.index.rtree.RTreeNodeLeaf;
import org.tinspin.index.rtree.RTreeQuery1NN;
import org.tinspin.index.rtree.RTreeQueryKnn2;
import org.tinspin.index.rtree.STRLoader;
import org.tinspin.index.util.MutableRef;
import org.tinspin.index.util.StringBuilderLn;

public class RTree<T>
implements RectangleIndex<T>,
RectangleIndexMM<T> {
    static final int NODE_MAX_DIR = 10;
    static final int NODE_MAX_DATA = 10;
    static final int NODE_MIN_DIR = 2;
    static final int NODE_MIN_DATA = 2;
    public static final boolean DEBUG = false;
    private final int dims;
    private int size = 0;
    private int depth;
    private RTreeNode<T> root;
    private int nNodes = 0;
    private long nDist1NN = 0L;
    private long nDistKNN = 0L;
    static RTreeLogic logic = new RStarTreeLogic();

    protected RTree(int dims) {
        this.dims = dims;
        this.init();
    }

    public static <T> RTree<T> createRStar(int dims) {
        return new RTree<T>(dims);
    }

    private void init() {
        this.root = new RTreeNodeLeaf(this.dims);
        this.nNodes = 1;
        this.depth = 1;
        this.size = 0;
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.init();
    }

    public void insert(double[] point, T value) {
        this.insert(new Entry<T>(point, point, value));
    }

    @Override
    public void insert(double[] keyMin, double[] keyMax, T value) {
        this.insert(new Entry<T>(keyMin, keyMax, value));
    }

    public void insert(Entry<T> e) {
        ++this.size;
        this.insertAtDepth(e, 0);
    }

    private void insertAtDepth(Entry<T> e, int desiredInsertionLevel) {
        boolean[] blockedLevels = new boolean[this.depth];
        this.insert(e, blockedLevels, desiredInsertionLevel);
    }

    private void insert(Entry<T> e, boolean[] blockedLevels, int desiredInsertionLevel) {
        RTreeNode<T> node = logic.chooseSubTree(this.root, e, desiredInsertionLevel, this.depth);
        if (logic.hasSpace(node)) {
            node.addEntry(e);
            node.extendParentMBB();
        } else {
            RTreeNode<T> newNode = this.overflowTreatment(node, e, blockedLevels, desiredInsertionLevel);
            if (newNode != null) {
                ++this.nNodes;
                if (desiredInsertionLevel + 1 < this.depth) {
                    this.insert(newNode, blockedLevels, desiredInsertionLevel + 1);
                } else {
                    RTreeNodeDir<T> newRoot = new RTreeNodeDir<T>(this.dims);
                    ++this.nNodes;
                    newRoot.addEntry(newNode);
                    newRoot.addEntry(this.root);
                    this.root = newRoot;
                    ++this.depth;
                }
            }
        }
    }

    private RTreeNode<T> overflowTreatment(RTreeNode<T> node, Entry<T> e, boolean[] blockedLevels, int desiredInsertionLevel) {
        if (node != this.root && !blockedLevels[desiredInsertionLevel]) {
            blockedLevels[desiredInsertionLevel] = true;
            Entry<T>[] toReinsert = logic.reInsert(node, e);
            for (int i = 0; i < toReinsert.length; ++i) {
                this.insert(toReinsert[i], blockedLevels, desiredInsertionLevel);
            }
            return null;
        }
        return logic.split(node, e);
    }

    public void load(Entry<T>[] entries) {
        STRLoader<T> bulkLoader = new STRLoader<T>();
        bulkLoader.load(entries);
        this.size = bulkLoader.getSize();
        this.nNodes = bulkLoader.getNNodes();
        this.root = bulkLoader.getRoot();
        this.depth = bulkLoader.getDepth();
    }

    public Object remove(double[] point) {
        return this.remove(point, point);
    }

    @Override
    public T remove(double[] min, double[] max) {
        MutableRef ref = new MutableRef();
        Predicate<Entry> pred = e -> {
            ref.set(e.checkExactMatch(min, max) ? (Object)e.value() : null);
            return ref.get() != null;
        };
        this.findNodes(min, max, this.root, node -> this.deleteFromNode(node, pred));
        return ref.get();
    }

    @Override
    public boolean remove(double[] min, double[] max, T value) {
        return this.removeIf(min, max, e -> Objects.equals(value, e.value()));
    }

    @Override
    public boolean removeIf(double[] min, double[] max, Predicate<RectangleEntry<T>> condition) {
        Predicate<Entry> pred = e -> e.checkExactMatch(min, max) && condition.test((RectangleEntry)e);
        return this.findNodes(min, max, this.root, node -> this.deleteFromNode(node, pred));
    }

    @Override
    public T update(double[] lo1, double[] up1, double[] lo2, double[] up2) {
        T val = this.remove(lo1, up1);
        if (val != null) {
            this.insert(lo2, up2, val);
        }
        return val;
    }

    @Override
    public boolean update(double[] lo1, double[] up1, double[] lo2, double[] up2, T value) {
        if (this.remove(lo1, up1, value)) {
            this.insert(lo2, up2, value);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(double[] min, double[] max, T value) {
        return this.findNodeEntry(min, max, (entry, node, posInNode) -> Objects.equals(value, entry.value())) != null;
    }

    private T findNodeEntry(double[] min, double[] max, Matcher<T> matcher) {
        int[] positions = new int[this.depth];
        int level = this.depth - 1;
        RTreeNode node = this.root;
        block0: while (level < this.depth) {
            int i;
            ArrayList<Entry<T>> children;
            int pos = positions[level];
            if (node instanceof RTreeNodeDir) {
                children = ((RTreeNodeDir)node).getChildren();
                for (i = pos; i < children.size(); ++i) {
                    RTreeNode sub = (RTreeNode)children.get(i);
                    if (!sub.checkInclusion(min, max)) continue;
                    positions[level] = i + 1;
                    node = sub;
                    positions[--level] = 0;
                    continue block0;
                }
            } else {
                children = node.getEntries();
                for (i = 0; i < children.size(); ++i) {
                    Entry<T> e = children.get(i);
                    if (!e.checkExactMatch(min, max) || !matcher.test(e, node, i)) continue;
                    return e.value();
                }
            }
            node = node.getParent();
            ++level;
        }
        return null;
    }

    void deleteFromNode(RTreeNode<T> node, int pos) {
        --this.size;
        node.removeEntry(pos);
        int level = 0;
        while (node != this.root && node.isUnderfull()) {
            ArrayList<Entry<T>> entries = node.getEntries();
            RTreeNodeDir<T> parent = node.getParent();
            parent.removeChildByIdentity(node);
            node = parent;
            --this.nNodes;
            for (int i = 0; i < entries.size(); ++i) {
                this.insertAtDepth(entries.get(i), level);
            }
            ++level;
        }
        if (this.root.getEntries().size() == 1 && this.root instanceof RTreeNodeDir) {
            --this.depth;
            --this.nNodes;
            this.root = (RTreeNode)this.root.getEntries().get(0);
            this.root.setParent(null);
        }
    }

    private boolean findNodes(double[] min, double[] max, RTreeNode<T> node, CheckNodeAbort<T> checkAbort) {
        if (node instanceof RTreeNodeDir) {
            ArrayList children = ((RTreeNodeDir)node).getChildren();
            for (int i = 0; i < children.size(); ++i) {
                RTreeNode sub = children.get(i);
                if (!sub.checkInclusion(min, max) || !this.findNodes(min, max, sub, checkAbort)) continue;
                return true;
            }
        } else {
            return checkAbort.checkAbort((RTreeNodeLeaf)node);
        }
        return false;
    }

    boolean deleteFromNode(RTreeNode<T> node, Predicate<Entry<T>> pred) {
        boolean found = false;
        for (int i = 0; i < node.getEntries().size(); ++i) {
            if (!pred.test(node.getEntries().get(i))) continue;
            node.removeEntry(i);
            --this.size;
            found = true;
            break;
        }
        int level = 0;
        while (node != this.root && node.isUnderfull()) {
            ArrayList<Entry<T>> entries = node.getEntries();
            RTreeNodeDir<T> parent = node.getParent();
            parent.removeChildByIdentity(node);
            node = parent;
            --this.nNodes;
            for (int i = 0; i < entries.size(); ++i) {
                this.insertAtDepth(entries.get(i), level);
            }
            ++level;
        }
        if (this.root.getEntries().size() == 1 && this.root instanceof RTreeNodeDir) {
            --this.depth;
            --this.nNodes;
            this.root = (RTreeNode)this.root.getEntries().get(0);
            this.root.setParent(null);
        }
        return found;
    }

    @Override
    public T queryExact(double[] min, double[] max) {
        return this.findNodeEntry(min, max, (entry, node, posInNode) -> true);
    }

    public RTreeIterator<T> iterator() {
        double[] min = new double[this.dims];
        double[] max = new double[this.dims];
        Arrays.fill(min, Double.NEGATIVE_INFINITY);
        Arrays.fill(max, Double.POSITIVE_INFINITY);
        return new RTreeIterator(this, min, max);
    }

    public RTreeIterator<T> queryRectangle(double[] min, double[] max) {
        return RTreeIterator.createExactMatch(this, min, max);
    }

    public RTreeIterator<T> queryIntersect(double[] min, double[] max) {
        return new RTreeIterator(this, min, max);
    }

    @Override
    public RectangleEntryDist<T> query1NN(double[] center) {
        return new RTreeQuery1NN(this).reset(center, RectangleDistanceFunction.EDGE);
    }

    public RTreeQueryKnn2<T> queryKNN(double[] center, int k) {
        return this.queryKNN(center, k, RectangleDistanceFunction.EDGE);
    }

    public RTreeQueryKnn2<T> queryKNN(double[] center, int k, RectangleDistanceFunction dist) {
        return new RTreeQueryKnn2(this, k, center, dist, e -> true);
    }

    public Iterable<RectangleEntryDist<T>> queryRangedNearestNeighbor(double[] center, RectangleDistanceFunction dist, RectangleDistanceFunction closestDist, double[] minBound, double[] maxBound) {
        return this.queryRangedNearestNeighbor(center, dist, closestDist, new Filter.RectangleIntersectFilter(minBound, maxBound));
    }

    public Iterable<RectangleEntryDist<T>> queryRangedNearestNeighbor(double[] center, RectangleDistanceFunction dist, RectangleDistanceFunction closestDist, Filter filter) {
        RTree self = this;
        return () -> new RTreeMixedQuery(self, center, filter, dist, closestDist);
    }

    @Override
    public String toStringTree() {
        StringBuilderLn sb = new StringBuilderLn();
        this.toStringTree(sb, this.root, this.depth - 1);
        return sb.toString();
    }

    private void toStringTree(StringBuilderLn sb, RTreeNode<T> node, int level) {
        Object pre = "";
        for (int i = 0; i < this.depth - level; ++i) {
            pre = (String)pre + " ";
        }
        sb.appendLn((String)pre + "L=" + level + " " + node.toString() + ";P=" + System.identityHashCode(node.getParent()));
        ArrayList<Entry<T>> entries = node.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            Entry<T> e = entries.get(i);
            if (e instanceof RTreeNode) {
                this.toStringTree(sb, (RTreeNode)e, level - 1);
                continue;
            }
            sb.append((String)pre).append("e:").append(e.toString()).appendLn();
        }
    }

    @Override
    public RTreeStats getStats() {
        RTreeStats stats = new RTreeStats(this);
        stats.dims = this.dims;
        stats.maxDepth = this.depth;
        this.getStats(stats, this.root, this.depth - 1);
        if (stats.nEntries != this.size) {
            throw new IllegalStateException();
        }
        if (stats.nNodes != this.nNodes) {
            throw new IllegalStateException("Node count/nNodes " + stats.nNodes + "/" + this.nNodes);
        }
        return stats;
    }

    private void getStats(RTreeStats stats, RTreeNode<T> node, int level) {
        if (level < 0) {
            throw new IllegalStateException();
        }
        ++stats.nNodes;
        if (node instanceof RTreeNodeLeaf && level != 0) {
            throw new IllegalStateException();
        }
        ArrayList<Entry<T>> entries = node.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            Entry<T> e = entries.get(i);
            if (!node.checkInclusion(e.min, e.max)) {
                throw new IllegalStateException();
            }
            if (e instanceof RTreeNode) {
                this.getStats(stats, (RTreeNode)e, level - 1);
                continue;
            }
            ++stats.nEntries;
        }
        if (node instanceof RTreeNodeLeaf && node != this.root && entries.size() < 2) {
            throw new IllegalStateException();
        }
        if (node instanceof RTreeNodeLeaf && entries.size() > 10) {
            throw new IllegalStateException();
        }
        if (node instanceof RTreeNodeDir && node != this.root && entries.size() < 2) {
            throw new IllegalStateException();
        }
        if (node instanceof RTreeNodeDir && entries.size() > 10) {
            throw new IllegalStateException();
        }
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getNodeCount() {
        return this.nNodes;
    }

    protected RTreeNode<T> getRoot() {
        return this.root;
    }

    public String toString() {
        return "RTreeZ;" + logic.getClass().getSimpleName() + ";size=" + this.size + ";nNodes=" + this.nNodes + ";dir_m/M=2/10;data_m/M=2/10";
    }

    void incNDist1NN() {
        ++this.nDist1NN;
    }

    void incNDistKNN() {
        ++this.nDistKNN;
    }

    public static class RTreeStats
    extends Stats {
        RTreeStats(RTree<?> tree) {
            super(tree.nDist1NN + tree.nDistKNN, tree.nDist1NN, tree.nDistKNN);
            this.minLevel = 0;
            this.maxLevel = tree.depth;
        }
    }

    private static interface CheckNodeAbort<T> {
        public boolean checkAbort(RTreeNodeLeaf<T> var1);
    }

    private static interface Matcher<T> {
        public boolean test(Entry<T> var1, RTreeNode<T> var2, int var3);
    }
}

