/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.ArrayList;
import java.util.Arrays;
import org.tinspin.index.rtree.Entry;
import org.tinspin.index.rtree.RTreeNode;
import org.tinspin.index.rtree.RTreeNodeLeaf;

class RTreeNodeDir<T>
extends RTreeNode<T> {
    private ArrayList<RTreeNode<T>> children = new ArrayList();

    public RTreeNodeDir(int dim) {
        super(dim);
    }

    @Override
    public void addEntry(Entry<T> e) {
        RTreeNode node = (RTreeNode)e;
        this.children.add(node);
        node.setParent(this);
        if (this.children.size() > 1) {
            this.extendMBB(e);
        } else {
            this.setMBB(e);
        }
    }

    public void removeChildByIdentity(RTreeNode<T> e) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) != e) continue;
            e.setParent(null);
            this.children.remove(i);
            this.recalcMBB();
            this.recalcParentMBB();
            return;
        }
        throw new IllegalStateException();
    }

    public boolean containsLeafNodes() {
        return this.children.get(0) instanceof RTreeNodeLeaf;
    }

    public ArrayList<RTreeNode<T>> getChildren() {
        return this.children;
    }

    @Override
    public ArrayList<Entry<T>> getEntries() {
        return this.children;
    }

    @Override
    public void clear() {
        this.children.clear();
        this.resetMBB();
    }

    @Override
    public boolean hasSpace() {
        return this.children.size() < 10;
    }

    @Override
    public String toString() {
        double[] len = new double[this.min.length];
        Arrays.setAll(len, i -> this.max[i] - this.min[i]);
        return "NodeDir;n=" + this.children.size() + ";min/max=" + Arrays.toString(this.lower()) + "/" + Arrays.toString(this.upper()) + ";lengths=" + Arrays.toString(len) + ";id=" + System.identityHashCode(this);
    }

    @Override
    public boolean isUnderfull() {
        return this.children.size() < 2;
    }
}

