/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.RectangleDistanceFunction;
import org.tinspin.index.RectangleEntryDist;
import org.tinspin.index.rtree.DistEntry;
import org.tinspin.index.rtree.RTree;
import org.tinspin.index.rtree.RTreeNode;
import org.tinspin.index.rtree.RTreeNodeDir;
import org.tinspin.index.rtree.RTreeNodeLeaf;

public class RTreeQueryKnn<T>
implements QueryIteratorKNN<RectangleEntryDist<T>> {
    private final DEComparator COMP = new DEComparator();
    private final RTree<T> tree;
    private double[] center;
    private Iterator<DistEntry<T>> iter;
    private RectangleDistanceFunction dist;
    private final ArrayList<DistEntry<T>> candidates = new ArrayList();
    private final ArrayList<DistEntry<Object>> pool = new ArrayList();
    private final PriorityQueue<DistEntry<Object>> queue = new PriorityQueue(this.COMP);

    public RTreeQueryKnn(RTree<T> tree, double[] center, int k, RectangleDistanceFunction dist) {
        this.tree = tree;
        this.reset(center, k, dist == null ? RectangleDistanceFunction.EDGE : dist);
    }

    @Override
    public RTreeQueryKnn<T> reset(double[] center, int k) {
        this.reset(center, k, null);
        return this;
    }

    public void reset(double[] center, int k, RectangleDistanceFunction dist) {
        if (dist != null) {
            this.dist = dist;
        }
        if (this.dist != RectangleDistanceFunction.EDGE) {
            System.err.println("This distance iterator only works for EDGE distance");
        }
        this.center = center;
        this.pool.addAll(this.queue);
        this.queue.clear();
        this.candidates.clear();
        this.candidates.ensureCapacity(k);
        if (k <= 0 || this.tree.size() == 0) {
            this.iter = this.candidates.iterator();
            return;
        }
        this.search(k);
        this.iter = this.candidates.iterator();
    }

    private void search(int k) {
        RTreeNode<T> eRoot = this.tree.getRoot();
        double dRoot = this.dist(this.center, eRoot.min, eRoot.max);
        this.queue.add(this.createEntry(eRoot.lower(), eRoot.upper(), eRoot, dRoot));
        while (!this.queue.isEmpty()) {
            double d;
            RTreeNode e2;
            int i;
            ArrayList entries;
            DistEntry<Object> candidate = this.queue.poll();
            Object o = candidate.value();
            if (!(o instanceof RTreeNode)) {
                this.candidates.add(candidate);
                if (this.candidates.size() < k) continue;
                return;
            }
            if (o instanceof RTreeNodeLeaf) {
                entries = ((RTreeNodeLeaf)o).getEntries();
                for (i = 0; i < entries.size(); ++i) {
                    e2 = entries.get(i);
                    d = this.dist(this.center, e2.min, e2.max);
                    this.queue.add(this.createEntry(e2.lower(), e2.upper(), e2.value(), d));
                }
                this.pool.add(candidate);
                continue;
            }
            entries = ((RTreeNodeDir)o).getChildren();
            for (i = 0; i < entries.size(); ++i) {
                e2 = (RTreeNode)entries.get(i);
                d = this.dist(this.center, e2.min, e2.max);
                this.queue.add(this.createEntry(e2.lower(), e2.upper(), e2, d));
            }
            this.pool.add(candidate);
        }
    }

    private DistEntry<Object> createEntry(double[] min, double[] max, Object val, double dist) {
        if (this.pool.isEmpty()) {
            return new DistEntry<Object>(min, max, val, dist);
        }
        DistEntry<Object> e = this.pool.remove(this.pool.size() - 1);
        e.set(min, max, val, dist);
        return e;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public DistEntry<T> next() {
        return this.iter.next();
    }

    private double dist(double[] center, double[] min, double[] max) {
        this.tree.incNDistKNN();
        return this.dist.dist(center, min, max);
    }

    private static class DEComparator
    implements Comparator<DistEntry<?>> {
        private DEComparator() {
        }

        @Override
        public int compare(DistEntry<?> o1, DistEntry<?> o2) {
            double d = o1.dist() - o2.dist();
            return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
        }
    }
}

