/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.tinspin.index.QueryIteratorKNN;
import org.tinspin.index.RectangleDistanceFunction;
import org.tinspin.index.RectangleEntry;
import org.tinspin.index.RectangleEntryDist;
import org.tinspin.index.rtree.DistEntry;
import org.tinspin.index.rtree.Entry;
import org.tinspin.index.rtree.RTree;
import org.tinspin.index.rtree.RTreeNode;
import org.tinspin.index.rtree.RTreeNodeLeaf;
import org.tinspin.index.util.MinHeap;
import org.tinspin.index.util.MinMaxHeap;

public class RTreeQueryKnn2<T>
implements QueryIteratorKNN<RectangleEntryDist<T>> {
    private final RTree<T> tree;
    private final RectangleDistanceFunction distFn;
    private final Predicate<RectangleEntry<T>> filterFn;
    MinHeap<NodeDistT> queueN = MinHeap.create((t1, t2) -> t1.dist < t2.dist);
    MinMaxHeap<DistEntry<T>> queueV = MinMaxHeap.create((t1, t2) -> t1.dist() < t2.dist());
    double maxNodeDist = Double.POSITIVE_INFINITY;
    private DistEntry<T> current;
    private int remaining;
    private double[] center;
    private double currentDistance;

    RTreeQueryKnn2(RTree<T> tree, int minResults, double[] center, RectangleDistanceFunction distFn, Predicate<RectangleEntry<T>> filterFn) {
        this.filterFn = filterFn;
        this.distFn = distFn;
        this.tree = tree;
        this.reset(center, minResults);
    }

    @Override
    public QueryIteratorKNN<RectangleEntryDist<T>> reset(double[] center, int minResults) {
        this.center = center;
        this.currentDistance = Double.MAX_VALUE;
        this.remaining = minResults;
        this.maxNodeDist = Double.POSITIVE_INFINITY;
        this.current = null;
        if (minResults <= 0 || this.tree.getRoot() == null) {
            return this;
        }
        this.queueN.clear();
        this.queueV.clear();
        this.queueN.push(new NodeDistT(0.0, this.tree.getRoot()));
        this.FindNextElement();
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public DistEntry<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        DistEntry<T> ret = this.current;
        this.FindNextElement();
        return ret;
    }

    public double distance() {
        return this.currentDistance;
    }

    private void FindNextElement() {
        while (!(this.remaining <= 0 || this.queueN.isEmpty() && this.queueV.isEmpty())) {
            boolean useV;
            boolean bl = useV = !this.queueV.isEmpty();
            if (useV && !this.queueN.isEmpty()) {
                boolean bl2 = useV = this.queueV.peekMin().dist() <= this.queueN.peekMin().dist;
            }
            if (useV) {
                DistEntry<T> result = this.queueV.peekMin();
                this.queueV.popMin();
                --this.remaining;
                this.current = result;
                this.currentDistance = result.dist();
                return;
            }
            NodeDistT top = this.queueN.peekMin();
            this.queueN.popMin();
            RTreeNode node = top.node;
            double dNode = top.dist;
            if (dNode > this.maxNodeDist && this.queueV.size() >= this.remaining) continue;
            if (node instanceof RTreeNodeLeaf) {
                for (Entry entry : node.getEntries()) {
                    double d;
                    if (!this.filterFn.test(entry) || !((d = this.distFn.dist(this.center, entry)) <= this.maxNodeDist)) continue;
                    this.queueV.push(new DistEntry(entry.min, entry.max, entry.value(), d));
                    if (this.queueV.size() < this.remaining) continue;
                    if (this.queueV.size() > this.remaining) {
                        this.queueV.popMax();
                    }
                    double dMax = this.queueV.peekMax().dist();
                    this.maxNodeDist = Math.min(this.maxNodeDist, dMax);
                }
                continue;
            }
            for (Entry o : node.getEntries()) {
                RTreeNode subnode = (RTreeNode)o;
                double dist = this.distFn.dist(this.center, subnode);
                if (!(dist <= this.maxNodeDist)) continue;
                this.queueN.push(new NodeDistT(dist, subnode));
            }
        }
        this.current = null;
        this.currentDistance = Double.MAX_VALUE;
    }

    private class NodeDistT {
        double dist;
        RTreeNode<T> node;

        public NodeDistT(double dist, RTreeNode<T> node) {
            this.dist = dist;
            this.node = node;
        }
    }
}

