/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.rtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.tinspin.index.rtree.Entry;
import org.tinspin.index.rtree.RTreeLogic;
import org.tinspin.index.rtree.RTreeNode;
import org.tinspin.index.rtree.RTreeNodeDir;
import org.tinspin.index.rtree.RTreeNodeLeaf;

public class RStarTreeLogic
implements RTreeLogic {
    private final SortByAxisAsc SORT_BY_AXIS_ASC = new SortByAxisAsc();
    private final SortByAxisDes SORT_BY_AXIS_DES = new SortByAxisDes();

    @Override
    public <T> RTreeNode<T> chooseSubTree(RTreeNode<T> root, Entry<T> e, int desiredInsertionLevel, int nLevels) {
        RTreeNode<T> node = root;
        for (int level = nLevels - 1; level != desiredInsertionLevel; --level) {
            RTreeNodeDir dir = (RTreeNodeDir)node;
            node = dir.containsLeafNodes() ? this.chooseNodeWithNearlyMinimumOverlapCost(dir, e) : this.chooseNodeWithLeastAreaEnlargement(dir, e);
        }
        return node;
    }

    private <T> RTreeNode<T> chooseNodeWithNearlyMinimumOverlapCost(RTreeNodeDir<T> dir, Entry<T> e) {
        int P = Math.min(32, dir.getChildren().size());
        ArrayList<RTreeNode<T>> children = dir.getChildren();
        Object[] areas = new NDPair[P];
        for (int i = 0; i < children.size(); ++i) {
            RTreeNode<T> child = children.get(i);
            double area = this.calcAreaEnlargementSize(child, e);
            if (i < P) {
                areas[i] = new NDPair<T>(area, child);
                if (i != P - 1) continue;
                Arrays.sort(areas);
                continue;
            }
            if (!(areas[P - 1].d > area)) continue;
            areas[P - 1].d = area;
            ((NDPair)areas[P - 1]).node = child;
        }
        int dims = dir.min().length;
        Entry<Object> enlarged = new Entry<Object>(new double[dims], new double[dims], null);
        double bestOverLap = Double.MAX_VALUE;
        RTreeNode bestNode = null;
        for (int i = 0; i < P; ++i) {
            enlarged.setToCover(e, areas[i].node);
            double o = this.calcOverlapSize(enlarged, ((NDPair)areas[i]).node, children);
            if (o < bestOverLap) {
                bestOverLap = o;
                bestNode = ((NDPair)areas[i]).node;
                continue;
            }
            if (o != bestOverLap) continue;
            double aBest = bestNode.calcArea();
            double aNew = ((NDPair)areas[i]).node.calcArea();
            if (!(aNew < aBest)) continue;
            bestOverLap = o;
            bestNode = ((NDPair)areas[i]).node;
        }
        return bestNode;
    }

    private <T> double calcAreaEnlargementSize(RTreeNode<T> node, Entry<T> e) {
        return node.calcAreaEnlarged(e) - node.calcArea();
    }

    private <T> double calcOverlapSize(Entry<T> node, Entry<T> toSkip, ArrayList<RTreeNode<T>> children) {
        double o = 0.0;
        for (int i = 0; i < children.size(); ++i) {
            if (children.get(i) == toSkip) continue;
            o += node.calcOverlap(children.get(i));
        }
        return o;
    }

    private <T> RTreeNode<T> chooseNodeWithLeastAreaEnlargement(RTreeNodeDir<T> dir, Entry<T> e) {
        ArrayList<RTreeNode<T>> children = dir.getChildren();
        double bestAreaEnl = Double.MAX_VALUE;
        RTreeNode<T> bestNode = null;
        for (int i = 0; i < children.size(); ++i) {
            RTreeNode<T> child = children.get(i);
            double areaEnl = this.calcAreaEnlargementSize(child, e);
            if (areaEnl < bestAreaEnl) {
                bestAreaEnl = areaEnl;
                bestNode = child;
            }
            if (areaEnl != bestAreaEnl) continue;
            double aBest = bestNode.calcArea();
            double aNew = child.calcArea();
            if (!(aNew < aBest)) continue;
            bestAreaEnl = areaEnl;
            bestNode = child;
        }
        return bestNode;
    }

    @Override
    public <T> RTreeNode<T> split(RTreeNode<T> node, Entry<T> e) {
        int M = this.getM(node);
        Entry[] children = node.getEntries().toArray(new Entry[M + 1]);
        children[M] = e;
        int splitAxis = this.chooseSplitAxis(children);
        return this.chooseSplitIndex(node, children, splitAxis);
    }

    private <T> int chooseSplitAxis(Entry<T>[] children) {
        int dims = children[0].min().length;
        double[] bufMin = new double[dims];
        double[] bufMax = new double[dims];
        int M = children.length;
        int m = (int)(0.4 * (double)M);
        int kMax = M - 2 * m + 1;
        int kMin = m;
        int kEnd = m + kMax;
        double bestMargin = Double.MAX_VALUE;
        int bestDim = -1;
        for (int d = 0; d < dims; ++d) {
            double totalMargin = 0.0;
            for (int sortOrder = 0; sortOrder < 2; ++sortOrder) {
                if (sortOrder == 0) {
                    this.SORT_BY_AXIS_ASC.setAxis(d);
                    Arrays.sort(children, this.SORT_BY_AXIS_ASC);
                } else {
                    this.SORT_BY_AXIS_DES.setAxis(d);
                    Arrays.sort(children, this.SORT_BY_AXIS_DES);
                }
                for (int k = kMin + 1; k <= kEnd; ++k) {
                    totalMargin += this.calcMargin(children, 0, k, bufMin, bufMax);
                    totalMargin += this.calcMargin(children, k, children.length, bufMin, bufMax);
                }
            }
            if (!(totalMargin < bestMargin)) continue;
            bestMargin = totalMargin;
            bestDim = d;
        }
        return bestDim;
    }

    private <T> double calcMargin(Entry<T>[] entries, int start, int end, double[] min, double[] max) {
        Entry.calcBoundingBox(entries, start, end, min, max);
        return Entry.calcMargin(min, max);
    }

    private <T> RTreeNode<T> chooseSplitIndex(RTreeNode<T> nodeToSplit, Entry<T>[] children, int splitAxis) {
        int i;
        int dims = children[0].min().length;
        double[] bufMin1 = new double[dims];
        double[] bufMax1 = new double[dims];
        double[] bufMin2 = new double[dims];
        double[] bufMax2 = new double[dims];
        int M = children.length - 1;
        int m = (int)(0.4 * (double)M);
        int kMax = M - 2 * m + 1;
        int kMin = m;
        int kEnd = m + kMax;
        int bestSortOrder = -1;
        double bestDeadSpace = Double.MAX_VALUE;
        double bestOverlap = Double.MAX_VALUE;
        int bestIndex = -1;
        this.SORT_BY_AXIS_ASC.setAxis(splitAxis);
        this.SORT_BY_AXIS_DES.setAxis(splitAxis);
        for (int sortOrder = 0; sortOrder < 2; ++sortOrder) {
            if (sortOrder == 0) {
                Arrays.sort(children, this.SORT_BY_AXIS_ASC);
            } else {
                Arrays.sort(children, this.SORT_BY_AXIS_DES);
            }
            for (int k = kMin + 1; k <= kEnd; ++k) {
                double ds1 = Entry.calcDeadspace(children, 0, k, bufMin1, bufMax1);
                double ds2 = Entry.calcDeadspace(children, k, children.length, bufMin2, bufMax2);
                double overlap = Entry.calcOverlap(bufMin1, bufMax1, bufMin2, bufMax2);
                if (!(overlap < bestOverlap) && (overlap != bestOverlap || !(ds1 + ds2 < bestDeadSpace))) continue;
                bestOverlap = overlap;
                bestDeadSpace = ds1 + ds2;
                bestSortOrder = sortOrder;
                bestIndex = k;
            }
        }
        if (bestSortOrder == 0) {
            Arrays.sort(children, this.SORT_BY_AXIS_ASC);
        }
        RTreeNode newNode = nodeToSplit instanceof RTreeNodeDir ? new RTreeNodeDir(dims) : new RTreeNodeLeaf(dims);
        nodeToSplit.clear();
        for (i = 0; i < bestIndex; ++i) {
            nodeToSplit.addEntry(children[i]);
        }
        nodeToSplit.recalcParentMBB();
        for (i = bestIndex; i < children.length; ++i) {
            newNode.addEntry(children[i]);
        }
        return newNode;
    }

    @Override
    public <T> Entry<T>[] reInsert(RTreeNode<T> node, Entry<T> e) {
        int M = this.getM(node);
        Object[] children = new EDPair[M + 1];
        ArrayList<Entry<T>> currentChildren = node.getEntries();
        for (int i = 0; i < M; ++i) {
            Entry<T> c = currentChildren.get(i);
            double cd = Entry.calcCenterDistance(node, c);
            children[i] = new EDPair<T>(cd, c);
        }
        double cd = Entry.calcCenterDistance(node, e);
        children[M] = new EDPair<T>(cd, e);
        Arrays.sort(children);
        int p = (int)(0.3 * (double)(M + 1));
        int nToKeep = M + 1 - p;
        node.clear();
        for (int i = 0; i < nToKeep; ++i) {
            node.addEntry(((EDPair)children[i]).entry);
        }
        node.recalcParentMBB();
        Entry[] toReinsert = new Entry[p];
        for (int i = 0; i < p; ++i) {
            toReinsert[i] = ((EDPair)children[i + nToKeep]).entry;
        }
        return toReinsert;
    }

    @Override
    public <T> boolean hasSpace(RTreeNode<T> node) {
        return node.hasSpace();
    }

    private boolean isLeaf(RTreeNode<?> node) {
        return node instanceof RTreeNodeLeaf;
    }

    private int getM(RTreeNode<?> node) {
        return this.isLeaf(node) ? 10 : 10;
    }

    private class SortByAxisDes
    implements Comparator<Entry<?>> {
        int axis = -1;

        private SortByAxisDes() {
        }

        public void setAxis(int axis) {
            this.axis = axis;
        }

        @Override
        public int compare(Entry<?> o2, Entry<?> o1) {
            double dMin = o1.min()[this.axis] - o2.min()[this.axis];
            if (dMin < 0.0) {
                return -1;
            }
            if (dMin > 0.0) {
                return 1;
            }
            double dMax = o1.max()[this.axis] - o2.max()[this.axis];
            return dMax < 0.0 ? -1 : (dMax > 0.0 ? 1 : 0);
        }
    }

    private class SortByAxisAsc
    implements Comparator<Entry<?>> {
        int axis = -1;

        private SortByAxisAsc() {
        }

        public void setAxis(int axis) {
            this.axis = axis;
        }

        @Override
        public int compare(Entry<?> o1, Entry<?> o2) {
            double dMin = o1.min()[this.axis] - o2.min()[this.axis];
            if (dMin < 0.0) {
                return -1;
            }
            if (dMin > 0.0) {
                return 1;
            }
            double dMax = o1.max()[this.axis] - o2.max()[this.axis];
            return dMax < 0.0 ? -1 : (dMax > 0.0 ? 1 : 0);
        }
    }

    private static class EDPair<T>
    implements Comparable<EDPair<T>> {
        Entry<T> entry;
        double d;

        public EDPair(double d, Entry<T> entry) {
            this.d = d;
            this.entry = entry;
        }

        @Override
        public int compareTo(EDPair<T> o) {
            return this.d < o.d ? -1 : (this.d > o.d ? 1 : 0);
        }
    }

    private static class NDPair<T>
    implements Comparable<NDPair<T>> {
        RTreeNode<T> node;
        double d;

        public NDPair(double d, RTreeNode<T> node) {
            this.d = d;
            this.node = node;
        }

        @Override
        public int compareTo(NDPair<T> o) {
            double dist = this.d - o.d;
            return dist < 0.0 ? -1 : (dist > 0.0 ? 1 : 0);
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }
}

